static char *RCSid = "$Header: ore.c,v 1.6 89/09/26 19:54:32 mr-frog Exp $";

/*
 * rescheck.c
 *
 * Thomas Ruschak
 *
 * For islands at least (ISLANDSIZE/2) big, it makes sure that they
 *     have exactly the resources specified in the MIN, OIL, GOLD, and
 *     URAN arrays. (In non-mountain sectors) It ignores 100/100/100/100
 *     start sectors.
 *
 *     To change the stuff, just change the MIN, OIL, GOLD, and URAN arrays.
 *
 */

/*
 * Modified from:
 * ore.c
 *
 * create the goodies
 *
 * James W. Anderson, 1986
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <fcntl.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "gamesdef.h"
#include "file.h"
#include "path.h"
#include "xy.h"

#define XPLATES		(WORLD_X / 2)
#define YPLATES		WORLD_Y
#define YbyX		(YPLATES*XPLATES)
#define ISLANDSIZE	20
#define ISLANDMAX	1000

int MIN[] = { 85,85,85,70,70,70,70,70 }; /* # should be <= MAX_RES */
int OIL[] = { 90,80,70,60 };
int GOLD[] = { 90,80,70,60 };
int URAN[] = { 90,80,70,60 };

struct	sctstr sects[YPLATES*XPLATES];
u_char	s[YPLATES][XPLATES];
short	c[YPLATES][XPLATES];
short	e[YPLATES][XPLATES];
short	o[YPLATES][XPLATES];
short	g[YPLATES][XPLATES];
short	m[YPLATES][XPLATES];
short	u[YPLATES][XPLATES];
int	size[YbyX];
int	iz[ISLANDMAX],iy[ISLANDMAX],ix[ISLANDMAX],in=0,mnt[ISLANDMAX];

#define	MAX_RES	255	/* Max # of resource sectors to check for */
int	mMIN[YbyX][MAX_RES];
int	oOIL[YbyX][MAX_RES];
int	gGOLD[YbyX][MAX_RES];
int	uURAN[YbyX][MAX_RES];

main(argc, argp)
	int     argc;
	char  **argp;
{
	struct	sctstr sect;
	register struct sctstr *sp;
	register int y;
	register int x;
	int     sectf;
	int	i;
	int	now;
	char	*sectfil;
	int x1,y1,j=roll(6),k,dy,dx,x2,y2;

	sectfil = empfile[EF_SECTOR].file;
	if (argc > 1 && argp[1][0] == '-' && argp[1][1] == 's')
		sectfil = argp[1] + 3;
	time(&now);
	srandom(now);
	sectf = open(sectfil, O_RDWR, 0);
	if (sectf < 0) {
		perror(sectfil);
		exit(1);
	}
	read(sectf, sects, sizeof(sects));
	sp = sects;
	for (y = 0; y < WORLD_Y; y++) {
		for (x = 0; x < WORLD_X; x++) {
			if (((x ^ y) & 1))
				continue;
			c[y][x/2] = 0;
			s[y][x/2] = sp->sct_type;
			e[y][x/2] = sp->sct_elev;
			g[y][x/2] = sp->sct_gmin;
			o[y][x/2] = sp->sct_oil;
			u[y][x/2] = sp->sct_uran;
			m[y][x/2] = sp->sct_min;
			sp++;
		}
	}
	for (y = 0; y < WORLD_Y; y++) {
		for (x = 0; x < WORLD_X; x++) {
			if (((x ^ y) & 1))
				continue;
			if (c[y][x/2] != 0)
				continue;
			makec(x, y, 0);
		}
	}

	for(k=0;k<in;k++){
		int l,printed;
		if (size[iz[k]] < (ISLANDSIZE/2))
		    continue;
		printf("#%d# Island of %d sectors (%d mountains), at %d,%d\n",k+1,size[iz[k]],mnt[iz[k]],ix[k],iy[k]);

		printed=0;
		for(l=0;l<(sizeof(MIN)/sizeof(int));l++)
		    mMIN[iz[k]][MIN[l]]--;

		for(j=1;j<MAX_RES;j++)
			if (mMIN[iz[k]][j] != 0)
				printed=1;
		if (printed){
			for(j=1;j<MAX_RES;j++)
				if (mMIN[iz[k]][j] > 0)
		    			printf("\t%d  min)\t%d OVERFLOW\n",j,mMIN[iz[k]][j]);
				else if (mMIN[iz[k]][j] < 0)
		    			printf("\t%d  min)\t%d UNDERFLOW\n",j,mMIN[iz[k]][j]);
		}

		printed=0;
		for(l=0;l<(sizeof(OIL)/sizeof(int));l++)
		    oOIL[iz[k]][OIL[l]]--;

		for(j=1;j<MAX_RES;j++)
			if (oOIL[iz[k]][j] != 0)
				printed=1;
		if (printed){
			for(j=1;j<MAX_RES;j++)
				if (oOIL[iz[k]][j] > 0)
		    			printf("\t%d  oil)\t%d OVERFLOW\n",j,oOIL[iz[k]][j]);
				else if (oOIL[iz[k]][j] < 0)
		    			printf("\t%d  oil)\t%d UNDERFLOW\n",j,oOIL[iz[k]][j]);
		}

		printed=0;
		for(l=0;l<(sizeof(GOLD)/sizeof(int));l++)
		    gGOLD[iz[k]][GOLD[l]]--;

		for(j=1;j<MAX_RES;j++)
			if (gGOLD[iz[k]][j] != 0)
				printed=1;
		if (printed){
			for(j=1;j<MAX_RES;j++)
				if (gGOLD[iz[k]][j] > 0)
		    			printf("\t%d gold)\t%d OVERFLOW\n",j,gGOLD[iz[k]][j]);
				else if (gGOLD[iz[k]][j] < 0)
		    			printf("\t%d gold)\t%d UNDERFLOW\n",j,gGOLD[iz[k]][j]);
		}

		printed=0;
		for(l=0;l<(sizeof(URAN)/sizeof(int));l++)
		    uURAN[iz[k]][URAN[l]]--;

		for(j=1;j<MAX_RES;j++)
			if (uURAN[iz[k]][j] != 0)
				printed=1;

		if (printed){
			for(j=1;j<MAX_RES;j++)
				if (uURAN[iz[k]][j] > 0)
		    			printf("\t%d uran)\t%d OVERFLOW\n",j,uURAN[iz[k]][j]);
				else if (uURAN[iz[k]][j] < 0)
		    			printf("\t%d uran)\t%d UNDERFLOW\n",j,uURAN[iz[k]][j]);
		}
	}
}

int	cont = 0;

#define max(a,b) (a < b ? b : a)

int
makec(x, y, n)
	int	x;
	int	y;
	int	n;
{
	register int dy;
	register int dx;
	register int dir;
	register short *cp;

	if (s[y][x/2] == SCT_WATER)
		return;

	cp = &c[y][x/2];

	if (*cp != 0)
		return;

	if (n == 0)
		n = ++cont;

	*cp = n;

	size[n]++;

	if (size[n] == (ISLANDSIZE/2)){
		ix[in] = x;
		iy[in] = y;
		iz[in] = n;
		in++;
	}

	if ((s[y][x/2] != SCT_MOUNT) && (s[y][x/2] != SCT_SANCT)){
		if (g[y][x/2] != 0)
			gGOLD[n][g[y][x/2]]++;
		if (o[y][x/2] != 0)
			oOIL[n][o[y][x/2]]++;
		if (u[y][x/2] != 0)
			uURAN[n][u[y][x/2]]++;
		if (m[y][x/2] != 0)
			mMIN[n][m[y][x/2]]++;
	}
	else
		mnt[n]++;

	for (dir = 1; dir <= 6; dir++) {
		dx = (diroff[dir][0] + x + WORLD_X) % WORLD_X;
		dy = (diroff[dir][1] + y + WORLD_Y) % WORLD_Y;
		makec(dx, dy, n);
	}
}

int
min(a, b)
	int	a;
	int	b;
{
	if (a < b)
		return a;
	return b;
}
