#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/disloan.c,v 1.5 89/07/11 02:30:15 kjpires Exp $";
#endif

/*
 * disloan->c
 *
 * Display a loan; there's a lot of stuff going
 * on here to figure out how much people owe.
 * It would be nice to change loans to work on
 * some kind of payment plan...like house payments
 * and such, where the bucks just get paid up each
 * update or so.
 *
 * I'd have made this more like treaty if I weren't
 * so disgusted with how it works.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "loan.h"
#include "nat.h"
#include "file.h"

int
disloan(n, loan)
	int	n;
	register struct lonstr *loan;
{
	time_t	now;
	time_t	due;
	time_t	lastpaydate;
	time_t	normaltime;
	time_t	doubletime;
	time_t	accept;
	double	rate;
	double	owe;

	if (loan->l_status == LS_FREE)
		return 0;
	if (loan->l_ldur == 0)
		return 0;
	if (loan->l_loner != cnum && loan->l_lonee != cnum)
		return 0;
	(void) time(&now);
	pr(fmt("\nLoan #%d from %s to", n, cname(loan->l_loner)));
	pr(fmt(" %s\n", cname(loan->l_lonee)));
	if (loan->l_status == LS_PROPOSED) {
		pr(fmt("(proposed) principal=$%d interest rate=%d%%",
			loan->l_amtdue, loan->l_irate));
		pr(fmt(" duration(days)=%d\n", loan->l_ldur));
		if (loan->l_duedate < now) {
			loan->l_status = LS_FREE;
			putloan(n, loan);
			pr("This offer has expired\n");
			return 0;
		}
		accept = loan->l_lastpay + loan->l_ldur * SECS_PER_DAY;
		pr(fmt("Loan must be accepted by %s", ctime(&accept)));
		return 1;
	}
	due = loan->l_duedate;
	lastpaydate = loan->l_lastpay;
	if (now < due) {
		normaltime = now - lastpaydate;
		doubletime = 0;
	}
	if (lastpaydate < due && due < now) {
		normaltime = due - lastpaydate;
		doubletime = now - due;
	}
	if (due < lastpaydate) {
		normaltime = 0;
		doubletime = now - lastpaydate;
	}
	rate = ((double)loan->l_irate / 100.0) / (loan->l_ldur * SECS_PER_DAY);
	owe = ((double) loan->l_amtdue *
		(((double) normaltime * rate + 1.0) +
		((double) doubletime * rate * 2.0))) + 0.5;
	pr(fmt("Amount paid to date $%d\n", loan->l_amtpaid));
	pr(fmt("Amount due (if paid now) $%.2f", owe));
	if (doubletime == 0) {
		pr(fmt(" (if paid on due date) $%.2f\n",
			loan->l_amtdue * ((due - lastpaydate) * rate + 1.0)));
		pr(fmt("Due date is %s", ctime(&loan->l_duedate)));
	} else
		pr(" ** In Arrears **\n");
	return 1;
}
