#ifndef lint
static char *RCSid = "$Header: set.c,v 1.7 89/09/17 14:32:45 mr-frog Exp $";
#endif

/*
 * set.c
 *
 * Place units on-sale.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "nuke.h"
#include "plane.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "trade.h"
#include "file.h"

/*
 * format: set <type> <SHIP/NUKE> <PRICE>
 */
set()
{
	extern char *argp[];
	char   *p;
	int	type;
	int	price;
	char	*prompt;
	struct	trdstr trade;
	struct	nstr_item ni;
	struct	nstr_item ni_trade;
	union	trdgenstr item;
	struct	sctstr sect;
	int	freeslot;
	int	foundslot;
	int	id;

	if ((p = getstarg(argp[1], "Item type? ")) == 0 || *p == 0)
		return RET_SYN;
	if ((type = ef_byname(p)) < 0) {
		pr(fmt("%s: not an item type\n", p));
		return RET_SYN;
	}
	if (type == EF_SECTOR)
		type = EF_SHIP;
	if (type == EF_NEWS)
		type = EF_NUKE;
	if (!snxtitem(&ni, type, argp[2]))
		return RET_SYN;
	while (nxtitem(&ni, (char *)&item)) {
		if (!owner)
			continue;
		getsect(item.gen.trg_x, item.gen.trg_y, &sect);
		/*
		 * military control necessary to sell
		 * goodies in occupied territory.
		 */
		if (sect.sct_oldown != cnum) {
			if (getvar(V_MILIT, (char *)&sect, EF_SECTOR) * 10
			    < getvar(V_CIVIL, (char *)&sect, EF_SECTOR)) {
			      pr("Military control required to sell goods.\n");
				return RET_FAIL;
			}
		}
		trade.trd_type = type;
		prompt = fmt("%s #%d; Price? ",
			trade_nameof(&trade, &item), ni.cur);
		if ((p = getstarg(argp[3], prompt)) == 0 || *p == 0)
			break;
		if ((price = atoi(p)) < 0)
			continue;
		if (!ef_lock(EF_TRADE)) {
			logerror("can't lock trdae file");
			return RET_SYS;
		}
		foundslot = -1;
		freeslot = -1;
		snxtitem_all(&ni_trade, EF_TRADE);
		while (nxtitem(&ni_trade, (char *)&trade)) {
			if (trade.trd_unitid < 0)
				freeslot = ni_trade.cur;
			if (trade.trd_unitid == ni.cur &&
			    trade.trd_type == type) {
				foundslot = ni_trade.cur;
				break;
			}
		}
		if (price == 0 && foundslot >= 0) {
			pr(fmt("%s #%d (lot #%d) removed from trading\n",
				trade_nameof(&trade, &item),
				ni.cur, foundslot));
			trade.trd_type = 0;
			trade.trd_owner = 0;
			trade.trd_unitid = -1;
			trade.trd_price = 0;
			puttrade(ni_trade.cur, &trade);
		} else if (price > 0) {
			trade.trd_type = type;
			trade.trd_owner = cnum;
			trade.trd_unitid = ni.cur;
			trade.trd_price = price;
			if (foundslot >= 0)
				id = foundslot;
			else if (freeslot >= 0)
				id = freeslot;
			else
				id = ni_trade.cur;
			puttrade(id, &trade);
			pr(fmt("%s #%d (lot #%d) price %s to $%d\n",
				trade_nameof(&trade, &item), ni.cur,
				id, foundslot >= 0 ? "reset" : "set", price));
		}
		ef_unlock(EF_TRADE);
	}
	return RET_OK;
}
