# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 * parser.l -- lex parser of algebraic chess moves for XBoard
 *
 * Original author:  Chris Sears
 * Enhancements (Version 2.0):  Tim Mann
 *
 * XBoard borrows its colors, icon and piece bitmaps from XChess
 * which was written and is copyrighted by Wayne Christopher.
 *
 * Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
 * Enhancements Copyright 1992 Free Software Foundation, Inc.
 *
 * The following terms apply to Digital Equipment Corporation's copyright
 * interest in XBoard:
 * ------------------------------------------------------------------------
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Digital not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * ------------------------------------------------------------------------
 *
 * The following terms apply to the enhanced version of XBoard distributed
 * by the Free Software Foundation:
 * ------------------------------------------------------------------------
 * This file is part of XBOARD.
 *
 * XBOARD is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY.  No author or distributor accepts responsibility to anyone for
 * the consequences of using it or for whether it serves any particular
 * purpose or works at all, unless he says so in writing.  Refer to the XBOARD
 * General Public License for full details.
 *
 * Everyone is granted permission to copy, modify and redistribute XBOARD, but
 * only under the conditions described in the XBOARD General Public License. A
 * copy of this license is supposed to have been given to you along with
 * XBOARD so you can know your rights and responsibilities.  It should be in a
 * file named COPYING.  Among other things, the copyright notice and this
 * notice must be preserved on all copies.
 * ------------------------------------------------------------------------
 *
 * This parser handles all forms of promotion.
 * The parser resolves ambiguous moves by searching and check-testing.
 * It also parses comments of the form [anything] or (anything).
 */
#include "xboard.h"
#include <ctype.h>
#include <string.h>

#define False 0
#define True 1
#define NO_CONSTRAINT	-1
#undef YYLMAX
#define YYLMAX			2048
#define UNPUT_BUF_SIZE		YYLMAX
#undef input
#undef output
#undef unput

#undef WHITE_ON_MOVE
#define WHITE_ON_MOVE		((int) ((yyboardindex % 2) == 0))

extern Board	boards[MAX_MOVES];
int		yyboardindex;
extern int      xboardDebug;
extern FILE	*gameFileFP;
char		currentMoveString[YYLMAX];
char		unputBuffer[UNPUT_BUF_SIZE];
int		unputCount = 0;

static int RookSearch P((int *rank, int *file, ChessSquare piece,
			 int whiteOnMove, Board b,
			 int canmove, int rconstraint, int fconstraint));
static int BishopSearch P((int *rank, int *file, ChessSquare piece,
			   int whiteOnMove, Board b,
			   int canmove, int rconstraint, int fconstraint));
static int KnightSearch P((int *rank, int *file, ChessSquare piece,
			   int whiteOnMove, Board b,
			   int canmove, int rconstraint, int fconstraint));
static int KingSearch P((int *rank, int *file, ChessSquare piece,
			 int whiteOnMove, Board b,
			 int canmove, int rconstraint, int fconstraint));
static int QueenSearch P((int *rank, int *file, ChessSquare piece,
			  int whiteOnMove, Board b,
			  int canmove, int rconstraint, int fconstraint));
static int CheckTest P((int whiteOnMove, Board board,
			int rf, int ff, int rt, int ft));
ChessMove LegalityTest P((int whiteOnMove, Board board,
			  int rf, int ff, int rt, int ft, int promoChar));
int yywrap P((void));
static int input P((void));
static void output P((int ch));
static void unput P((int ch));
extern void CopyBoard P((Board to, Board from));

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{
    /* elapsed time indication, e.g. (0:12) */ 
    return (int) ElapsedTime;
}
break;
case 2:
{
    /* position diagram enclosed in [-- --] */
    return (int) PositionDiagram;
}
break;
case 3:
{        			/* anything in [] */
    return (int) Comment; 
}
break;
case 4:
 { 	  	/* nested () */
    return (int) Comment; 
}
break;
case 5:
  { 				/* >=2 chars in () */
    return (int) Comment; 
}
break;
case 6:
{
    /*
     * Fully-qualified algebraic move, possibly with promotion
     */
    int skip1 = 0, skip2 = 0;
    ChessSquare piece;
    ChessMove result;
    
    /*
     * remove the / 
     */
    if (yytext[1] == '/') skip1 = 1;
    
    /*
     * remove the [xX:-] 
     */
    if ((yytext[3+skip1] == 'x') || (yytext[3+skip1] == 'X') ||
	(yytext[3+skip1] == '-') || (yytext[3+skip1] == ':')) skip2 = 1;
    
    currentMoveString[0] = yytext[1+skip1];
    currentMoveString[1] = yytext[2+skip1];
    currentMoveString[2] = yytext[3+skip1+skip2];
    currentMoveString[3] = yytext[4+skip1+skip2];
    currentMoveString[4] = NULLCHAR;
    
    if (yyleng-skip1-skip2 > 5) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    piece = boards[yyboardindex]
      [currentMoveString[1] - '1'][currentMoveString[0] - 'a'];
    if (ToLower(yytext[0]) != ToLower(PieceToChar(piece)))
      return (int) BadMove;

    result = LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 7:
{
    /*
     * Simple algebraic move, possibly with promotion
     */
    int skip = 0;
    ChessMove result;

    /*
     * remove the [xX:-] 
     */
    if ((yytext[2] == 'x') || (yytext[2] == 'X') ||
	(yytext[2] == '-') || (yytext[2] == ':')) skip = 1;

    currentMoveString[0] = yytext[0];
    currentMoveString[1] = yytext[1];
    currentMoveString[2] = yytext[2+skip];
    currentMoveString[3] = yytext[3+skip];
    currentMoveString[4] = NULLCHAR;

    if (yyleng-skip > 4) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    result = LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 8:
{
    /*
     * Pawn move, possibly with promotion
     */
    int rank, file;
    ChessMove result;

    currentMoveString[0] = yytext[0];
    currentMoveString[1] = yytext[1];
    currentMoveString[2] = yytext[0];
    currentMoveString[3] = yytext[1];
    currentMoveString[4] = NULLCHAR;

    rank = yytext[1] - '1';
    file = yytext[0] - 'a';

    if (WHITE_ON_MOVE) {
	if (rank <= 0) return (int) BadMove;
	if (rank == 3 && boards[yyboardindex][2][file] == EmptySquare)
	  currentMoveString[1] -= 2;
	else
	  currentMoveString[1]--;
    } else {
	if (rank >= 7) return (int) BadMove;
	if (rank == 4 && boards[yyboardindex][5][file] == EmptySquare)
	  currentMoveString[1] += 2;
	else
	  currentMoveString[1]++;
    }

    if (yyleng > 2) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    result = LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 9:
{
    /*
     * Pawn capture, possibly with promotion, possibly ambiguous
     */
    int i, file0, file1, skip = 0, found = 0;
    ChessMove result;

    /*
     * remove the [xX:-]
     */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip = 1;

    file0 = yytext[0] - 'a';
    file1 = yytext[1+skip] - 'a';

    currentMoveString[0] = yytext[0];
    currentMoveString[2] = yytext[1+skip];
    if (yyleng-skip > 2) {
	if (yytext[yyleng-1] == ')')
	  currentMoveString[4] = ToLower(yytext[yyleng-2]);
	else
	  currentMoveString[4] = ToLower(yytext[yyleng-1]);
	currentMoveString[5] = NULLCHAR;
    } else {
	currentMoveString[4] = NULLCHAR;
    }

    if (WHITE_ON_MOVE) {
	for (i = 1; i < BOARD_SIZE - 1; i++) {
	    if (boards[yyboardindex][i][file0] == WhitePawn) {
		result = LegalityTest(True, boards[yyboardindex],
				      i, file0, i + 1, file1,
				      currentMoveString[4]);
		if (result != BadMove) {
		    found++;
		    if (found > 1) return (int) AmbiguousMove;
		    currentMoveString[1] = '1' + i;
		    currentMoveString[3] = '1' + i + 1;
		}
	    }
	}
    } else {
	for (i = 1; i < BOARD_SIZE - 1; i++) {
	    if (boards[yyboardindex][i][file0] == BlackPawn) {
		result = LegalityTest(False, boards[yyboardindex],
				      i, file0, i - 1, file1,
				      currentMoveString[4]);
		if (result != BadMove) {
		    found++;
		    if (found > 1) return (int) AmbiguousMove;
		    currentMoveString[1] = '1' + i;
		    currentMoveString[3] = '1' + i - 1;
		}
	    }
	}
    }

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 10:
{
    /*
     * unambiguously abbreviated Pawn capture, possibly with promotion
     */
    int skip = 0;
    ChessMove result;

    /*
     * remove the [xX:-]
     */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip = 1;

    currentMoveString[0] = yytext[0];
    currentMoveString[2] = yytext[1+skip];
    currentMoveString[3] = yytext[2+skip];
    if (WHITE_ON_MOVE) {
	if (yytext[2+skip] == '1') return (int) BadMove;
	currentMoveString[1] = yytext[2+skip] - 1;
    } else {
	if (yytext[2+skip] == '8') return (int) BadMove;
	currentMoveString[1] = yytext[2+skip] + 1;
    }
    if (yyleng-skip > 3) {
	if (yytext[yyleng-1] == ')')
	  currentMoveString[4] = ToLower(yytext[yyleng-2]);
	else
	  currentMoveString[4] = ToLower(yytext[yyleng-1]);
	currentMoveString[5] = NULLCHAR;
    } else {
	currentMoveString[4] = NULLCHAR;
    }

    result = LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    if (result != BadMove) return (int) result;

    /* Special case: improperly written en passant capture */
    if (WHITE_ON_MOVE) {
	if (currentMoveString[3] == '5') {
	    currentMoveString[1] = '5';
	    currentMoveString[3] = '6';
	} else {
	    return (int) BadMove;
	}
    } else {
	if (currentMoveString[3] == '4') {
	    currentMoveString[1] = '4';
	    currentMoveString[3] = '3';
	} else {
	    return (int) BadMove;
	}
    }

    result = LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (result == WhiteCapturesEnPassant || result == BlackCapturesEnPassant)
      return (int) result;
    else
      return (int) BadMove;
}
break;
case 11:
 {
    /*
     * piece move, possibly ambiguous
     */
    int rank, file, found;
    ChessMove r, result = NormalMove;
    ChessSquare piece;

    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) {
	currentMoveString[2] = yytext[2];
	currentMoveString[3] = yytext[3];
    } else {
	currentMoveString[2] = yytext[1];
	currentMoveString[3] = yytext[2];
    }
    currentMoveString[4] = NULLCHAR;

    rank = currentMoveString[3] - '1';
    file = currentMoveString[2] - 'a';

    switch (yytext[0]) {
      case 'R': case 'r':
	piece = WHITE_ON_MOVE ? WhiteRook : BlackRook;
	found = RookSearch(&rank, &file, piece,
			   WHITE_ON_MOVE, boards[yyboardindex],
			   True, NO_CONSTRAINT, NO_CONSTRAINT);
	break;
      case 'B': case 'b':
	piece = WHITE_ON_MOVE ? WhiteBishop : BlackBishop;
	found = BishopSearch(&rank, &file, piece,
			     WHITE_ON_MOVE, boards[yyboardindex],
			     True, NO_CONSTRAINT, NO_CONSTRAINT);
	break;
      case 'N': case 'n':
	piece = WHITE_ON_MOVE ? WhiteKnight : BlackKnight;
	found = KnightSearch(&rank, &file, piece,
			     WHITE_ON_MOVE, boards[yyboardindex],
			     True, NO_CONSTRAINT, NO_CONSTRAINT);
	break;
      case 'Q': case 'q':
	piece = WHITE_ON_MOVE ? WhiteQueen : BlackQueen;
	found = QueenSearch(&rank, &file, piece,
			    WHITE_ON_MOVE, boards[yyboardindex],
			    True, NO_CONSTRAINT, NO_CONSTRAINT);
	break;
      case 'K': case 'k':
	piece = WHITE_ON_MOVE ? WhiteKing : BlackKing;
	found = KingSearch(&rank, &file, piece,
			   WHITE_ON_MOVE, boards[yyboardindex],
			   True, NO_CONSTRAINT, NO_CONSTRAINT);
	if (found == 0 && (rank == 0 || rank == 7) &&
	    (file == 2 || file == 6)) {
	    /* Try castling */
	    if (boards[yyboardindex][rank][4] == piece) {
	        r = LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
				 rank, 4, rank, file, NULLCHAR);
		if (r != BadMove) {
		    found++;
		    result = r;
		    file = 4;
		}
	    }
	}
	break;
    }

    switch (found) {
      case 1: 
	currentMoveString[0] = file + 'a';
	currentMoveString[1] = rank + '1';
	return (int) result;
      case 0:
	return (int) BadMove;
      default:
	return (int) AmbiguousMove;
    }
}
break;
case 12:
{
    /*
     * piece move with rank or file disambiguator
     */
    int rc, fc, rank, file, found;
    ChessMove r, result = NormalMove;
    ChessSquare piece;

    if ((yytext[2] == 'x') || (yytext[2] == 'X')
	|| (yytext[2] == ':') || (yytext[2] == '-')) {
	currentMoveString[2] = yytext[3];
	currentMoveString[3] = yytext[4];
	rank = yytext[4] - '1'; file = yytext[3] - 'a';
    } else {
	currentMoveString[2] = yytext[2];
	currentMoveString[3] = yytext[3];
	rank = yytext[3] - '1'; file = yytext[2] - 'a';
    }

    currentMoveString[4] = NULLCHAR;

    if (isalpha(yytext[1])) {
	fc = yytext[1] - 'a';
	rc = NO_CONSTRAINT;
    } else {
	fc = NO_CONSTRAINT;
	rc = yytext[1] - '1';
    }

    switch (yytext[0]) {
      case 'R': case 'r':
	piece = WHITE_ON_MOVE ? WhiteRook : BlackRook;
	found = RookSearch(&rank, &file, piece, WHITE_ON_MOVE,
			   boards[yyboardindex], True, rc, fc);
	break;
      case 'B': case 'b':
	piece = WHITE_ON_MOVE ? WhiteBishop : BlackBishop;
	found = BishopSearch(&rank, &file, piece, WHITE_ON_MOVE,
			     boards[yyboardindex], True, rc, fc);
	break;
      case 'N': case 'n':
	piece = WHITE_ON_MOVE ? WhiteKnight : BlackKnight;
	found = KnightSearch(&rank, &file, piece, WHITE_ON_MOVE,
			     boards[yyboardindex], True, rc, fc);
	break;
      case 'Q': case 'q':
	piece = WHITE_ON_MOVE ? WhiteQueen : BlackQueen;
	found = QueenSearch(&rank, &file, piece, WHITE_ON_MOVE,
			    boards[yyboardindex], True, rc, fc);
	break;
      case 'K': case 'k':
	piece = WHITE_ON_MOVE ? WhiteKing : BlackKing;
	found = KingSearch(&rank, &file, piece, WHITE_ON_MOVE,
			   boards[yyboardindex], True, rc, fc);
	if (found == 0 && (rank == 0 || rank == 7) &&
	    (file == 2 || file == 6)) {
	    /* Try castling */
	    if ((rc == NO_CONSTRAINT || rc == rank) &&
		(fc == NO_CONSTRAINT || fc == 4) &&
		(boards[yyboardindex][rank][4] == piece)) {
	        r = LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
				 rank, 4, rank, file, NULLCHAR);
		if (r != BadMove) {
		    found++;
		    result = r;
		    file = 4;
		}
	    }
	}
	break;
    }

    switch (found) {
      case 1: 
	currentMoveString[0] = file + 'a';
	currentMoveString[1] = rank + '1';
	return (int) result;
      case 0:
	return (int) BadMove;
      default:
	return (int) AmbiguousMove;
    }
}
break;
case 13:
{
    int rf, ff, rt, ft;

    if (WHITE_ON_MOVE) {
	strcpy(currentMoveString, "e1c1");
	rf = 0;
	ff = 4;
	rt = 0;
	ft = 2;
    } else{ 
	strcpy(currentMoveString, "e8c8");
	rf = 7;
	ff = 4;
	rt = 7;
	ft = 2;
    }
    return (int) LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
			      rf, ff, rt, ft, NULLCHAR);
}
break;
case 14:
{
    int rf, ff, rt, ft;

    if (WHITE_ON_MOVE) {
	strcpy(currentMoveString, "e1g1");
	rf = 0;
	ff = 4;
	rt = 0;
	ft = 6;
    } else {
	strcpy(currentMoveString, "e8g8");
	rf = 7;
	ff = 4;
	rt = 7;
	ft = 6;
    }
    return (int) LegalityTest(WHITE_ON_MOVE, boards[yyboardindex],
			      rf, ff, rt, ft, NULLCHAR);
}
break;
case 15:
 {
    if (WHITE_ON_MOVE)
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 16:
 {
    return (int) BlackWins;
}
break;
case 17:
 {
    return (int) WhiteWins;
}
break;
case 18:
 {
    return (int) WhiteWins;
}
break;
case 19:
 {
    return (int) BlackWins;
}
break;
case 20:
 {
    return (int) GameIsDrawn;
}
break;
case 21:
 {
    if (WHITE_ON_MOVE)
      return (int) WhiteWins;
    else
      return (int) BlackWins;
}
break;
case 22:
 {
    return (int) GameIsDrawn;
}
break;
case 23:
{
    return (int) GameIsDrawn;
}
break;
case 24:
 {
    return (int) GameIsDrawn;
}
break;
case 25:
{ 
    return (int) WhiteWins;
}
break;
case 26:
{ 
    return (int) BlackWins;
}
break;
case 27:
{ 
    return (int) BlackWins;
}
break;
case 28:
{ 
    return (int) WhiteWins;
}
break;
case 29:
{ 
    return (int) WhiteWins;
}
break;
case 30:
{ 
    return (int) BlackWins;
}
break;
case 31:
{
    return (int) GameIsDrawn;
}
break;
case 32:
   {
    /* move numbers */
    /* note: above regular expression assumes game starts from
       conventional opening position, so that only pawn and
       knight moves are legal. */
    
    if ((yyleng == 1) && (yytext[0] == '1'))
      return (int) StartGame;
}
break;
case 33:
{
    return (int) StartGame;
}
break;
case 34:
		{
        /* Skip random words */
}
break;
case 35:
			{
        /* Skip everything else */
}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */


/*
    Test whether a piece of the given type attacks the square (*rank, *file)
    on board b, assuming it moves as a rook.  If canmove is True, the
    piece must be able to move legally to the square; otherwise we test
    only if it attacks the square.  rconstraint is either NO_CONSTRAINT or
    the rank the piece must start on; fconstraint is either NO_CONSTRAINT
    or the file the piece must start on.  Upon return, *rank and *file
    are modified to point to one of the pieces found, if any, and the
    function return value is the number of pieces found.
*/

static int RookSearch(rank, file, piece,
                      whiteOnMove, b, canmove, rconstraint, fconstraint)
     int *rank, *file, whiteOnMove, canmove, rconstraint, fconstraint;
     ChessSquare piece;
     Board b;
{
    int i, r = *rank, f = *file, found = 0;
    
    /*
     * Start from the target space and work outwards towards the piece.
     * This is necessary for check testing.
     */
    for (i = f + 1;; i++) {
	if (i >= BOARD_SIZE)
	  break;
	if ((b[r][i] != EmptySquare) && (b[r][i] != piece))
	  break;
	if (fconstraint != NO_CONSTRAINT && i != fconstraint)
	  continue;
	if (rconstraint != NO_CONSTRAINT && (r != rconstraint))
	  break;
	if (canmove)
	  if (CheckTest(whiteOnMove, b, r, i, r, f))
	    continue;
	if (b[r][i] == piece) {
	    *file = i;
	    found++;
	    break;
	}
    }
    
    for (i = f - 1;; i--) {
	if (i < 0)
	  break;
	if ((b[r][i] != EmptySquare) && (b[r][i] != piece))
	  break;
	if (fconstraint != NO_CONSTRAINT && (i != fconstraint))
	  continue;
	if (rconstraint != NO_CONSTRAINT && (r != rconstraint))
	  break;
	if (canmove)
	  if (CheckTest(whiteOnMove, b, r, i, r, f))
	    continue;
	if (b[r][i] == piece) {
	    *file = i;
	    found++;
	    break;
	}
    }
    
    for (i = r + 1;; i++) {
	if (i >= BOARD_SIZE)
	  break;
	if ((b[i][f] != EmptySquare) && (b[i][f] != piece))
	  break;
	if (fconstraint != NO_CONSTRAINT && (f != fconstraint))
	  break;
	if (rconstraint != NO_CONSTRAINT && (i != rconstraint))
	  continue;
	if (canmove)
	  if (CheckTest(whiteOnMove, b, i, f, r, f))
	    continue;
	if (b[i][f] == piece) {
	    *rank = i;
	    found++;
	    break;
	}
    }
    
    for (i = r - 1;; i--) {
	if (i < 0)
	  break;
	if ((b[i][f] != EmptySquare) && (b[i][f] != piece))
	  break;
	if (fconstraint != NO_CONSTRAINT && (f != fconstraint))
	  break;
	if (rconstraint != NO_CONSTRAINT && (i != rconstraint))
	  continue;
	if (canmove)
	  if (CheckTest(whiteOnMove, b, i, f, r, f))
	    continue;
	if (b[i][f] == piece) {
	    *rank = i;
	    found++;
	    break;
	}
    }
    
    return found;
}

/*
    Test whether a piece of the given type attacks the square (*rank, *file)
    on board b, assuming it moves as a bishop.  If canmove is True, the
    piece must be able to move legally to the square; otherwise we test
    only if it attacks the square.  rconstraint is either NO_CONSTRAINT or
    the rank the piece must start on; fconstraint is either NO_CONSTRAINT
    or the file the piece must start on.  Upon return, *rank and *file
    are modified to point to one of the pieces found, if any, and the
    function return value is the number of pieces found.
*/

static int BishopSearch(rank, file, piece, whiteOnMove, b,
			canmove, rconstraint, fconstraint)
     int *rank, *file, whiteOnMove, canmove, rconstraint, fconstraint;
     ChessSquare piece;
     Board b;
{
    int i, j, ii, jj, r = *rank, f = *file, found = 0;
    
    for (ii = -1; ii <= 1; ii += 2)
      for (jj = -1; jj <= 1; jj += 2) {
	  /*
	   * Start from the target space and work outwards towards the piece.
	   * This is necessary for check testing.
	   */
	  for (i = r + ii, j = f + jj;; i += ii, j += jj) {
	      if ((i < 0) || (i >= BOARD_SIZE) || (j < 0) || (j >= BOARD_SIZE))
		break;
	      if ((b[i][j] != EmptySquare) && (b[i][j] != piece))
		break;
	      if (fconstraint != NO_CONSTRAINT && (j != fconstraint))
		continue;
	      if (rconstraint != NO_CONSTRAINT && (i != rconstraint))
		continue;
	      if (canmove)
		if (CheckTest(whiteOnMove, b, i, j, r, f)) {
		    continue;
		}
	      if (b[i][j] == piece) {
		  *rank = i;
		  *file = j;
		  found++;
		  break;
	      }
	  }
      }	  

    return found;
}

/*
    Test whether a piece of the given type attacks the square (*rank, *file)
    on board b, assuming it moves as a knight.  If canmove is True, the
    piece must be able to move legally to the square; otherwise we test
    only if it attacks the square.  rconstraint is either NO_CONSTRAINT or
    the rank the piece must start on; fconstraint is either NO_CONSTRAINT
    or the file the piece must start on.  Upon return, *rank and *file
    are modified to point to one of the pieces found, if any, and the
    function return value is the number of pieces found.
*/

static int KnightSearch(rank, file, piece,
			whiteOnMove, b, canmove, rconstraint, fconstraint)
     int *rank, *file, whiteOnMove, canmove, rconstraint, fconstraint;
     ChessSquare piece;
     Board b;
{
    int i, j, s, rr, ff, r = *rank, f = *file, found = 0;

    for (i = -1; i <= 1; i += 2)
      for (j = -1; j <= 1; j += 2)
	for (s = 1; s <= 2; s++) {
	    rr = r + i*s;
	    ff = f + j*(3-s);
	    if (rr < 0 || rr > 7 || ff < 0 || ff > 7) continue;
	    if (rconstraint != NO_CONSTRAINT && rr != rconstraint) continue;
	    if (fconstraint != NO_CONSTRAINT && ff != fconstraint) continue;
	    if (b[rr][ff] == piece &&
		!(canmove && CheckTest(whiteOnMove, b, rr, ff, r, f))) {
		*rank = rr;
		*file = ff;
		found++;
	    }
	}
    return found;
}


/*
    Test whether a piece of the given type attacks the square (*rank, *file)
    on board b, assuming it moves as a king.  If canmove is True, the
    piece must be able to move legally to the square; otherwise we test
    only if it attacks the square.  rconstraint is either NO_CONSTRAINT or
    the rank the piece must start on; fconstraint is either NO_CONSTRAINT
    or the file the piece must start on.  Upon return, *rank and *file
    are modified to point to one of the pieces found, if any, and the
    function return value is the number of pieces found.
*/

static int KingSearch(rank, file, piece,
		      whiteOnMove, b, canmove, rconstraint, fconstraint)
     int *rank, *file, whiteOnMove, canmove, rconstraint, fconstraint;
     ChessSquare piece;
     Board b;
{
    int i, j, rr, ff, r = *rank, f = *file, found = 0;

    for (i = -1; i <= 1; i++)
      for (j = -1; j <= 1; j++) {
	  if (i == 0 && j == 0) continue;
	  rr = r + i;
	  ff = f + j;
	  if (rr < 0 || rr > 7 || ff < 0 || ff > 7) continue;
	  if (rconstraint != NO_CONSTRAINT && rr != rconstraint) continue;
	  if (fconstraint != NO_CONSTRAINT && ff != fconstraint) continue;
	  if (b[rr][ff] == piece &&
	      !(canmove && CheckTest(whiteOnMove, b, rr, ff, r, f))) {
	      *rank = rr;
	      *file = ff;
	      found++;
	  }
      }
    return found;
}


/*
    Test whether a piece of the given type attacks the square (*rank, *file)
    on board b, assuming it moves as a queen.  If canmove is True, the
    piece must be able to move legally to the square; otherwise we test
    only if it attacks the square.  rconstraint is either NO_CONSTRAINT or
    the rank the piece must start on; fconstraint is either NO_CONSTRAINT
    or the file the piece must start on.  Upon return, *rank and *file
    are modified to point to one of the pieces found, if any, and the
    function return value is the number of pieces found.
*/

static int QueenSearch(rank, file, piece,
		       whiteOnMove, b, canmove, rconstraint, fconstraint)
     int *rank, *file, whiteOnMove, canmove, rconstraint, fconstraint;
     ChessSquare piece;
     Board b;
{
    int rrook = *rank, frook = *file, nrook;
    int rbishop = *rank, fbishop = *file, nbishop;
    
    nrook = RookSearch(&rrook, &frook, piece,
		       whiteOnMove, b, canmove, rconstraint, fconstraint);
    nbishop = BishopSearch(&rbishop, &fbishop, piece,
			   whiteOnMove, b, canmove, rconstraint, fconstraint);
    if (nrook > 0) {
	*rank = rrook;
	*file = frook;
    } else if (nbishop > 0) {
	*rank = rbishop;
	*file = fbishop;
    }

    return nrook + nbishop;
}

/*
    Return True if moving from (rf, ff) to (rt, ft) is illegal
    because it would leave the player on move in check.
*/
static int CheckTest(whiteOnMove, board, rf, ff, rt, ft)
     int whiteOnMove;
     Board board;
     int rf, ff, rt, ft;
{
    int rk, fk, rank, file;
    Board b;
    
    CopyBoard(b, board);
    b[rt][ft] = b[rf][ff];
    b[rf][ff] = EmptySquare;
    
    for (rk = 0; rk < BOARD_SIZE; rk++) {
	for (fk = 0; fk < BOARD_SIZE; fk++) {
	    if (b[rk][fk] == (whiteOnMove ? WhiteKing : BlackKing)) {
		if (whiteOnMove) {
		    if (rk+1 <= 7) {
			if (fk-1 >= 0 && b[rk+1][fk-1] == BlackPawn)
			  return True;
			if (fk+1 <= 7 && b[rk+1][fk+1] == BlackPawn)
			  return True;
		    }
		} else {
		    if (rk-1 >= 0) {
			if (fk-1 >= 0 && b[rk-1][fk-1] == WhitePawn)
			  return True;
			if (fk+1 <= 7 && b[rk-1][fk+1] == WhitePawn)
			  return True;
		    }
		}
		rank = rk; file = fk;
		if (KnightSearch(&rank, &file,
				 whiteOnMove ? BlackKnight : WhiteKnight,
				 whiteOnMove, b, False,
				 NO_CONSTRAINT, NO_CONSTRAINT))
		  return True;
		rank = rk; file = fk;
		if (BishopSearch(&rank, &file,
				 whiteOnMove ? BlackBishop : WhiteBishop,
				 whiteOnMove, b, False,
				 NO_CONSTRAINT, NO_CONSTRAINT))
		  return True;
		rank = rk; file = fk;
		if (RookSearch(&rank, &file,
			       whiteOnMove ? BlackRook : WhiteRook,
			       whiteOnMove, b, False, 
			       NO_CONSTRAINT, NO_CONSTRAINT))
		  return True;
		rank = rk; file = fk;
		if (QueenSearch(&rank, &file,
				whiteOnMove ? BlackQueen : WhiteQueen,
				whiteOnMove, b, False, 
				NO_CONSTRAINT, NO_CONSTRAINT))
		  return True;
		rank = rk; file = fk;
		if (KingSearch(&rank, &file,
			       whiteOnMove ? BlackKing : WhiteKing,
			       whiteOnMove, b, False,
			       NO_CONSTRAINT, NO_CONSTRAINT))
		  return True;
	    }
	}
    }
    
    return False;
}

/*
    Test whether moving from (rf, ff) to (rt, ft) and promoting
    to promoChar is legal.  If the move is not a promotion, promoChar
    must be NULLCHAR.  If the move is a promotion, and promoChar is
    NULLCHAR, we assume the promotion is to a queen.
*/
ChessMove LegalityTest(whiteOnMove, board, rf, ff, rt, ft, promoChar)
     int whiteOnMove;
     Board board;
     int rf, ff, rt, ft;
     int promoChar;
{
    ChessSquare piece, dpiece;
    int rank, file, rookfile, dir;

    piece = board[rf][ff];
    if (whiteOnMove) {
	if ((int) piece < (int) WhitePawn || (int) piece > (int) WhiteKing)
	  return BadMove;
    } else {
	if ((int) piece < (int) BlackPawn || (int) piece > (int) BlackKing)
	  return BadMove;
    }

    switch (piece) {
      case WhitePawn:
	if (CheckTest(whiteOnMove, board, rf, ff, rt, ft)) return BadMove;
	if (ft == ff) {
	    /* Non-capture */
	    if (rt == rf + 1) {
		if (board[rt][ft] != EmptySquare) return BadMove;
	    } else {
		if ((rf != 1) || (rt != 3) ||
		    (board[rf + 1][ft] != EmptySquare) ||
		    (board[rt][ft] != EmptySquare)) return BadMove;
	    }
	} else {
	    /* Capture */
	    if ((ft != ff - 1) && (ft != ff + 1)) return BadMove;
	    if (rt != rf + 1) return BadMove;
	    dpiece = board[rt][ft];
	    if (dpiece == EmptySquare && rf == 4 &&
		board[rf][ft] == BlackPawn &&
		board[rt + 1][ft] == EmptySquare)
	      /* For now, don't check whether black just moved */
	      return WhiteCapturesEnPassant;
	    if ((int) dpiece < (int) BlackPawn ||
		(int) dpiece > (int) BlackKing)
	      return BadMove;
	}
	switch (promoChar) {
	  case NULLCHAR:
	    if (rt == 7) return WhitePromotionQueen;
	    return NormalMove;
	  case 'n':
	  case 'N':
	    if (rt != 7) return BadMove;
	    return WhitePromotionKnight;
	  case 'b':
	  case 'B':
	    if (rt != 7) return BadMove;
	    return WhitePromotionBishop;
	  case 'r':
	  case 'R':
	    if (rt != 7) return BadMove;
	    return WhitePromotionRook;
	  case 'q':
	  case 'Q':
	    if (rt != 7) return BadMove;
	    return WhitePromotionQueen;
	  default:
	    return BadMove;
	}
      case BlackPawn:
	if (CheckTest(whiteOnMove, board, rf, ff, rt, ft)) return BadMove;
	if (ft == ff) {
	    /* Non-capture */
	    if (rt == rf - 1) {
		if (board[rt][ft] != EmptySquare) return BadMove;
	    } else {
		if ((rf != 6) || (rt != 4) ||
		    (board[rf - 1][ft] != EmptySquare) ||
		    (board[rt][ft] != EmptySquare)) return BadMove;
	    }
	} else {
	    /* Capture */
	    if ((ft != ff - 1) && (ft != ff + 1)) return BadMove;
	    if (rt != rf - 1) return BadMove;
	    dpiece = board[rt][ft];
	    if (dpiece == EmptySquare && rf == 3 &&
		board[rf][ft] == WhitePawn &&
		board[rt - 1][ft] == EmptySquare)
	      /* For now, don't check whether white just moved */
	      return BlackCapturesEnPassant;
	    if ((int) dpiece < (int) WhitePawn ||
		(int) dpiece > (int) WhiteKing)
	      return BadMove;
	}
	switch (promoChar) {
	  case NULLCHAR:
	    if (rt == 0) return BlackPromotionQueen;
	    return NormalMove;
	  case 'n':
	  case 'N':
	    if (rt != 0) return BadMove;
	    return BlackPromotionKnight;
	  case 'b':
	  case 'B':
	    if (rt != 0) return BadMove;
	    return BlackPromotionBishop;
	  case 'r':
	  case 'R':
	    if (rt != 0) return BadMove;
	    return BlackPromotionRook;
	  case 'q':
	  case 'Q':
	    if (rt != 0) return BadMove;
	    return BlackPromotionQueen;
	  default:
	    return BadMove;
	}
      case WhiteKnight:
      case BlackKnight:
	rank = rt; file = ft;
	if (KnightSearch(&rank, &file, piece,
			 whiteOnMove, board, True, rf, ff) != 1)
	  return BadMove;
	break;
      case WhiteBishop:
      case BlackBishop:
	rank = rt; file = ft;
	if (BishopSearch(&rank, &file, piece,
			 whiteOnMove, board, True, rf, ff) != 1)
	  return BadMove;
	break;
      case WhiteRook:
      case BlackRook:
	rank = rt; file = ft;
	if (RookSearch(&rank, &file, piece,
		       whiteOnMove, board, True, rf, ff) != 1)
	  return BadMove;
	break;
      case WhiteQueen:
      case BlackQueen:
	rank = rt; file = ft;
	if (QueenSearch(&rank, &file, piece,
			whiteOnMove, board, True, rf, ff) != 1)
	  return BadMove;
	break;
      case WhiteKing:
      case BlackKing:
	if (ff == 4 && (ft == 6 || ft == 2)) {
	    /* Test for legal castling move */
	    if ((rt != rf) ||
		(whiteOnMove && rf != 0) ||
		(!whiteOnMove && rf != 7))
	      return BadMove;
	    if (ft == 2) {
		dir = -1;
		rookfile = 0;
	    } else {
		dir = 1;
		rookfile = 7;
	    }
	    file = ff + dir;
	    while (file != rookfile) {
		if (board[rt][file] != EmptySquare) return BadMove;
		file += dir;
	    }
	    if (board[rt][rookfile] != (whiteOnMove ? WhiteRook : BlackRook))
	      return BadMove;
	    if (CheckTest(whiteOnMove, board, rf, ff, rf, ff) ||
		CheckTest(whiteOnMove, board, rf, ff, rf, ff + dir) ||
		CheckTest(whiteOnMove, board, rf, ff, rt, ft))
	      return BadMove;
	    /* For now, we don't check if the king or rook has moved */
	    if (whiteOnMove) {
		if (ft == 2)
		  return WhiteQueenSideCastle;
		else
		  return WhiteKingSideCastle;
	    } else {
		if (ft == 2)
		  return BlackQueenSideCastle;
		else
		  return BlackKingSideCastle;
	    }
	}
	rank = rt; file = ft;
	if (KingSearch(&rank, &file, piece,
		       whiteOnMove, board, True, rf, ff) != 1)
	  return BadMove;
	break;
      case EmptySquare:
      default:
	return BadMove;
    }
    if (promoChar != NULLCHAR) return BadMove;
    dpiece = board[rt][ft];
    if (dpiece == EmptySquare) return NormalMove;
    if (whiteOnMove) {
	if ((int) dpiece < (int) BlackPawn || (int) dpiece > (int) BlackKing)
	  return BadMove;
    } else {
	if ((int) dpiece < (int) WhitePawn || (int) dpiece > (int) WhiteKing)
	  return BadMove;
    }	
    return NormalMove;
}


int yywrap()
{
    return True;
}

static char *StringToLex;

static int input()
{
    int ret;
    
    if (StringToLex != NULL) {
	ret = *StringToLex;
	if (ret == NULLCHAR)
	  ret = EOF;
	else
	  StringToLex++;
    } else if (unputCount > 0) {
	ret = unputBuffer[--unputCount];
    } else {
	ret = fgetc(gameFileFP);
    }    

    if (ret == EOF) 
      return 0;
    else
      return ret;
}

static void output(ch)
     int ch;
{
    fprintf(stderr, "PARSER BUG: unmatched character '%c' (0%o)\n",
	    ch, ch);
}

static void unput(ch)
     int ch;
{
    if (ch == 0) return;
    if (StringToLex != NULL) {
	StringToLex--;
    } else {
	if (unputCount >= UNPUT_BUF_SIZE)
	  fprintf(stderr, "PARSER BUG: unput buffer overflow '%c' (0%o)\n",
		  ch, ch);
	unputBuffer[unputCount++] = ch;
    }
}

void yynewfile()
{
    unputCount = 0;
}

/* Parse a move from the given string */
/* Return a pointer to the first unparsed character 
   in "next" if it is non-NULL */
ChessMove yylexstr(boardIndex, s, next)
     int boardIndex;
     char *s;
     char **next;
{
    ChessMove ret;
    
    StringToLex = s;
    yyboardindex = boardIndex;
    ret = (ChessMove) yylex();
    if (next != NULL) *next = StringToLex;
    StringToLex = NULL;
    return ret;
}
int yyvstop[] = {
0,

35,
0,

34,
35,
0,

35,
0,

34,
35,
0,

34,
35,
-32,
0,

34,
35,
-32,
0,

26,
34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

25,
34,
35,
0,

35,
0,

34,
35,
0,

26,
34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
35,
0,

34,
0,

34,
0,

14,
34,
0,

34,
0,

34,
-32,
0,

32,
34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

14,
34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

3,
0,

34,
0,

8,
34,
0,

34,
0,

34,
0,

9,
34,
0,

34,
0,

8,
34,
0,

34,
0,

9,
34,
0,

34,
0,

34,
0,

34,
0,

14,
34,
0,

14,
34,
0,

30,
34,
0,

30,
0,

13,
34,
0,

32,
0,

29,
34,
0,

29,
0,

31,
0,

34,
0,

34,
0,

34,
0,

34,
0,

11,
34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

14,
34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

9,
34,
0,

34,
0,

8,
34,
0,

34,
0,

8,
34,
0,

9,
0,

10,
34,
0,

9,
34,
0,

9,
34,
0,

34,
0,

34,
0,

8,
34,
0,

9,
0,

9,
34,
0,

10,
11,
34,
0,

9,
34,
0,

14,
34,
0,

5,
0,

5,
0,

4,
0,

34,
0,

11,
34,
0,

12,
34,
0,

11,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

24,
34,
0,

34,
0,

21,
34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

8,
0,

8,
0,

7,
34,
0,

10,
0,

9,
0,

10,
34,
0,

9,
0,

7,
12,
34,
0,

10,
11,
0,

10,
11,
34,
0,

10,
34,
0,

34,
0,

26,
0,

12,
0,

26,
34,
0,

6,
34,
0,

34,
0,

24,
34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

34,
0,

25,
0,

25,
34,
0,

7,
0,

7,
34,
0,

10,
0,

10,
0,

7,
12,
0,

1,
5,
0,

28,
0,

26,
0,

6,
0,

6,
34,
0,

34,
0,

34,
0,

34,
0,

15,
34,
0,

34,
0,

34,
0,

27,
0,

25,
0,

2,
3,
0,

7,
0,

7,
0,

31,
0,

26,
0,

6,
0,

6,
0,

24,
0,

34,
0,

34,
0,

34,
0,

15,
34,
0,

34,
0,

34,
0,

25,
0,

17,
0,

26,
0,

34,
0,

34,
0,

34,
0,

16,
0,

25,
0,

17,
0,

34,
0,

20,
34,
0,

16,
0,

23,
0,

34,
0,

34,
0,

23,
0,

34,
0,

34,
0,

33,
34,
0,

19,
0,

22,
0,

26,
0,

33,
0,

18,
0,

25,
0,

28,
0,

22,
0,

27,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,3,	1,3,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
1,4,	1,5,	1,3,	0,0,	
0,0,	0,0,	1,4,	6,34,	
1,3,	1,6,	1,7,	1,8,	
1,8,	1,8,	1,8,	1,8,	
1,8,	1,8,	1,8,	1,3,	
6,35,	36,101,	6,36,	6,37,	
29,88,	37,102,	1,4,	1,9,	
1,10,	1,11,	1,4,	41,107,	
1,12,	6,38,	1,4,	10,54,	
1,13,	1,4,	1,14,	1,13,	
1,15,	1,16,	1,13,	1,17,	
1,18,	1,4,	16,48,	44,108,	
1,19,	1,4,	1,4,	51,122,	
1,20,	11,56,	1,3,	12,58,	
14,60,	15,62,	1,21,	1,22,	
1,23,	1,24,	1,25,	1,26,	
1,27,	1,28,	53,124,	10,55,	
35,99,	35,100,	54,125,	55,126,	
1,29,	18,67,	56,127,	57,128,	
1,18,	2,8,	2,8,	2,8,	
2,8,	2,8,	2,8,	2,8,	
42,108,	11,57,	42,109,	12,59,	
14,61,	58,129,	29,89,	15,63,	
59,129,	34,96,	60,130,	34,97,	
16,64,	16,64,	16,64,	16,64,	
16,64,	16,64,	16,64,	16,64,	
33,0,	18,68,	34,98,	61,131,	
62,132,	63,102,	19,69,	33,94,	
33,94,	40,104,	65,134,	40,105,	
67,136,	68,137,	2,20,	70,143,	
33,94,	33,95,	71,144,	72,72,	
73,145,	88,168,	40,106,	89,102,	
90,169,	91,170,	4,30,	2,28,	
96,175,	97,176,	98,177,	99,178,	
4,30,	104,179,	2,29,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	105,180,	19,70,	106,181,	
110,184,	111,186,	112,187,	113,189,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	19,71,	114,191,	
110,185,	111,186,	112,188,	113,190,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	4,30,	4,30,	
4,30,	4,30,	5,31,	114,192,	
122,199,	124,203,	125,204,	126,205,	
127,206,	128,206,	5,31,	5,31,	
47,116,	47,116,	47,116,	47,116,	
47,116,	47,116,	47,116,	47,116,	
48,117,	48,117,	48,117,	48,117,	
48,117,	48,117,	48,117,	48,117,	
50,121,	50,121,	50,121,	50,121,	
50,121,	50,121,	50,121,	50,121,	
94,169,	130,209,	109,182,	131,209,	
5,31,	5,32,	5,0,	94,94,	
94,94,	132,210,	5,31,	95,169,	
5,31,	5,33,	5,33,	109,183,	
94,94,	94,95,	95,174,	95,174,	
134,211,	135,212,	5,33,	5,31,	
136,213,	137,214,	143,223,	95,174,	
109,183,	138,215,	5,31,	5,31,	
5,31,	5,31,	5,31,	144,224,	
5,31,	129,207,	5,31,	139,217,	
5,31,	5,31,	5,31,	5,31,	
5,31,	5,31,	5,31,	5,31,	
5,31,	5,31,	7,39,	7,39,	
5,31,	5,31,	5,31,	150,147,	
151,228,	157,156,	5,31,	158,235,	
168,241,	138,216,	5,31,	5,31,	
5,31,	5,31,	5,31,	5,31,	
5,31,	140,218,	115,193,	139,217,	
129,208,	7,40,	171,0,	178,102,	
115,193,	184,245,	185,246,	187,248,	
5,31,	188,249,	189,250,	8,39,	
8,39,	141,220,	7,41,	7,39,	
7,42,	7,43,	7,43,	7,43,	
7,43,	7,43,	7,43,	7,43,	
7,43,	7,43,	7,43,	7,44,	
190,251,	140,219,	115,193,	186,247,	
129,208,	13,47,	8,39,	13,48,	
115,193,	13,49,	13,49,	13,49,	
13,49,	13,49,	13,49,	13,49,	
13,49,	141,221,	13,50,	7,45,	
8,39,	7,45,	8,43,	8,43,	
8,43,	8,43,	8,43,	8,43,	
8,43,	8,43,	8,43,	8,43,	
183,243,	182,183,	191,252,	186,247,	
192,253,	193,254,	7,45,	7,45,	
7,45,	7,45,	7,45,	7,45,	
7,45,	7,45,	182,183,	199,257,	
13,47,	183,244,	203,257,	7,45,	
8,45,	7,45,	8,45,	204,259,	
205,259,	13,52,	13,52,	13,52,	
13,52,	13,52,	13,52,	13,52,	
13,52,	210,102,	211,265,	212,266,	
213,267,	193,254,	9,46,	8,45,	
8,45,	8,45,	8,45,	8,45,	
8,45,	8,45,	8,45,	206,260,	
13,47,	207,262,	214,268,	9,47,	
8,45,	9,48,	8,45,	9,49,	
9,49,	9,49,	9,49,	9,49,	
9,49,	9,49,	9,49,	215,269,	
9,50,	64,133,	64,133,	64,133,	
64,133,	64,133,	64,133,	64,133,	
64,133,	75,146,	75,146,	75,146,	
75,146,	75,146,	75,146,	75,146,	
75,146,	207,262,	9,51,	77,154,	
77,154,	77,154,	77,154,	77,154,	
77,154,	77,154,	77,154,	216,270,	
218,272,	206,261,	9,47,	78,80,	
78,80,	78,80,	78,80,	78,80,	
78,80,	78,80,	78,80,	9,52,	
9,52,	9,52,	9,52,	9,52,	
9,52,	9,52,	9,52,	17,47,	
219,273,	17,48,	9,53,	17,49,	
17,49,	17,49,	17,49,	17,49,	
17,49,	17,49,	17,49,	174,169,	
17,50,	206,261,	9,47,	220,274,	
221,275,	223,277,	174,242,	174,242,	
224,277,	20,72,	226,228,	17,65,	
231,235,	233,232,	234,284,	174,242,	
241,102,	20,72,	20,72,	79,155,	
79,155,	79,155,	79,155,	79,155,	
79,155,	79,155,	79,155,	208,263,	
217,271,	242,286,	17,47,	81,159,	
81,159,	81,159,	81,159,	81,159,	
81,159,	81,159,	81,159,	17,52,	
17,52,	17,52,	17,52,	17,66,	
17,52,	17,52,	17,52,	20,72,	
20,72,	20,72,	222,276,	243,244,	
245,289,	20,73,	244,287,	20,72,	
20,72,	20,72,	246,290,	208,264,	
217,271,	142,222,	17,47,	248,293,	
249,294,	20,72,	20,72,	142,222,	
250,295,	244,288,	251,296,	252,297,	
253,298,	20,72,	20,72,	20,72,	
20,72,	20,72,	257,46,	20,72,	
261,260,	20,72,	222,276,	20,72,	
20,72,	20,72,	20,72,	20,72,	
20,72,	20,72,	20,72,	20,72,	
20,72,	142,222,	263,312,	20,72,	
20,72,	20,72,	264,313,	142,222,	
259,305,	20,74,	262,310,	265,314,	
266,314,	20,72,	20,72,	20,72,	
20,72,	20,72,	20,72,	20,72,	
83,164,	83,164,	83,164,	83,164,	
83,164,	83,164,	83,164,	83,164,	
21,75,	267,315,	268,316,	20,72,	
21,76,	21,76,	21,76,	21,76,	
21,76,	21,76,	21,76,	21,76,	
259,305,	21,77,	262,311,	269,317,	
22,46,	84,165,	84,165,	84,165,	
84,165,	84,165,	84,165,	84,165,	
84,165,	270,318,	272,321,	273,322,	
274,323,	22,81,	275,324,	22,48,	
277,69,	22,82,	22,82,	22,82,	
22,82,	22,82,	22,82,	22,82,	
22,82,	281,280,	22,83,	21,78,	
116,194,	116,194,	116,194,	116,194,	
116,194,	116,194,	116,194,	116,194,	
21,79,	21,80,	21,79,	21,79,	
21,79,	21,79,	21,79,	21,79,	
22,51,	282,329,	87,155,	87,155,	
87,155,	87,155,	87,155,	87,155,	
87,155,	87,155,	283,284,	287,330,	
22,84,	288,331,	254,299,	21,78,	
276,325,	289,332,	290,333,	292,334,	
293,335,	22,85,	22,86,	22,85,	
22,86,	22,86,	22,86,	22,86,	
22,86,	23,75,	294,335,	295,336,	
22,53,	23,76,	23,76,	23,76,	
23,76,	23,76,	23,76,	23,76,	
23,76,	296,337,	23,77,	297,338,	
22,84,	117,195,	117,195,	117,195,	
117,195,	117,195,	117,195,	117,195,	
117,195,	24,75,	87,126,	247,291,	
23,54,	24,76,	24,76,	24,76,	
24,76,	24,76,	24,76,	24,76,	
24,76,	254,300,	24,77,	276,326,	
291,292,	298,339,	247,292,	300,299,	
23,78,	118,120,	118,120,	118,120,	
118,120,	118,120,	118,120,	118,120,	
118,120,	23,79,	23,80,	23,79,	
23,80,	23,79,	23,79,	23,79,	
23,87,	303,302,	24,56,	304,343,	
305,60,	310,350,	311,351,	307,345,	
24,78,	254,300,	312,352,	276,326,	
291,292,	247,291,	247,292,	313,353,	
23,78,	24,79,	24,79,	24,80,	
24,79,	24,80,	24,79,	24,79,	
24,79,	119,196,	119,196,	119,196,	
119,196,	119,196,	119,196,	119,196,	
119,196,	315,356,	24,57,	316,357,	
305,61,	25,75,	299,340,	307,346,	
24,78,	25,76,	25,76,	25,76,	
25,76,	25,76,	25,76,	25,76,	
25,76,	317,358,	25,77,	120,197,	
120,197,	120,197,	120,197,	120,197,	
120,197,	120,197,	120,197,	318,359,	
271,319,	26,75,	320,360,	321,361,	
322,361,	26,76,	26,76,	26,76,	
26,76,	26,76,	26,76,	26,76,	
26,76,	308,347,	26,77,	271,320,	
309,348,	299,341,	319,320,	323,362,	
25,78,	121,198,	121,198,	121,198,	
121,198,	121,198,	121,198,	121,198,	
121,198,	25,79,	25,79,	25,79,	
25,80,	25,79,	25,80,	25,79,	
25,79,	324,363,	326,325,	328,329,	
330,366,	332,367,	333,368,	336,370,	
26,78,	308,347,	271,319,	271,320,	
309,349,	299,341,	319,320,	337,370,	
25,78,	26,79,	26,79,	26,79,	
26,79,	26,80,	26,79,	26,80,	
26,79,	27,75,	338,371,	147,226,	
339,371,	27,76,	27,76,	27,76,	
27,76,	27,76,	27,76,	27,76,	
27,76,	342,343,	27,77,	147,226,	
26,78,	314,354,	147,226,	147,226,	
148,152,	148,152,	148,152,	148,152,	
148,152,	148,152,	148,152,	148,152,	
344,0,	334,369,	345,374,	314,355,	
28,75,	325,364,	27,58,	147,226,	
28,76,	28,76,	28,76,	28,76,	
28,76,	28,76,	28,76,	28,76,	
27,78,	28,77,	341,373,	147,226,	
346,375,	314,354,	147,226,	147,226,	
347,376,	27,79,	27,79,	27,79,	
27,79,	27,79,	27,80,	27,79,	
27,80,	334,369,	31,90,	314,355,	
348,377,	349,378,	27,59,	350,379,	
351,380,	352,381,	31,90,	31,90,	
325,365,	353,381,	356,382,	28,78,	
27,78,	357,383,	341,373,	354,355,	
358,384,	359,385,	360,386,	362,387,	
28,79,	28,79,	28,79,	28,79,	
28,79,	28,79,	28,80,	28,79,	
149,227,	149,227,	149,227,	149,227,	
149,227,	149,227,	149,227,	149,227,	
31,90,	31,91,	31,0,	363,387,	
325,365,	367,390,	31,90,	28,78,	
31,90,	31,90,	31,90,	354,355,	
368,390,	370,392,	360,386,	372,0,	
373,395,	374,396,	31,90,	31,90,	
365,389,	369,391,	375,397,	377,398,	
378,399,	379,400,	31,90,	31,90,	
31,90,	31,90,	31,90,	380,400,	
31,90,	382,402,	31,90,	383,402,	
31,90,	31,90,	31,90,	31,90,	
31,90,	31,90,	31,90,	31,90,	
31,90,	31,90,	384,403,	32,91,	
31,90,	31,90,	31,90,	385,403,	
365,389,	369,391,	31,90,	32,91,	
32,91,	386,404,	31,90,	31,90,	
31,90,	31,90,	31,90,	31,90,	
31,90,	152,229,	152,229,	152,229,	
152,229,	152,229,	152,229,	152,229,	
152,229,	388,0,	389,407,	390,408,	
31,90,	391,409,	392,410,	396,412,	
397,412,	398,413,	399,414,	39,39,	
39,39,	32,91,	32,92,	32,93,	
403,418,	386,404,	404,419,	32,91,	
413,431,	32,91,	32,91,	32,91,	
401,0,	414,432,	421,442,	393,394,	
395,411,	424,447,	425,448,	32,91,	
32,91,	405,406,	39,39,	417,0,	
407,420,	409,423,	392,410,	32,91,	
32,91,	32,91,	32,91,	32,91,	
426,449,	32,91,	410,424,	32,91,	
39,39,	32,91,	32,91,	32,91,	
32,91,	32,91,	32,91,	32,91,	
32,91,	32,91,	32,91,	393,394,	
395,411,	32,91,	32,91,	32,91,	
427,450,	405,406,	429,451,	32,91,	
407,420,	409,423,	430,452,	32,91,	
32,91,	32,91,	32,91,	32,91,	
32,91,	32,91,	410,425,	401,416,	
39,103,	411,426,	39,103,	153,228,	
43,39,	43,39,	419,439,	420,440,	
422,443,	32,91,	416,0,	153,229,	
153,229,	153,229,	153,229,	153,229,	
153,229,	153,229,	153,229,	39,103,	
39,103,	39,103,	39,103,	39,103,	
39,103,	39,103,	39,103,	43,39,	
431,453,	49,118,	432,454,	401,417,	
39,103,	411,427,	39,103,	423,445,	
437,458,	440,463,	419,439,	420,441,	
422,444,	43,39,	49,119,	43,43,	
43,43,	43,43,	43,43,	43,43,	
43,43,	43,43,	43,43,	43,43,	
43,43,	436,0,	417,436,	441,464,	
443,465,	46,110,	160,162,	160,162,	
160,162,	160,162,	160,162,	160,162,	
160,162,	160,162,	444,465,	423,446,	
46,111,	46,112,	438,459,	46,113,	
49,118,	43,45,	46,114,	43,45,	
435,0,	416,435,	439,461,	46,115,	
445,466,	49,120,	49,120,	49,120,	
49,120,	49,120,	49,120,	49,120,	
49,120,	46,110,	446,467,	447,468,	
43,45,	43,45,	43,45,	43,45,	
43,45,	43,45,	43,45,	43,45,	
46,111,	46,112,	438,460,	46,113,	
49,118,	43,45,	46,114,	43,45,	
52,118,	416,381,	439,462,	46,115,	
52,123,	52,123,	52,123,	52,123,	
52,123,	52,123,	52,123,	52,123,	
448,468,	52,119,	161,236,	161,236,	
161,236,	161,236,	161,236,	161,236,	
161,236,	161,236,	449,469,	450,469,	
66,118,	451,470,	452,471,	435,457,	
66,123,	66,123,	66,123,	66,123,	
66,123,	66,123,	66,123,	66,123,	
436,457,	66,119,	453,472,	442,422,	
454,473,	457,0,	458,438,	52,118,	
162,237,	162,237,	162,237,	162,237,	
162,237,	162,237,	162,237,	162,237,	
52,120,	52,120,	52,120,	52,120,	
52,120,	52,120,	52,120,	52,120,	
459,475,	260,306,	460,475,	461,476,	
462,477,	463,478,	464,478,	66,118,	
466,479,	467,479,	146,156,	442,422,	
468,480,	69,138,	458,438,	52,118,	
66,120,	66,120,	66,120,	66,120,	
66,120,	66,120,	66,120,	66,120,	
69,139,	69,140,	260,307,	260,308,	
76,147,	469,481,	69,141,	146,157,	
470,428,	76,148,	66,135,	69,142,	
146,158,	471,428,	472,482,	66,118,	
473,483,	408,421,	476,484,	260,309,	
468,480,	69,138,	76,149,	371,393,	
146,158,	76,150,	387,405,	146,158,	
146,158,	477,484,	76,151,	478,485,	
69,139,	69,140,	260,307,	260,308,	
481,340,	371,394,	69,141,	408,422,	
387,406,	412,428,	76,151,	69,142,	
146,158,	76,151,	76,151,	482,428,	
483,428,	408,421,	412,429,	260,309,	
76,148,	485,364,	0,0,	371,393,	
146,158,	0,0,	387,405,	146,158,	
146,158,	76,152,	76,153,	76,152,	
76,152,	76,152,	76,152,	76,152,	
76,152,	371,394,	123,200,	408,422,	
387,406,	412,428,	76,151,	0,0,	
80,156,	76,151,	76,151,	0,0,	
0,0,	0,0,	412,430,	123,201,	
76,148,	80,155,	80,155,	80,155,	
80,155,	80,155,	80,155,	80,155,	
80,155,	0,0,	82,147,	163,228,	
0,0,	80,157,	0,0,	82,160,	
0,0,	0,0,	80,158,	163,237,	
163,237,	163,237,	163,237,	163,237,	
163,237,	163,237,	163,237,	0,0,	
82,161,	123,200,	80,158,	82,150,	
376,307,	80,158,	80,158,	0,0,	
82,151,	0,0,	123,202,	123,202,	
123,202,	123,202,	123,202,	123,202,	
123,202,	123,202,	0,0,	0,0,	
82,151,	376,309,	80,158,	82,151,	
82,151,	418,437,	0,0,	0,0,	
0,0,	0,0,	82,160,	0,0,	
0,0,	123,200,	80,158,	0,0,	
376,307,	80,158,	80,158,	82,162,	
82,163,	82,162,	82,162,	82,162,	
82,162,	82,162,	82,162,	418,438,	
0,0,	0,0,	0,0,	0,0,	
82,151,	376,309,	85,156,	82,151,	
82,151,	418,437,	0,0,	85,118,	
0,0,	156,231,	82,160,	85,166,	
85,166,	85,166,	85,166,	85,166,	
85,166,	85,166,	85,166,	0,0,	
85,119,	156,231,	0,0,	85,157,	
156,231,	156,231,	0,0,	418,438,	
85,158,	164,238,	164,238,	164,238,	
164,238,	164,238,	164,238,	164,238,	
164,238,	0,0,	0,0,	0,0,	
85,158,	156,231,	0,0,	85,158,	
85,158,	0,0,	0,0,	0,0,	
0,0,	0,0,	85,118,	0,0,	
0,0,	156,231,	0,0,	0,0,	
156,231,	156,231,	0,0,	85,120,	
85,167,	85,120,	85,120,	85,120,	
85,120,	85,120,	85,120,	0,0,	
0,0,	0,0,	155,232,	0,0,	
85,158,	0,0,	0,0,	85,158,	
85,158,	0,0,	0,0,	86,118,	
0,0,	0,0,	85,118,	86,166,	
86,166,	86,166,	86,166,	86,166,	
86,166,	86,166,	86,166,	155,233,	
86,119,	0,0,	0,0,	0,0,	
155,234,	0,0,	0,0,	0,0,	
0,0,	92,92,	0,0,	0,0,	
0,0,	167,235,	0,0,	0,0,	
155,234,	92,92,	92,92,	155,234,	
155,234,	167,197,	167,197,	167,197,	
167,197,	167,197,	167,197,	167,197,	
167,197,	0,0,	86,118,	0,0,	
0,0,	0,0,	0,0,	0,0,	
155,234,	0,0,	0,0,	86,120,	
86,120,	86,120,	86,120,	86,120,	
86,120,	86,120,	86,120,	92,92,	
155,234,	92,169,	0,0,	155,234,	
155,234,	92,92,	0,0,	92,92,	
92,92,	92,92,	0,0,	0,0,	
0,0,	0,0,	86,118,	0,0,	
0,0,	92,92,	92,92,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	92,92,	92,92,	92,92,	
92,92,	92,92,	0,0,	92,92,	
0,0,	92,92,	0,0,	92,92,	
92,92,	92,92,	92,92,	92,92,	
92,92,	92,92,	92,92,	92,92,	
92,92,	0,0,	93,171,	92,92,	
92,92,	92,92,	0,0,	0,0,	
0,0,	92,92,	93,171,	93,171,	
0,0,	92,92,	92,92,	92,92,	
92,92,	92,92,	92,92,	92,92,	
196,256,	196,256,	196,256,	196,256,	
196,256,	196,256,	196,256,	196,256,	
0,0,	0,0,	0,0,	92,92,	
200,202,	200,202,	200,202,	200,202,	
200,202,	200,202,	200,202,	200,202,	
93,171,	93,172,	93,173,	0,0,	
0,0,	0,0,	93,171,	0,0,	
93,171,	93,171,	93,171,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	93,171,	93,171,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	93,171,	93,171,	
93,171,	93,171,	93,171,	0,0,	
93,171,	0,0,	93,171,	0,0,	
93,171,	93,171,	93,171,	93,171,	
93,171,	93,171,	93,171,	93,171,	
93,171,	93,171,	0,0,	0,0,	
93,171,	93,171,	93,171,	0,0,	
133,200,	0,0,	93,171,	0,0,	
0,0,	0,0,	93,171,	93,171,	
93,171,	93,171,	93,171,	93,171,	
93,171,	133,201,	201,255,	201,255,	
201,255,	201,255,	201,255,	201,255,	
201,255,	201,255,	145,145,	0,0,	
93,171,	0,0,	0,0,	0,0,	
0,0,	0,0,	145,145,	145,145,	
202,258,	202,258,	202,258,	202,258,	
202,258,	202,258,	202,258,	202,258,	
0,0,	0,0,	0,0,	133,200,	
227,279,	227,279,	227,279,	227,279,	
227,279,	227,279,	227,279,	227,279,	
133,202,	133,202,	133,202,	133,202,	
133,202,	133,202,	133,202,	133,202,	
145,145,	145,145,	145,145,	0,0,	
0,0,	0,0,	145,225,	0,0,	
145,145,	145,145,	145,145,	0,0,	
0,0,	0,0,	0,0,	133,200,	
0,0,	0,0,	145,145,	145,145,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	145,145,	145,145,	
145,145,	145,145,	145,145,	0,0,	
145,145,	0,0,	145,145,	0,0,	
145,145,	145,145,	145,145,	145,145,	
145,145,	145,145,	145,145,	145,145,	
145,145,	145,145,	0,0,	0,0,	
145,145,	145,145,	145,145,	0,0,	
0,0,	0,0,	0,0,	0,0,	
154,156,	0,0,	145,145,	145,145,	
145,145,	145,145,	145,145,	145,145,	
145,145,	154,230,	154,230,	154,230,	
154,230,	154,230,	154,230,	154,230,	
154,230,	0,0,	159,156,	0,0,	
145,145,	154,157,	0,0,	0,0,	
0,0,	0,0,	154,231,	159,194,	
159,194,	159,194,	159,194,	159,194,	
159,194,	159,194,	159,194,	0,0,	
0,0,	0,0,	154,231,	159,157,	
0,0,	154,231,	154,231,	0,0,	
159,158,	236,285,	236,285,	236,285,	
236,285,	236,285,	236,285,	236,285,	
236,285,	0,0,	0,0,	0,0,	
159,158,	0,0,	154,231,	159,158,	
159,158,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
165,156,	0,0,	154,231,	0,0,	
0,0,	154,231,	154,231,	0,0,	
159,158,	165,239,	165,239,	165,239,	
165,239,	165,239,	165,239,	165,239,	
165,239,	0,0,	0,0,	0,0,	
159,158,	165,157,	0,0,	159,158,	
159,158,	229,280,	165,158,	166,232,	
0,0,	0,0,	0,0,	0,0,	
166,200,	0,0,	0,0,	0,0,	
0,0,	0,0,	165,158,	0,0,	
0,0,	165,158,	165,158,	0,0,	
0,0,	166,201,	229,281,	0,0,	
166,233,	0,0,	0,0,	229,282,	
0,0,	166,234,	0,0,	0,0,	
0,0,	0,0,	165,158,	0,0,	
0,0,	0,0,	0,0,	229,282,	
0,0,	166,234,	229,282,	229,282,	
166,234,	166,234,	165,158,	172,172,	
0,0,	165,158,	165,158,	166,200,	
0,0,	0,0,	0,0,	172,172,	
172,172,	0,0,	0,0,	229,282,	
166,202,	166,240,	166,202,	166,202,	
166,202,	166,202,	166,202,	166,202,	
0,0,	0,0,	0,0,	229,282,	
0,0,	166,234,	229,282,	229,282,	
166,234,	166,234,	0,0,	0,0,	
0,0,	0,0,	0,0,	166,200,	
0,0,	172,172,	172,0,	0,0,	
0,0,	0,0,	0,0,	172,172,	
0,0,	172,172,	172,172,	172,172,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	172,172,	
172,172,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	172,172,	
172,172,	172,172,	172,172,	172,172,	
0,0,	172,172,	0,0,	172,172,	
0,0,	172,172,	172,172,	172,172,	
172,172,	172,172,	172,172,	172,172,	
172,172,	172,172,	172,172,	0,0,	
0,0,	172,172,	172,172,	172,172,	
0,0,	195,201,	0,0,	172,172,	
232,283,	0,0,	0,0,	172,172,	
172,172,	172,172,	172,172,	172,172,	
172,172,	172,172,	195,201,	0,0,	
232,283,	0,0,	0,0,	232,283,	
232,283,	0,0,	0,0,	225,145,	
0,0,	172,172,	0,0,	0,0,	
0,0,	0,0,	0,0,	225,145,	
225,145,	0,0,	280,328,	0,0,	
232,283,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
195,201,	0,0,	280,328,	0,0,	
232,283,	280,328,	280,328,	232,283,	
232,283,	195,255,	195,255,	195,255,	
195,255,	195,255,	195,255,	195,255,	
195,255,	225,145,	225,145,	225,145,	
0,0,	0,0,	280,328,	225,278,	
0,0,	225,145,	225,145,	225,145,	
0,0,	0,0,	0,0,	0,0,	
195,201,	0,0,	280,328,	225,145,	
225,145,	280,328,	280,328,	0,0,	
0,0,	0,0,	0,0,	225,145,	
225,145,	225,145,	225,145,	225,145,	
230,232,	225,145,	0,0,	225,145,	
0,0,	225,145,	225,145,	225,145,	
225,145,	225,145,	225,145,	225,145,	
225,145,	225,145,	225,145,	0,0,	
0,0,	225,145,	225,145,	225,145,	
0,0,	230,233,	237,280,	0,0,	
0,0,	0,0,	230,283,	225,145,	
225,145,	225,145,	225,145,	225,145,	
225,145,	225,145,	0,0,	0,0,	
0,0,	0,0,	230,283,	0,0,	
239,232,	230,283,	230,283,	237,281,	
0,0,	225,145,	0,0,	0,0,	
237,282,	255,301,	255,301,	255,301,	
255,301,	255,301,	255,301,	255,301,	
255,301,	0,0,	230,283,	0,0,	
237,282,	239,233,	0,0,	237,282,	
237,282,	0,0,	239,234,	0,0,	
0,0,	0,0,	230,283,	0,0,	
0,0,	230,283,	230,283,	240,284,	
0,0,	0,0,	239,234,	258,302,	
237,282,	239,234,	239,234,	240,258,	
240,258,	240,258,	240,258,	240,258,	
240,258,	240,258,	240,258,	0,0,	
237,282,	0,0,	278,145,	237,282,	
237,282,	0,0,	239,234,	0,0,	
258,303,	0,0,	278,145,	278,145,	
0,0,	258,304,	0,0,	0,0,	
0,0,	0,0,	239,234,	0,0,	
0,0,	239,234,	239,234,	0,0,	
0,0,	258,304,	0,0,	0,0,	
258,304,	258,304,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
278,145,	278,145,	278,145,	0,0,	
0,0,	258,304,	278,278,	0,0,	
278,145,	278,145,	278,145,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	258,304,	278,145,	278,145,	
258,304,	258,304,	0,0,	0,0,	
0,0,	0,0,	278,145,	278,145,	
278,145,	278,145,	278,145,	279,280,	
278,145,	0,0,	278,145,	0,0,	
278,145,	278,145,	278,145,	278,145,	
278,145,	278,145,	278,145,	278,145,	
278,145,	278,145,	0,0,	0,0,	
278,145,	278,145,	278,145,	0,0,	
279,281,	301,302,	278,327,	302,342,	
0,0,	279,328,	278,145,	278,145,	
278,145,	278,145,	278,145,	278,145,	
278,145,	0,0,	0,0,	302,342,	
0,0,	279,328,	302,342,	302,342,	
279,328,	279,328,	301,303,	0,0,	
278,145,	0,0,	0,0,	301,342,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	302,342,	
0,0,	279,328,	0,0,	301,342,	
0,0,	0,0,	301,342,	301,342,	
0,0,	0,0,	306,306,	302,342,	
0,0,	279,328,	302,342,	302,342,	
279,328,	279,328,	306,306,	306,0,	
0,0,	0,0,	0,0,	301,342,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	301,342,	
0,0,	0,0,	301,342,	301,342,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
306,306,	306,306,	306,344,	0,0,	
0,0,	0,0,	306,306,	0,0,	
306,306,	306,306,	306,306,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	306,306,	306,306,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	306,306,	306,306,	
306,306,	306,306,	306,306,	0,0,	
306,306,	0,0,	306,306,	0,0,	
306,306,	306,306,	306,306,	306,306,	
306,306,	306,306,	306,306,	306,306,	
306,306,	306,306,	0,0,	340,340,	
306,306,	306,306,	306,306,	0,0,	
0,0,	0,0,	306,306,	340,340,	
340,0,	0,0,	306,306,	306,306,	
306,306,	306,306,	306,306,	306,306,	
306,306,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
306,306,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	340,340,	340,340,	340,372,	
0,0,	0,0,	0,0,	340,340,	
0,0,	340,340,	340,340,	340,340,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	340,340,	
340,340,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	340,340,	
340,340,	340,340,	340,340,	340,340,	
0,0,	340,340,	0,0,	340,340,	
0,0,	340,340,	340,340,	340,340,	
340,340,	340,340,	340,340,	340,340,	
340,340,	340,340,	340,340,	0,0,	
364,364,	340,340,	340,340,	340,340,	
0,0,	0,0,	0,0,	340,340,	
364,364,	364,0,	0,0,	340,340,	
340,340,	340,340,	340,340,	340,340,	
340,340,	340,340,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	340,340,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	364,364,	364,364,	
364,388,	0,0,	0,0,	0,0,	
364,364,	0,0,	364,364,	364,364,	
364,364,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
364,364,	364,364,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
364,364,	364,364,	364,364,	364,364,	
364,364,	0,0,	364,364,	0,0,	
364,364,	0,0,	364,364,	364,364,	
364,364,	364,364,	364,364,	364,364,	
364,364,	364,364,	364,364,	364,364,	
0,0,	381,400,	364,364,	364,364,	
364,364,	0,0,	0,0,	0,0,	
364,364,	381,400,	381,0,	0,0,	
364,364,	364,364,	364,364,	364,364,	
364,364,	364,364,	364,364,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	364,364,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	381,381,	
381,400,	381,400,	0,0,	0,0,	
0,0,	381,381,	0,0,	381,400,	
381,381,	381,381,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	381,381,	381,400,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	381,381,	381,381,	381,381,	
381,381,	381,381,	0,0,	381,401,	
0,0,	381,381,	0,0,	381,381,	
381,381,	381,381,	381,381,	381,381,	
381,381,	381,381,	381,381,	381,381,	
381,381,	400,0,	0,0,	381,381,	
381,381,	381,381,	0,0,	0,0,	
0,0,	381,400,	0,0,	0,0,	
0,0,	381,381,	381,381,	381,381,	
381,381,	381,381,	381,381,	381,401,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	400,400,	381,381,	
0,0,	0,0,	0,0,	0,0,	
400,400,	0,0,	0,0,	400,400,	
400,400,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
400,400,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
400,400,	400,400,	400,400,	400,400,	
400,400,	0,0,	400,415,	0,0,	
400,400,	0,0,	400,400,	400,400,	
400,400,	400,400,	400,400,	400,400,	
400,400,	400,400,	400,400,	400,400,	
415,0,	0,0,	400,400,	400,400,	
400,400,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
400,400,	400,400,	400,400,	400,400,	
400,400,	400,400,	400,415,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	415,400,	400,400,	0,0,	
0,0,	0,0,	0,0,	415,400,	
0,0,	0,0,	415,400,	415,400,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	415,400,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	415,433,	
415,400,	415,400,	415,400,	415,400,	
0,0,	415,415,	0,0,	415,400,	
0,0,	415,400,	415,400,	415,400,	
415,400,	415,400,	415,400,	415,400,	
415,400,	415,400,	415,400,	433,0,	
0,0,	415,400,	415,400,	415,400,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	415,434,	
415,400,	415,400,	415,400,	415,400,	
415,400,	415,415,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
433,400,	415,400,	0,0,	0,0,	
0,0,	0,0,	433,400,	0,0,	
0,0,	433,400,	433,400,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	433,400,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	433,400,	433,400,	
433,400,	433,400,	433,400,	0,0,	
433,415,	0,0,	433,400,	0,0,	
433,400,	433,400,	433,455,	433,400,	
433,400,	433,400,	433,400,	433,400,	
433,400,	433,400,	434,0,	0,0,	
433,400,	433,400,	433,400,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	433,400,	433,400,	
433,400,	433,400,	433,400,	433,400,	
433,415,	0,0,	0,0,	0,0,	
0,0,	0,0,	433,400,	0,0,	
0,0,	0,0,	0,0,	434,400,	
433,400,	0,0,	0,0,	0,0,	
0,0,	434,400,	0,0,	0,0,	
434,400,	434,400,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	434,400,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	434,400,	434,400,	434,400,	
434,400,	434,400,	0,0,	434,415,	
0,0,	434,400,	0,0,	434,400,	
434,400,	434,400,	434,400,	434,400,	
434,400,	434,400,	434,400,	434,400,	
434,400,	455,0,	0,0,	434,400,	
434,400,	434,400,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	434,400,	434,400,	434,400,	
434,400,	434,400,	434,400,	434,415,	
0,0,	0,0,	0,0,	0,0,	
0,0,	434,456,	0,0,	0,0,	
0,0,	0,0,	455,400,	434,400,	
0,0,	0,0,	0,0,	0,0,	
455,400,	0,0,	0,0,	455,400,	
455,400,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
455,400,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
455,400,	455,400,	455,400,	455,400,	
455,474,	0,0,	455,415,	0,0,	
455,400,	0,0,	455,400,	455,400,	
455,400,	455,400,	455,400,	455,400,	
455,400,	455,400,	455,400,	455,400,	
456,0,	0,0,	455,400,	455,400,	
455,400,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
455,400,	455,400,	455,400,	455,400,	
455,400,	455,400,	455,415,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	456,400,	455,400,	0,0,	
0,0,	0,0,	0,0,	456,400,	
0,0,	0,0,	456,400,	456,400,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	456,400,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	456,400,	
456,400,	456,400,	456,400,	456,400,	
0,0,	456,415,	0,0,	456,400,	
0,0,	456,400,	456,400,	456,400,	
456,400,	456,400,	456,400,	456,400,	
456,400,	456,400,	456,400,	474,0,	
0,0,	456,400,	456,400,	456,400,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	456,400,	
456,400,	456,400,	456,400,	456,474,	
456,400,	456,415,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
474,400,	456,400,	0,0,	0,0,	
0,0,	0,0,	474,400,	0,0,	
0,0,	474,400,	474,400,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	474,400,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	474,400,	474,400,	
474,400,	474,400,	474,400,	0,0,	
474,415,	0,0,	474,400,	0,0,	
474,400,	474,400,	474,400,	474,400,	
474,400,	474,400,	474,400,	474,400,	
474,400,	474,400,	0,0,	0,0,	
474,400,	474,400,	474,400,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	474,400,	474,400,	
474,400,	474,400,	474,400,	474,400,	
474,415,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
474,400,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-67,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+131,	0,		yyvstop+3,
yycrank+-253,	0,		yyvstop+6,
yycrank+15,	yysvec+4,	yyvstop+8,
yycrank+329,	yysvec+4,	yyvstop+11,
yycrank+362,	yysvec+4,	yyvstop+15,
yycrank+426,	yysvec+4,	yyvstop+19,
yycrank+3,	yysvec+4,	yyvstop+23,
yycrank+11,	yysvec+4,	yyvstop+26,
yycrank+17,	yysvec+4,	yyvstop+29,
yycrank+348,	yysvec+4,	yyvstop+32,
yycrank+31,	yysvec+4,	yyvstop+35,
yycrank+52,	yysvec+4,	yyvstop+38,
yycrank+39,	yysvec+4,	yyvstop+41,
yycrank+486,	yysvec+4,	yyvstop+44,
yycrank+29,	yysvec+4,	yyvstop+47,
yycrank+118,	yysvec+4,	yyvstop+50,
yycrank+-552,	0,		yyvstop+54,
yycrank+619,	yysvec+4,	yyvstop+56,
yycrank+648,	yysvec+4,	yyvstop+59,
yycrank+708,	yysvec+4,	yyvstop+63,
yycrank+732,	yysvec+4,	yyvstop+66,
yycrank+804,	yysvec+4,	yyvstop+69,
yycrank+828,	yysvec+4,	yyvstop+72,
yycrank+888,	yysvec+4,	yyvstop+75,
yycrank+919,	yysvec+4,	yyvstop+78,
yycrank+19,	yysvec+4,	yyvstop+81,
yycrank+0,	yysvec+4,	yyvstop+84,
yycrank+-993,	0,		0,	
yycrank+-1078,	0,		0,	
yycrank+-103,	yysvec+31,	0,	
yycrank+88,	0,		0,	
yycrank+60,	yysvec+4,	yyvstop+86,
yycrank+12,	0,		0,	
yycrank+17,	yysvec+4,	yyvstop+88,
yycrank+0,	yysvec+36,	0,	
yycrank+1106,	0,		0,	
yycrank+108,	yysvec+39,	0,	
yycrank+23,	yysvec+4,	yyvstop+91,
yycrank+76,	0,		0,	
yycrank+1179,	yysvec+4,	yyvstop+93,
yycrank+39,	0,		0,	
yycrank+0,	yysvec+4,	yyvstop+96,
yycrank+1176,	0,		0,	
yycrank+167,	yysvec+4,	yyvstop+99,
yycrank+175,	0,		0,	
yycrank+1168,	yysvec+4,	yyvstop+101,
yycrank+183,	0,		0,	
yycrank+26,	yysvec+4,	yyvstop+103,
yycrank+1247,	yysvec+4,	yyvstop+105,
yycrank+9,	yysvec+4,	yyvstop+107,
yycrank+41,	yysvec+4,	yyvstop+109,
yycrank+10,	yysvec+4,	yyvstop+111,
yycrank+49,	yysvec+4,	yyvstop+113,
yycrank+18,	yysvec+4,	yyvstop+115,
yycrank+44,	yysvec+4,	yyvstop+117,
yycrank+15,	yysvec+4,	yyvstop+119,
yycrank+50,	yysvec+4,	yyvstop+121,
yycrank+31,	yysvec+4,	yyvstop+123,
yycrank+69,	yysvec+4,	yyvstop+125,
yycrank+70,	yysvec+4,	yyvstop+127,
yycrank+436,	yysvec+4,	yyvstop+130,
yycrank+71,	yysvec+4,	yyvstop+132,
yycrank+1271,	yysvec+4,	yyvstop+134,
yycrank+91,	yysvec+4,	yyvstop+136,
yycrank+60,	yysvec+4,	yyvstop+138,
yycrank+1300,	yysvec+46,	0,	
yycrank+86,	yysvec+4,	yyvstop+140,
yycrank+57,	yysvec+4,	yyvstop+142,
yycrank+-118,	yysvec+20,	0,	
yycrank+-119,	yysvec+20,	0,	
yycrank+0,	0,		yyvstop+144,
yycrank+396,	yysvec+4,	yyvstop+146,
yycrank+1340,	yysvec+4,	yyvstop+148,
yycrank+406,	0,		0,	
yycrank+418,	yysvec+4,	yyvstop+151,
yycrank+514,	yysvec+4,	yyvstop+153,
yycrank+1412,	yysvec+4,	yyvstop+155,
yycrank+478,	yysvec+4,	yyvstop+158,
yycrank+1430,	yysvec+4,	yyvstop+160,
yycrank+559,	0,		0,	
yycrank+584,	yysvec+4,	yyvstop+163,
yycrank+1502,	yysvec+4,	yyvstop+165,
yycrank+1574,	yysvec+4,	yyvstop+168,
yycrank+677,	yysvec+4,	yyvstop+170,
yycrank+54,	yysvec+4,	yyvstop+172,
yycrank+56,	yysvec+4,	yyvstop+174,
yycrank+-127,	yysvec+31,	0,	
yycrank+-128,	yysvec+32,	0,	
yycrank+-1640,	yysvec+32,	0,	
yycrank+-1725,	0,		0,	
yycrank+-247,	yysvec+31,	0,	
yycrank+-258,	yysvec+31,	0,	
yycrank+140,	0,		0,	
yycrank+141,	0,		0,	
yycrank+142,	0,		0,	
yycrank+130,	yysvec+4,	yyvstop+177,
yycrank+0,	yysvec+4,	yyvstop+180,
yycrank+0,	0,		yyvstop+183,
yycrank+0,	yysvec+4,	yyvstop+185,
yycrank+0,	0,		yyvstop+188,
yycrank+145,	0,		0,	
yycrank+157,	0,		0,	
yycrank+159,	0,		0,	
yycrank+0,	yysvec+4,	yyvstop+190,
yycrank+0,	0,		yyvstop+193,
yycrank+258,	0,		yyvstop+195,
yycrank+109,	0,		0,	
yycrank+114,	0,		0,	
yycrank+129,	0,		0,	
yycrank+125,	0,		0,	
yycrank+154,	0,		0,	
yycrank+285,	0,		0,	
yycrank+659,	yysvec+4,	yyvstop+197,
yycrank+720,	0,		0,	
yycrank+700,	yysvec+4,	yyvstop+199,
yycrank+740,	0,		0,	
yycrank+814,	yysvec+4,	yyvstop+201,
yycrank+844,	0,		0,	
yycrank+189,	yysvec+4,	yyvstop+203,
yycrank+1401,	yysvec+4,	yyvstop+205,
yycrank+158,	yysvec+4,	yyvstop+208,
yycrank+191,	yysvec+4,	yyvstop+210,
yycrank+160,	yysvec+4,	yyvstop+212,
yycrank+173,	yysvec+4,	yyvstop+214,
yycrank+142,	yysvec+4,	yyvstop+216,
yycrank+293,	yysvec+4,	yyvstop+218,
yycrank+220,	yysvec+4,	yyvstop+220,
yycrank+190,	yysvec+4,	yyvstop+222,
yycrank+252,	yysvec+4,	yyvstop+224,
yycrank+1771,	yysvec+4,	yyvstop+227,
yycrank+235,	yysvec+4,	yyvstop+229,
yycrank+204,	yysvec+4,	yyvstop+231,
yycrank+236,	yysvec+4,	yyvstop+233,
yycrank+205,	yysvec+4,	yyvstop+235,
yycrank+234,	0,		0,	
yycrank+248,	0,		0,	
yycrank+292,	0,		0,	
yycrank+304,	0,		0,	
yycrank+532,	0,		0,	
yycrank+230,	yysvec+4,	yyvstop+237,
yycrank+207,	yysvec+4,	yyvstop+239,
yycrank+-1837,	yysvec+20,	0,	
yycrank+1322,	yysvec+4,	yyvstop+241,
yycrank+869,	0,		0,	
yycrank+855,	yysvec+4,	yyvstop+244,
yycrank+927,	0,		0,	
yycrank+303,	yysvec+147,	0,	
yycrank+303,	yysvec+4,	yyvstop+246,
yycrank+1048,	yysvec+4,	yyvstop+249,
yycrank+1146,	yysvec+4,	yyvstop+251,
yycrank+1892,	0,		yyvstop+254,
yycrank+1570,	yysvec+4,	yyvstop+256,
yycrank+1483,	0,		0,	
yycrank+305,	yysvec+156,	0,	
yycrank+306,	yysvec+4,	yyvstop+259,
yycrank+1910,	yysvec+4,	yyvstop+262,
yycrank+1145,	yysvec+4,	yyvstop+265,
yycrank+1209,	0,		0,	
yycrank+1287,	yysvec+4,	yyvstop+267,
yycrank+1430,	yysvec+4,	yyvstop+269,
yycrank+1520,	yysvec+154,	yyvstop+272,
yycrank+1960,	yysvec+4,	yyvstop+274,
yycrank+1987,	yysvec+4,	yyvstop+277,
yycrank+1604,	yysvec+4,	yyvstop+281,
yycrank+303,	yysvec+4,	yyvstop+284,
yycrank+0,	0,		yyvstop+287,
yycrank+0,	yysvec+93,	yyvstop+289,
yycrank+-322,	yysvec+93,	0,	
yycrank+-2070,	yysvec+32,	0,	
yycrank+0,	0,		yyvstop+291,
yycrank+-502,	yysvec+31,	0,	
yycrank+0,	yysvec+36,	0,	
yycrank+0,	yysvec+36,	0,	
yycrank+0,	yysvec+36,	0,	
yycrank+315,	yysvec+4,	yyvstop+293,
yycrank+0,	yysvec+44,	0,	
yycrank+0,	yysvec+42,	0,	
yycrank+0,	yysvec+44,	0,	
yycrank+376,	0,		0,	
yycrank+388,	0,		0,	
yycrank+282,	0,		0,	
yycrank+251,	0,		0,	
yycrank+308,	0,		0,	
yycrank+283,	0,		0,	
yycrank+253,	0,		0,	
yycrank+300,	0,		0,	
yycrank+286,	0,		0,	
yycrank+339,	0,		0,	
yycrank+309,	0,		0,	
yycrank+347,	0,		0,	
yycrank+0,	yysvec+4,	yyvstop+295,
yycrank+2116,	0,		0,	
yycrank+1695,	0,		0,	
yycrank+0,	yysvec+4,	yyvstop+298,
yycrank+0,	0,		yyvstop+301,
yycrank+360,	yysvec+4,	yyvstop+303,
yycrank+1659,	yysvec+4,	yyvstop+305,
yycrank+1733,	0,		0,	
yycrank+1799,	yysvec+4,	yyvstop+307,
yycrank+331,	yysvec+4,	yyvstop+309,
yycrank+368,	yysvec+4,	yyvstop+311,
yycrank+337,	yysvec+4,	yyvstop+313,
yycrank+435,	yysvec+4,	yyvstop+315,
yycrank+402,	0,		0,	
yycrank+499,	yysvec+4,	yyvstop+318,
yycrank+0,	yysvec+4,	yyvstop+320,
yycrank+374,	yysvec+4,	yyvstop+323,
yycrank+383,	yysvec+4,	yyvstop+325,
yycrank+352,	yysvec+4,	yyvstop+327,
yycrank+387,	yysvec+4,	yyvstop+329,
yycrank+369,	yysvec+4,	yyvstop+331,
yycrank+400,	0,		0,	
yycrank+396,	0,		0,	
yycrank+489,	0,		0,	
yycrank+428,	0,		0,	
yycrank+416,	0,		0,	
yycrank+464,	0,		0,	
yycrank+433,	0,		0,	
yycrank+516,	0,		0,	
yycrank+480,	yysvec+4,	yyvstop+333,
yycrank+451,	yysvec+4,	yyvstop+335,
yycrank+-2182,	yysvec+20,	0,	
yycrank+513,	0,		yyvstop+337,
yycrank+1811,	0,		0,	
yycrank+0,	0,		yyvstop+339,
yycrank+1985,	yysvec+4,	yyvstop+341,
yycrank+2212,	0,		yyvstop+344,
yycrank+515,	0,		yyvstop+346,
yycrank+2098,	0,		0,	
yycrank+517,	yysvec+232,	0,	
yycrank+517,	yysvec+4,	yyvstop+348,
yycrank+0,	0,		yyvstop+351,
yycrank+1928,	0,		0,	
yycrank+2234,	yysvec+4,	yyvstop+353,
yycrank+0,	yysvec+230,	yyvstop+357,
yycrank+2252,	yysvec+4,	yyvstop+360,
yycrank+2286,	yysvec+4,	yyvstop+364,
yycrank+449,	yysvec+4,	yyvstop+367,
yycrank+-532,	yysvec+31,	0,	
yycrank+546,	0,		0,	
yycrank+566,	0,		0,	
yycrank+527,	0,		0,	
yycrank+501,	0,		0,	
yycrank+710,	0,		0,	
yycrank+538,	0,		0,	
yycrank+507,	0,		0,	
yycrank+543,	0,		0,	
yycrank+513,	0,		0,	
yycrank+542,	0,		0,	
yycrank+511,	0,		0,	
yycrank+706,	0,		yyvstop+369,
yycrank+2252,	0,		0,	
yycrank+0,	0,		yyvstop+371,
yycrank+590,	yysvec+4,	yyvstop+373,
yycrank+2291,	yysvec+4,	yyvstop+376,
yycrank+567,	yysvec+4,	yyvstop+379,
yycrank+1313,	0,		0,	
yycrank+592,	yysvec+4,	yyvstop+381,
yycrank+574,	0,		0,	
yycrank+569,	yysvec+4,	yyvstop+384,
yycrank+541,	yysvec+4,	yyvstop+386,
yycrank+569,	yysvec+4,	yyvstop+388,
yycrank+538,	yysvec+4,	yyvstop+390,
yycrank+588,	yysvec+4,	yyvstop+392,
yycrank+557,	yysvec+4,	yyvstop+394,
yycrank+610,	0,		0,	
yycrank+588,	0,		0,	
yycrank+803,	0,		0,	
yycrank+621,	0,		0,	
yycrank+590,	0,		0,	
yycrank+619,	0,		0,	
yycrank+589,	0,		0,	
yycrank+708,	0,		yyvstop+396,
yycrank+664,	yysvec+4,	yyvstop+398,
yycrank+-2345,	0,		0,	
yycrank+2375,	0,		yyvstop+401,
yycrank+2128,	0,		0,	
yycrank+665,	yysvec+280,	0,	
yycrank+684,	yysvec+4,	yyvstop+403,
yycrank+693,	0,		yyvstop+406,
yycrank+0,	0,		yyvstop+408,
yycrank+0,	yysvec+279,	yyvstop+410,
yycrank+0,	0,		yyvstop+413,
yycrank+688,	0,		0,	
yycrank+687,	0,		0,	
yycrank+659,	0,		0,	
yycrank+628,	0,		0,	
yycrank+709,	0,		0,	
yycrank+711,	0,		yyvstop+416,
yycrank+661,	0,		0,	
yycrank+639,	0,		0,	
yycrank+673,	0,		0,	
yycrank+651,	0,		0,	
yycrank+696,	0,		0,	
yycrank+690,	0,		0,	
yycrank+810,	0,		0,	
yycrank+763,	0,		yyvstop+418,
yycrank+2397,	0,		yyvstop+420,
yycrank+2373,	0,		0,	
yycrank+773,	yysvec+302,	0,	
yycrank+774,	yysvec+4,	yyvstop+422,
yycrank+751,	yysvec+4,	yyvstop+425,
yycrank+-2481,	0,		0,	
yycrank+748,	0,		0,	
yycrank+796,	0,		0,	
yycrank+819,	0,		0,	
yycrank+748,	0,		0,	
yycrank+717,	0,		0,	
yycrank+739,	yysvec+4,	yyvstop+427,
yycrank+712,	yysvec+4,	yyvstop+429,
yycrank+880,	yysvec+4,	yyvstop+431,
yycrank+780,	yysvec+4,	yyvstop+434,
yycrank+750,	yysvec+4,	yyvstop+436,
yycrank+779,	0,		0,	
yycrank+757,	0,		0,	
yycrank+807,	0,		0,	
yycrank+842,	0,		yyvstop+438,
yycrank+792,	0,		0,	
yycrank+761,	0,		0,	
yycrank+820,	0,		0,	
yycrank+806,	0,		0,	
yycrank+925,	0,		0,	
yycrank+878,	0,		yyvstop+440,
yycrank+0,	0,		yyvstop+442,
yycrank+870,	0,		yyvstop+445,
yycrank+0,	0,		yyvstop+447,
yycrank+880,	0,		0,	
yycrank+0,	0,		yyvstop+449,
yycrank+829,	0,		0,	
yycrank+798,	0,		0,	
yycrank+882,	0,		0,	
yycrank+0,	0,		yyvstop+451,
yycrank+832,	0,		0,	
yycrank+808,	0,		0,	
yycrank+856,	0,		0,	
yycrank+826,	0,		0,	
yycrank+-2566,	0,		0,	
yycrank+900,	0,		0,	
yycrank+904,	0,		yyvstop+453,
yycrank+0,	0,		yyvstop+455,
yycrank+-950,	yysvec+306,	yyvstop+457,
yycrank+880,	0,		0,	
yycrank+866,	0,		0,	
yycrank+952,	0,		0,	
yycrank+916,	0,		0,	
yycrank+885,	0,		0,	
yycrank+916,	0,		0,	
yycrank+885,	0,		0,	
yycrank+918,	yysvec+4,	yyvstop+459,
yycrank+890,	yysvec+4,	yyvstop+461,
yycrank+943,	yysvec+4,	yyvstop+463,
yycrank+0,	yysvec+4,	yyvstop+465,
yycrank+922,	yysvec+4,	yyvstop+468,
yycrank+893,	yysvec+4,	yyvstop+470,
yycrank+928,	0,		0,	
yycrank+897,	0,		0,	
yycrank+935,	0,		0,	
yycrank+0,	0,		yyvstop+472,
yycrank+937,	0,		0,	
yycrank+925,	0,		0,	
yycrank+-2651,	0,		0,	
yycrank+974,	0,		0,	
yycrank+0,	yysvec+288,	0,	
yycrank+954,	0,		0,	
yycrank+929,	0,		0,	
yycrank+975,	0,		0,	
yycrank+1013,	0,		0,	
yycrank+1330,	0,		yyvstop+474,
yycrank+-1037,	yysvec+340,	yyvstop+476,
yycrank+1016,	0,		0,	
yycrank+980,	0,		0,	
yycrank+953,	0,		0,	
yycrank+1427,	0,		0,	
yycrank+986,	0,		0,	
yycrank+955,	0,		0,	
yycrank+974,	0,		0,	
yycrank+948,	0,		0,	
yycrank+-2736,	0,		yyvstop+478,
yycrank+996,	yysvec+4,	yyvstop+480,
yycrank+966,	yysvec+4,	yyvstop+482,
yycrank+995,	0,		0,	
yycrank+968,	0,		0,	
yycrank+1011,	0,		0,	
yycrank+1333,	0,		yyvstop+484,
yycrank+-1095,	yysvec+364,	yyvstop+486,
yycrank+1074,	0,		0,	
yycrank+1075,	0,		0,	
yycrank+1077,	0,		0,	
yycrank+1042,	0,		0,	
yycrank+1063,	0,		0,	
yycrank+0,	0,		yyvstop+488,
yycrank+1048,	0,		0,	
yycrank+1042,	0,		0,	
yycrank+1011,	0,		0,	
yycrank+1029,	0,		0,	
yycrank+998,	0,		0,	
yycrank+-2811,	yysvec+381,	0,	
yycrank+-1118,	yysvec+381,	yyvstop+490,
yycrank+0,	yysvec+4,	yyvstop+492,
yycrank+1088,	0,		0,	
yycrank+1090,	0,		0,	
yycrank+1069,	0,		0,	
yycrank+0,	0,		yyvstop+495,
yycrank+1056,	0,		0,	
yycrank+1328,	0,		0,	
yycrank+1057,	0,		0,	
yycrank+1068,	0,		0,	
yycrank+1112,	0,		0,	
yycrank+1349,	0,		yyvstop+497,
yycrank+1051,	0,		0,	
yycrank+1024,	0,		0,	
yycrank+-2886,	yysvec+381,	0,	
yycrank+-1184,	yysvec+381,	yyvstop+499,
yycrank+-1129,	yysvec+381,	yyvstop+501,
yycrank+1448,	0,		0,	
yycrank+1106,	0,		0,	
yycrank+1118,	0,		0,	
yycrank+1098,	0,		0,	
yycrank+1119,	0,		0,	
yycrank+1146,	0,		0,	
yycrank+1068,	0,		0,	
yycrank+1037,	0,		0,	
yycrank+1071,	0,		0,	
yycrank+1059,	0,		0,	
yycrank+0,	0,		yyvstop+503,
yycrank+1101,	0,		0,	
yycrank+1073,	0,		0,	
yycrank+1128,	0,		0,	
yycrank+1098,	0,		0,	
yycrank+-2961,	yysvec+381,	0,	
yycrank+-3036,	yysvec+381,	0,	
yycrank+-1250,	yysvec+381,	yyvstop+505,
yycrank+-1227,	yysvec+381,	yyvstop+507,
yycrank+1188,	0,		0,	
yycrank+1181,	0,		0,	
yycrank+1189,	0,		0,	
yycrank+1144,	0,		0,	
yycrank+1130,	0,		0,	
yycrank+1244,	0,		0,	
yycrank+1162,	0,		0,	
yycrank+1140,	0,		0,	
yycrank+1187,	0,		0,	
yycrank+1165,	0,		0,	
yycrank+1188,	0,		0,	
yycrank+1185,	0,		0,	
yycrank+1245,	0,		0,	
yycrank+1214,	0,		0,	
yycrank+1239,	0,		0,	
yycrank+1208,	0,		0,	
yycrank+1257,	0,		0,	
yycrank+1227,	0,		0,	
yycrank+-3111,	yysvec+381,	0,	
yycrank+-3186,	yysvec+381,	0,	
yycrank+-1323,	yysvec+381,	yyvstop+509,
yycrank+1247,	0,		0,	
yycrank+1274,	0,		0,	
yycrank+1244,	0,		0,	
yycrank+1278,	0,		0,	
yycrank+1247,	0,		0,	
yycrank+1288,	0,		0,	
yycrank+1257,	0,		0,	
yycrank+0,	0,		yyvstop+512,
yycrank+1291,	0,		0,	
yycrank+1260,	0,		0,	
yycrank+1286,	0,		yyvstop+514,
yycrank+1349,	0,		yyvstop+516,
yycrank+1300,	0,		0,	
yycrank+1273,	0,		0,	
yycrank+1311,	0,		0,	
yycrank+1281,	0,		0,	
yycrank+-3261,	yysvec+381,	yyvstop+518,
yycrank+0,	0,		yyvstop+520,
yycrank+1325,	0,		0,	
yycrank+1304,	0,		0,	
yycrank+1375,	0,		yyvstop+522,
yycrank+0,	0,		yyvstop+524,
yycrank+0,	0,		yyvstop+526,
yycrank+1372,	0,		0,	
yycrank+1345,	0,		0,	
yycrank+1314,	0,		0,	
yycrank+0,	0,		yyvstop+528,
yycrank+1389,	0,		0,	
0,	0,	0};
struct yywork *yytop = yycrank+3376;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,047 ,
'(' ,')' ,01  ,01  ,01  ,'-' ,011 ,'/' ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'1' ,'9' ,':' ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,047 ,'G' ,
047 ,'I' ,047 ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'Q' ,'R' ,'S' ,'T' ,047 ,047 ,'W' ,
'X' ,'Y' ,047 ,01  ,01  ,']' ,01  ,01  ,
01  ,'a' ,'b' ,'c' ,'d' ,'e' ,'f' ,'g' ,
'f' ,'I' ,047 ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'Q' ,'R' ,'s' ,'T' ,047 ,047 ,'W' ,
'X' ,'Y' ,047 ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
