/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _UTILS
#define _UTILS

#include "types.h"

#define QUERY_YES          0
#define QUERY_NO           1
#define QUERY_CANCEL       2
#define QUERY_INPROGRESS  -1

#define PRINT_BLANK -1

#define PLAYER_NONE -1

/* X11 Graphical */
void UTIL_PrintArmies(Int iCountry, Int iNumArmies, Int iColor);
void UTIL_DisplayMessage(String strFrom, String strMessage);
void UTIL_DisplayComment(String strComment);
void UTIL_DisplayError(String strError);
void UTIL_SetPlayerTurnIndicator(Int iPlayer);
void UTIL_DisplayActionString(Int iState, Int iPlayer);
void UTIL_CenterShell(Widget wCenter, Widget wBase, Int *x, Int *y);
Int  UTIL_GetArmyNumber(Int iMinArmies, Int iMaxArmies, Boolean fLetCancel);
Int  UTIL_PopupDialog(String strTitle, String strQuestion, Int iNumOptions, 
		      String strOption1, String strOption2, String strOption3);
void UTIL_QueryYes(Widget w, XtPointer pData, XtPointer pCalldata);
void UTIL_QueryNo(Widget w, XtPointer pData, XtPointer pCalldata); 
void UTIL_QueryCancel(Widget w, XtPointer pData, XtPointer pCalldata);
void UTIL_LightCountry(Int iCountry);
void UTIL_DarkenCountry(Int iCountry);
void UTIL_RefreshMsgDest(Int iNumStrings);
void UTIL_DeleteMsgDst(Int iClient);

/* Non-graphical */
void    UTIL_ServerEnterState(Int iNewState);
void    UTIL_SendMessage(void);
void    UTIL_ServerEndTurn(void);
Boolean UTIL_PlayerIsLocal(Int iPlayer);
String  UTIL_NameOfNthPlayerAtClient(Int iClient, Int iIndex);
Int     UTIL_GetNthPlayerAtClient(Int iClient, Int iIndex);
Int     UTIL_NumPlayersAtClient(Int iClient);
void    UTIL_ExitProgram(Int iExitValue);

#endif


