/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _GAME
#define _GAME

#include "types.h"

#define PLACE_ONE       0
#define PLACE_MULTIPLE  1

void     GAME_PlaceClick(Int iCountry, Int iPlaceType);
void     GAME_PlaceArmies(Int iCountry, Int iPlaceType);
Boolean  GAME_ValidPlaceDst(Int iPlaceDst);

void     GAME_MoveArmies(Int iSrcCountry, Int iDstCountry, Int iNumArmies);
void     GAME_MoveClick(Int iCountry);
Boolean  GAME_ValidMoveSrc(Int iMoveSrc);
Boolean  GAME_ValidMoveDst(Int iMoveSrc, Int iMoveDst);

void     GAME_Attack(Int iSrcCountry, Int iDstCountry, Boolean fCacheNotify);
void     GAME_AttackClick(Int iCountry);
Boolean  GAME_ValidAttackSrc(Int iCountry, Boolean fVerbose);
Boolean  GAME_ValidAttackDst(Int iAttackSrc, Int iCountry, Boolean fVerbose);
Boolean  GAME_ValidAttackDice(Int iAttackDice, Int iCountry);

Int      GAME_GetContinentBonus(Int iPlayer);
void     GAME_PlayerDied(Int iDeadPlayer);
void     GAME_GetCard(Int iPlayer);
void     GAME_ExchangeCards(Int *piCards);
void     GAME_GameOverMan(void);

#endif
