/* File htmlenv.ch created by Ward Nelson
   (c) Copyright IBM Corp.  (This work is unpublished).  All rights reserved.

   htmlenv, an environment that can also store a list of HTML+ tag attributes */

class htmlenv : environment[envrment]  {
    methods:
      ClearAttribs();
      SetAttribs(struct htmlatts *atts);
      GetAttribValue(char *name) returns char *;
    overrides:
      NewButSimilar() returns struct htmlenv *;
      Wrap(long pos, long length, enum environmenttype type, union environmentcontents data) returns struct thisobject *;

    classprocedures:
      InitializeObject(struct htmlenv *self) returns boolean;
      FinalizeObject(struct htmlenv *self);
      GetTextRootEnvironment(struct text *txt) returns struct htmlenv *;
    macromethods:
      GetAttribs() ((self)->attribs)

    data:
      struct attlist* attribs;
};



char *skipwhitespace(s)
char *s;
{
    while (*s && isspace(*s)) ++s;
    return s;
}

char *skiptokenchars(s)
char *s;
{
    while (*s && !isspace(*s) && *s != '=') ++s;
    return s;
}
