# Kazakh (kk) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                   | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-ші                                           | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-ші                                              | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-ші                                           | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-ші                                              | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-ші                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ші                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1-ші тоқ.                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ші тоқ.                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-ші тоқсан                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ші тоқсан                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-ші                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ші                                              | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1-ші тоқ.                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ші тоқ.                                         | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-ші тоқсан                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ші тоқсан                                       | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2-ші                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ші                                              | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | ақп                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | шіл                                               | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | ақпан                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | шілде                                             | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | А                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Ш                                                 | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2-ші                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ші                                              | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | ақп                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | шіл                                               | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | ақпан                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | шілде                                             | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | А                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Ш                                                 | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-ші                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ші                                             | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-ші                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ші                                             | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11-ші                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-ші                                             | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-ші                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-ші                                            | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | дүйсенбі                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жұма                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | Д                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ж                                                 | 2019-02-17T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-ші                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ші                                              | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | дүйсенбі                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жұма                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | Д                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ж                                                 | 2019-02-17T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-ші                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ші                                              | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | дүйсенбі                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жұма                                              | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | Д                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ж                                                 | 2019-02-17T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-ші                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ші                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | дүйсенбі                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жұма                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | Д                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ж                                                 | 2019-02-17T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | дс                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | жм                                                | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | тд                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | тк                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | тк                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | тд                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | тд                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | тк                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | тк                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | тд                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ТК                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ТД                                                | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | таңертең                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | күндіз                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кеште                                             | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | түнде                                             | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | таңертең                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | күндіз                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кеште                                             | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | түнде                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | таңертең                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | күндіз                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кеште                                             | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | түнде                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | таңертең                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | күндіз                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кеште                                             | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | түнде                                             | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | таң                                               | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | күн                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | кеш                                               | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | түн                                               | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-ші                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-ші                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-ші                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-ші                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-ші                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-ші                                             | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-ші                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-ші                                             | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-ші                                              | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-ші                                             | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-ші                                              | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-ші                                             | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11.02.1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                        | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 ақп 1987 ж.                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мам 1453 ж.                                    | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11-ші ақпан 1987 ж.                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-шы мамыр 1453 ж.                               | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | сәрсенбі, 11-ші ақпан 1987 ж.                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | жексенбі, 29-шы мамыр 1453 ж.                     | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                             | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                    | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                                 | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 ақп 1987 ж., 12:13:14                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мам 1453 ж., 23:59:59                          | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11-ші ақпан 1987 ж., 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-шы мамыр 1453 ж., 23:59:59 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | сәрсенбі, 11-ші ақпан 1987 ж., 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | жексенбі, 29-шы мамыр 1453 ж., 23:59:59 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result          | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | --------------- | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | шамамен 6 жыл   | шамамен 6 жыл          | шамамен 6 жылдан кейін   |
| 2005-01-01T00:00:00.000Z | шамамен 5 жыл   | шамамен 5 жыл          | шамамен 5 жылдан кейін   |
| 2004-01-01T00:00:00.000Z | шамамен 4 жыл   | шамамен 4 жыл          | шамамен 4 жылдан кейін   |
| 2003-01-01T00:00:00.000Z | шамамен 3 жыл   | шамамен 3 жыл          | шамамен 3 жылдан кейін   |
| 2002-01-01T00:00:00.000Z | шамамен 2 жыл   | шамамен 2 жыл          | шамамен 2 жылдан кейін   |
| 2001-06-01T00:00:00.000Z | 1 жылдан астам  | 1 жылдан астам         | 1 жылдан астам           |
| 2001-02-01T00:00:00.000Z | шамамен 1 жыл   | шамамен 1 жыл          | шамамен 1 жылдан кейін   |
| 2001-01-01T00:00:00.000Z | шамамен 1 жыл   | шамамен 1 жыл          | шамамен 1 жылдан кейін   |
| 2000-06-01T00:00:00.000Z | 5 ай            | 5 ай                   | 5 ай кейін               |
| 2000-03-01T00:00:00.000Z | 2 ай            | 2 ай                   | 2 ай кейін               |
| 2000-02-01T00:00:00.000Z | шамамен 1 ай    | шамамен 1 ай           | шамамен 1 айдан кейін    |
| 2000-01-15T00:00:00.000Z | 14 күн          | 14 күн                 | 14 күннен кейін          |
| 2000-01-02T00:00:00.000Z | 1 күн           | 1 күн                  | 1 күннен кейін           |
| 2000-01-01T06:00:00.000Z | шамамен 6 сағат | шамамен 6 сағат        | шамамен 6 сағаттан кейін |
| 2000-01-01T01:00:00.000Z | шамамен 1 сағат | шамамен 1 сағат        | шамамен 1 сағаттан кейін |
| 2000-01-01T00:45:00.000Z | шамамен 1 сағат | шамамен 1 сағат        | шамамен 1 сағаттан кейін |
| 2000-01-01T00:30:00.000Z | 30 минут        | 30 минут               | 30 минуттан кейін        |
| 2000-01-01T00:15:00.000Z | 15 минут        | 15 минут               | 15 минуттан кейін        |
| 2000-01-01T00:01:00.000Z | 1 минут         | 1 минут                | 1 минуттан кейін         |
| 2000-01-01T00:00:25.000Z | 1 минуттан аз   | жарты минут            | минуттан кем             |
| 2000-01-01T00:00:15.000Z | 1 минуттан аз   | 20 секундтан аз        | минуттан кем             |
| 2000-01-01T00:00:05.000Z | 1 минуттан аз   | 10 секундтан аз        | минуттан кем             |
| 2000-01-01T00:00:00.000Z | 1 минуттан аз   | 5 секундтан аз         | 1 минуттан аз бұрын      |
| 1999-12-31T23:59:55.000Z | 1 минуттан аз   | 10 секундтан аз        | 1 минуттан аз бұрын      |
| 1999-12-31T23:59:45.000Z | 1 минуттан аз   | 20 секундтан аз        | 1 минуттан аз бұрын      |
| 1999-12-31T23:59:35.000Z | 1 минуттан аз   | жарты минут            | 1 минуттан аз бұрын      |
| 1999-12-31T23:59:00.000Z | 1 минут         | 1 минут                | 1 минут бұрын            |
| 1999-12-31T23:45:00.000Z | 15 минут        | 15 минут               | 15 минут бұрын           |
| 1999-12-31T23:30:00.000Z | 30 минут        | 30 минут               | 30 минут бұрын           |
| 1999-12-31T23:15:00.000Z | шамамен 1 сағат | шамамен 1 сағат        | шамамен 1 сағат бұрын    |
| 1999-12-31T23:00:00.000Z | шамамен 1 сағат | шамамен 1 сағат        | шамамен 1 сағат бұрын    |
| 1999-12-31T18:00:00.000Z | шамамен 6 сағат | шамамен 6 сағат        | шамамен 6 сағат бұрын    |
| 1999-12-30T00:00:00.000Z | 2 күн           | 2 күн                  | 2 күн бұрын              |
| 1999-12-15T00:00:00.000Z | 17 күн          | 17 күн                 | 17 күн бұрын             |
| 1999-12-01T00:00:00.000Z | шамамен 1 ай    | шамамен 1 ай           | шамамен 1 ай бұрын       |
| 1999-11-01T00:00:00.000Z | 2 ай            | 2 ай                   | 2 ай бұрын               |
| 1999-06-01T00:00:00.000Z | 7 ай            | 7 ай                   | 7 ай бұрын               |
| 1999-01-01T00:00:00.000Z | шамамен 1 жыл   | шамамен 1 жыл          | шамамен 1 жыл бұрын      |
| 1998-12-01T00:00:00.000Z | шамамен 1 жыл   | шамамен 1 жыл          | шамамен 1 жыл бұрын      |
| 1998-06-01T00:00:00.000Z | 1 жылдан астам  | 1 жылдан астам         | 1 жылдан астам бұрын     |
| 1998-01-01T00:00:00.000Z | шамамен 2 жыл   | шамамен 2 жыл          | шамамен 2 жыл бұрын      |
| 1997-01-01T00:00:00.000Z | шамамен 3 жыл   | шамамен 3 жыл          | шамамен 3 жыл бұрын      |
| 1996-01-01T00:00:00.000Z | шамамен 4 жыл   | шамамен 4 жыл          | шамамен 4 жыл бұрын      |
| 1995-01-01T00:00:00.000Z | шамамен 5 жыл   | шамамен 5 жыл          | шамамен 5 жыл бұрын      |
| 1994-01-01T00:00:00.000Z | шамамен 6 жыл   | шамамен 6 жыл          | шамамен 6 жыл бұрын      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 жыл     | 6 жылдан кейін     | 52608 сағат                    |
| 2005-01-01T00:00:00.000Z | 5 жыл     | 5 жылдан кейін     | 43848 сағат                    |
| 2004-01-01T00:00:00.000Z | 4 жыл     | 4 жылдан кейін     | 35064 сағат                    |
| 2003-01-01T00:00:00.000Z | 3 жыл     | 3 жылдан кейін     | 26304 сағат                    |
| 2002-01-01T00:00:00.000Z | 2 жыл     | 2 жылдан кейін     | 17544 сағат                    |
| 2001-06-01T00:00:00.000Z | 1 жыл     | 1 жылдан кейін     | 12408 сағат                    |
| 2001-02-01T00:00:00.000Z | 1 жыл     | 1 жылдан кейін     | 9528 сағат                     |
| 2001-01-01T00:00:00.000Z | 1 жыл     | 1 жылдан кейін     | 8784 сағат                     |
| 2000-06-01T00:00:00.000Z | 5 ай      | 5 ай кейін         | 3648 сағат                     |
| 2000-03-01T00:00:00.000Z | 2 ай      | 2 ай кейін         | 1440 сағат                     |
| 2000-02-01T00:00:00.000Z | 1 ай      | 1 ай кейін         | 744 сағат                      |
| 2000-01-15T00:00:00.000Z | 14 күн    | 14 күннен кейін    | 336 сағат                      |
| 2000-01-02T00:00:00.000Z | 1 күн     | 1 күннен кейін     | 24 сағат                       |
| 2000-01-01T06:00:00.000Z | 6 сағат   | 6 сағат кейін      | 6 сағат                        |
| 2000-01-01T01:00:00.000Z | 1 сағат   | 1 сағат кейін      | 1 сағат                        |
| 2000-01-01T00:45:00.000Z | 45 минут  | 45 минуттан кейін  | 1 сағат                        |
| 2000-01-01T00:30:00.000Z | 30 минут  | 30 минуттан кейін  | 1 сағат                        |
| 2000-01-01T00:15:00.000Z | 15 минут  | 15 минуттан кейін  | 0 сағат                        |
| 2000-01-01T00:01:00.000Z | 1 минут   | 1 минуттан кейін   | 0 сағат                        |
| 2000-01-01T00:00:25.000Z | 25 секунд | 25 секундтан кейін | 0 сағат                        |
| 2000-01-01T00:00:15.000Z | 15 секунд | 15 секундтан кейін | 0 сағат                        |
| 2000-01-01T00:00:05.000Z | 5 секунд  | 5 секундтан кейін  | 0 сағат                        |
| 2000-01-01T00:00:00.000Z | 0 секунд  | 0 секунд бұрын     | 0 сағат                        |
| 1999-12-31T23:59:55.000Z | 5 секунд  | 5 секунд бұрын     | 0 сағат                        |
| 1999-12-31T23:59:45.000Z | 15 секунд | 15 секунд бұрын    | 0 сағат                        |
| 1999-12-31T23:59:35.000Z | 25 секунд | 25 секунд бұрын    | 0 сағат                        |
| 1999-12-31T23:59:00.000Z | 1 минут   | 1 минут бұрын      | 0 сағат                        |
| 1999-12-31T23:45:00.000Z | 15 минут  | 15 минут бұрын     | 0 сағат                        |
| 1999-12-31T23:30:00.000Z | 30 минут  | 30 минут бұрын     | 1 сағат                        |
| 1999-12-31T23:15:00.000Z | 45 минут  | 45 минут бұрын     | 1 сағат                        |
| 1999-12-31T23:00:00.000Z | 1 сағат   | 1 сағат бұрын      | 1 сағат                        |
| 1999-12-31T18:00:00.000Z | 6 сағат   | 6 сағат бұрын      | 6 сағат                        |
| 1999-12-30T00:00:00.000Z | 2 күн     | 2 күн бұрын        | 48 сағат                       |
| 1999-12-15T00:00:00.000Z | 17 күн    | 17 күн бұрын       | 408 сағат                      |
| 1999-12-01T00:00:00.000Z | 1 ай      | 1 ай бұрын         | 744 сағат                      |
| 1999-11-01T00:00:00.000Z | 2 ай      | 2 ай бұрын         | 1464 сағат                     |
| 1999-06-01T00:00:00.000Z | 7 ай      | 7 ай бұрын         | 5136 сағат                     |
| 1999-01-01T00:00:00.000Z | 1 жыл     | 1 жыл бұрын        | 8760 сағат                     |
| 1998-12-01T00:00:00.000Z | 1 жыл     | 1 жыл бұрын        | 9504 сағат                     |
| 1998-06-01T00:00:00.000Z | 2 жыл     | 2 жыл бұрын        | 13896 сағат                    |
| 1998-01-01T00:00:00.000Z | 2 жыл     | 2 жыл бұрын        | 17520 сағат                    |
| 1997-01-01T00:00:00.000Z | 3 жыл     | 3 жыл бұрын        | 26280 сағат                    |
| 1996-01-01T00:00:00.000Z | 4 жыл     | 4 жыл бұрын        | 35064 сағат                    |
| 1995-01-01T00:00:00.000Z | 5 жыл     | 5 жыл бұрын        | 43824 сағат                    |
| 1994-01-01T00:00:00.000Z | 6 жыл     | 6 жыл бұрын        | 52584 сағат                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                          |
| ------------------------ | ------------------------------- |
| 2000-01-10T00:00:00.000Z | 10.01.2000                      |
| 2000-01-05T00:00:00.000Z | келесі сәрсенбіде сағат 0:00-де |
| 2000-01-02T00:00:00.000Z | ертең сағат 0:00-де             |
| 2000-01-01T00:00:00.000Z | бүгін сағат 0:00-де             |
| 1999-12-31T00:00:00.000Z | кеше сағат 0:00-де              |
| 1999-12-27T00:00:00.000Z | дүйсенбіде сағат 0:00-де        |
| 1999-12-21T00:00:00.000Z | 21.12.1999                      |
