/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.CharBuffer;
import org.jline.utils.ClosedException;
import org.jline.utils.NonBlockingReader;

public class NonBlockingPumpReader
extends NonBlockingReader {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final CharBuffer readBuffer;
    private final CharBuffer writeBuffer;
    private final Writer writer;
    private boolean closed;

    public NonBlockingPumpReader() {
        this(4096);
    }

    public NonBlockingPumpReader(int bufferSize) {
        char[] buf = new char[bufferSize];
        this.readBuffer = CharBuffer.wrap(buf);
        this.writeBuffer = CharBuffer.wrap(buf);
        this.writer = new NbpWriter();
        this.readBuffer.limit(0);
    }

    public Writer getWriter() {
        return this.writer;
    }

    private int wait(CharBuffer buffer, long timeout) throws InterruptedIOException {
        boolean isInfinite = timeout <= 0L;
        long end = 0L;
        if (!isInfinite) {
            end = System.currentTimeMillis() + timeout;
        }
        while (!(this.closed || buffer.hasRemaining() || !isInfinite && timeout <= 0L)) {
            this.notifyAll();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            if (isInfinite) continue;
            timeout = end - System.currentTimeMillis();
        }
        return this.closed ? -1 : (buffer.hasRemaining() ? 0 : -2);
    }

    private static boolean rewind(CharBuffer buffer, CharBuffer other) {
        if (buffer.position() > other.position()) {
            other.limit(buffer.position());
        }
        if (buffer.position() == buffer.capacity()) {
            buffer.rewind();
            buffer.limit(other.position());
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean ready() {
        return this.readBuffer.hasRemaining();
    }

    @Override
    public synchronized int available() {
        int count = this.readBuffer.remaining();
        if (this.writeBuffer.position() < this.readBuffer.position()) {
            count += this.writeBuffer.position();
        }
        return count;
    }

    @Override
    protected synchronized int read(long timeout, boolean isPeek) throws IOException {
        int res = this.wait(this.readBuffer, timeout);
        if (res >= 0) {
            res = isPeek ? this.readBuffer.get(this.readBuffer.position()) : this.readBuffer.get();
        }
        NonBlockingPumpReader.rewind(this.readBuffer, this.writeBuffer);
        return res;
    }

    @Override
    public int readBuffered(char[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (b.length == 0) {
            return 0;
        }
        int r = Math.min(b.length, this.readBuffer.remaining());
        if (r > 0) {
            this.readBuffer.get(b);
            return r;
        }
        r = this.read(-1L, false);
        if (r >= 0) {
            b[0] = (char)r;
            return 1;
        }
        return r;
    }

    synchronized void write(char[] cbuf, int off, int len) throws IOException {
        while (len > 0) {
            if (this.wait(this.writeBuffer, 0L) == -1) {
                throw new ClosedException();
            }
            int count = Math.min(len, this.writeBuffer.remaining());
            this.writeBuffer.put(cbuf, off, count);
            off += count;
            len -= count;
            NonBlockingPumpReader.rewind(this.writeBuffer, this.readBuffer);
        }
    }

    synchronized void flush() {
        if (this.readBuffer.hasRemaining()) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.notifyAll();
    }

    private class NbpWriter
    extends Writer {
        private NbpWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            NonBlockingPumpReader.this.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            NonBlockingPumpReader.this.flush();
        }

        @Override
        public void close() throws IOException {
            NonBlockingPumpReader.this.close();
        }
    }
}

