/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.ext;

import gnu.crypto.der.DERReader;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import gnu.crypto.pki.Util;
import gnu.crypto.pki.ext.AuthorityKeyIdentifier;
import gnu.crypto.pki.ext.BasicConstraints;
import gnu.crypto.pki.ext.CRLNumber;
import gnu.crypto.pki.ext.CertificatePolicies;
import gnu.crypto.pki.ext.ExtendedKeyUsage;
import gnu.crypto.pki.ext.IssuerAlternativeNames;
import gnu.crypto.pki.ext.KeyUsage;
import gnu.crypto.pki.ext.PolicyConstraint;
import gnu.crypto.pki.ext.PolicyMappings;
import gnu.crypto.pki.ext.PrivateKeyUsagePeriod;
import gnu.crypto.pki.ext.ReasonCode;
import gnu.crypto.pki.ext.SubjectAlternativeNames;
import gnu.crypto.pki.ext.SubjectKeyIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Extension {
    private static final boolean DEBUG = false;
    protected final OID oid;
    protected final boolean critical;
    protected boolean isSupported;
    protected final Value value;
    protected byte[] encoded;
    static /* synthetic */ Class class$gnu$crypto$pki$ext$Extension;

    private static final void debug(String msg) {
        System.err.print(">> Extension: ");
        System.err.println(msg);
    }

    public OID getOid() {
        return this.oid;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public Value getValue() {
        return this.value;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encode();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$crypto$pki$ext$Extension;
        if (clazz == null) {
            clazz = class$gnu$crypto$pki$ext$Extension = Extension.class("[Lgnu.crypto.pki.ext.Extension;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ id=").append(this.oid).append(" critical=").append(this.critical).append(" value=").append(this.value).append(" ]").toString();
    }

    public DERValue getDerValue() {
        ArrayList<DERValue> ext = new ArrayList<DERValue>(3);
        ext.add(new DERValue(6, this.oid));
        ext.add(new DERValue(1, new Boolean(this.critical)));
        ext.add(new DERValue(4, this.value.getEncoded()));
        return new DERValue(48, ext);
    }

    private final void encode() {
        this.encoded = this.getDerValue().getEncoded();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Extension(byte[] encoded) throws IOException {
        this.encoded = (byte[])encoded.clone();
        DERReader der = new DERReader(encoded);
        DERValue val = der.read();
        if (!val.isConstructed()) {
            throw new IOException("malformed Extension");
        }
        val = der.read();
        if (val.getTag() != 6) {
            throw new IOException("expecting OBJECT IDENTIFIER");
        }
        this.oid = (OID)val.getValue();
        val = der.read();
        if (val.getTag() == 1) {
            this.critical = (Boolean)val.getValue();
            val = der.read();
        } else {
            this.critical = false;
        }
        if (val.getTag() != 4) {
            throw new IOException("expecting OCTET STRING");
        }
        byte[] encval = (byte[])val.getValue();
        this.isSupported = true;
        if (this.oid.equals(AuthorityKeyIdentifier.ID)) {
            this.value = new AuthorityKeyIdentifier(encval);
        } else if (this.oid.equals(SubjectKeyIdentifier.ID)) {
            this.value = new SubjectKeyIdentifier(encval);
        } else if (this.oid.equals(KeyUsage.ID)) {
            this.value = new KeyUsage(encval);
        } else if (this.oid.equals(PrivateKeyUsagePeriod.ID)) {
            this.value = new PrivateKeyUsagePeriod(encval);
        } else if (this.oid.equals(CertificatePolicies.ID)) {
            this.value = new CertificatePolicies(encval);
        } else if (this.oid.equals(PolicyConstraint.ID)) {
            this.value = new PolicyConstraint(encval);
        } else if (this.oid.equals(PolicyMappings.ID)) {
            this.value = new PolicyMappings(encval);
        } else if (this.oid.equals(SubjectAlternativeNames.ID)) {
            this.value = new SubjectAlternativeNames(encval);
        } else if (this.oid.equals(IssuerAlternativeNames.ID)) {
            this.value = new IssuerAlternativeNames(encval);
        } else if (this.oid.equals(BasicConstraints.ID)) {
            this.value = new BasicConstraints(encval);
        } else if (this.oid.equals(ExtendedKeyUsage.ID)) {
            this.value = new ExtendedKeyUsage(encval);
        } else if (this.oid.equals(CRLNumber.ID)) {
            this.value = new CRLNumber(encval);
        } else if (this.oid.equals(ReasonCode.ID)) {
            this.value = new ReasonCode(encval);
        } else {
            this.value = new Value(encval);
            this.isSupported = false;
        }
    }

    public Extension(OID oid, Value value, boolean critical) {
        this.oid = oid;
        this.value = value;
        this.critical = critical;
        this.isSupported = true;
    }

    public static class Value {
        protected byte[] encoded;

        public byte[] getEncoded() {
            return this.encoded;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Value)) {
                return false;
            }
            return Arrays.equals(this.encoded, ((Value)o).encoded);
        }

        public String toString() {
            return Util.toHexString(this.encoded, ':');
        }

        public Value(byte[] encoded) {
            this.encoded = (byte[])encoded.clone();
        }

        protected Value() {
        }
    }
}

