/*******************************************************************************

  Copyright(c) 2002 - 2005 Promise Technology, Inc. All rights reserved.
  
  cam_var.c - contains declaration for global variables

  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Promise Technology, Inc.
  <support@promise.com.tw>	[TAIWAN]
  <support@promise.com>		[U.S.A]
  <support-china@promise.com>	[CHINA]

*******************************************************************************/

#include "cam_con.h"
#include "cam_def.h"


/* 
 * 	adapter configuartion 
 */
ADAPTER_CONFIG	gAdapterConfig[MAX_ADAPTER_NUM];
U32 ATABaseAddr[MAX_ATA_MODULE];
U32 XORBaseAddr[MAX_ADAPTER_NUM];
U32 HostBaseAddr[MAX_ADAPTER_NUM];
/*
 *	ATA channel configuration
 */
CHNL_CONFIG		gChnlConfig[MAX_ATA_MODULE];
/*
 *	device configuration
 */
 
DEV_CONFIG		gDrvConfig[MAX_ATA_MODULE][2];
CAM_IDENTIFY_DATA	gIdentify_Data[MAX_ATA_MODULE][2];
ENCLOSURE_TYPE	gBOXConfig[MAX_ATA_MODULE];
ENCLOSURE_STATUS gBOXStatus[MAX_ATA_MODULE];
ATA_TASK	boxATATask[MAX_ATA_MODULE];
ATA_TASK	boxLEDATATask[MAX_ATA_MODULE];
ATA_TASK	InternalATATask[MAX_ATA_MODULE][2];

/*
 *	Memory management 
 */
 
/* 
 * 	packets and queues 
 */
PCAM_ATA_PACKET ATAPacketQueue[MAX_ADAPTER_NUM][MAX_ATA_PAC];
PCAM_XOR_PACKET XORPacketQueue[MAX_ADAPTER_NUM][MAX_XOR_PAC];
U16 ATAPacketCurrent[MAX_ADAPTER_NUM];
U16 XORPacketCurrent[MAX_ADAPTER_NUM];
MODULE_PACKET_COUNT PacketQueueCount[MAX_ADAPTER_NUM];
MODULE_TIMEOUT CAMTimeoutTimes[MAX_ADAPTER_NUM];

/* sg queue */
PCAM_ATA_SG PCAM_ATA_SG_Queue[MAX_ADAPTER_NUM][MAX_ATA_PAC];
PCAM_XOR_SG PCAM_XOR_SG_Queue[MAX_ADAPTER_NUM][MAX_XOR_PAC];
U16 CAM_ATA_SG_Current[MAX_ADAPTER_NUM];
U16 CAM_XOR_SG_Current[MAX_ADAPTER_NUM];

/* 
 *	Sequences 
 */
SEQ_INFO	gSEQ_INFO[MAX_ADAPTER_NUM][MAX_SEQ_ID];
U8 SEQIDPool[MAX_ADAPTER_NUM][MAX_SEQ_ID];
U8 SEQIDCurrent[MAX_ADAPTER_NUM];


/* for push queued module */
/* for XOR */
U8	XORModuleNeedPush[MAX_ADAPTER_NUM];
U16 XORQueueHead[MAX_ADAPTER_NUM],XORQueueTail[MAX_ADAPTER_NUM];
XOR_QUEUE XorQueue[MAX_ADAPTER_NUM][MAX_XOR_PAC+1];
U32 XORModuleBusy[MAX_ADAPTER_NUM];
U8 XORModuleSEQID[MAX_ADAPTER_NUM];
U32 XOR_Timeout_TimerID[MAX_ADAPTER_NUM*MAX_XOR_MODULE];
U8 XORModuleReceiveTask[MAX_ADAPTER_NUM]={FALSE};

/* for ATA */
U8 	ATAModuleNeedPush[MAX_ATA_MODULE];
U16 ATAQueueHead[MAX_ATA_MODULE];
U16 ATAQueueTail[MAX_ATA_MODULE];
ATA_QUEUE ATAQueue[MAX_ATA_MODULE][MAX_ATA_PAC+1];
U32 ATAModuleBusy[MAX_ATA_MODULE];
U8 ATAModuleSEQID[MAX_ATA_MODULE];
U32 ATA_Timeout_TimerID[MAX_ATA_MODULE];
U32 BOX_Timeout_TimerID[MAX_ATA_MODULE];
U8 ATAModuleReceiveTask[MAX_ATA_MODULE]={FALSE};

#ifdef	_MMIO_
/* for flash memory */
FLASH_CONFIG	gFlashConfig[MAX_ADAPTER_NUM];
U8 flash_model1[] = "PMC Pm29F002";
U8 flash_model2[] = "MXIC MX29F002";
U8 flash_model3[] = "AMIC A290021";
U8 flash_model4[] = "Winbond W29C020";
U8 flash_model5[] = "ATMEL AT49F002NT";
U8 flash_model6[] = "EFST F49B002UA";
#endif
