/*******************************************************************************

  Copyright(c) 2002 - 2005 Promise Technology, Inc. All rights reserved.
  
  cam_fm.c - functions for flash memory access

  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Promise Technology, Inc.
  <support@promise.com.tw>	[TAIWAN]
  <support@promise.com>		[U.S.A]
  <support-china@promise.com>	[CHINA]

*******************************************************************************/
#include "cam_con.h"
#include "cam_def.h"
#include "cam_imp.h"
#include "cam_gb.h"
 
#ifdef	_MMIO_

U8 CAM_Find_FlashMemory (U8 Adapter_ID, PU8 pModelName)
{
	PFLASH_CONFIG pFlashConfig = &gFlashConfig[Adapter_ID];
	U32 BaseAddress;
	PU8 pModelString;
	U32 ldata;
	U32 lFlashPort;
	U16 FlashID = 0;
	U16 i;

	
	/* set */	
	if ( pFlashConfig->Flag & FLASH_620 ) {
		BaseAddress = HostBaseAddr[Adapter_ID];
		ldata = camReadRegDword(BaseAddress+oFFSETHOSTPCICTL);
		pFlashConfig->Old_Timing = ldata;
		ldata &= 0x0000FFFF;
		ldata |= 0x41030000;
		camWriteRegDword(BaseAddress+oFFSETHOSTPCICTL, ldata );
	}
	else if ( pFlashConfig->Flag & FLASH_320 ) {
		BaseAddress = ATABaseAddr[Adapter_ID*MAX_ATA_CHNL];
		ldata = camReadRegDword(BaseAddress+iNDEXIDETBGmode);
		pFlashConfig->Old_Timing = ldata;
		ldata &= 0xFFFCFFFF;
		ldata |= 0x00010000;
		camWriteRegDword(BaseAddress+iNDEXIDETBGmode, ldata );
	}
	pFlashConfig->New_Timing = ldata;
	camStallExecution(1);		/* wait a while (10 ms) after clock is changed*/

	/* find flash type */
	lFlashPort = pFlashConfig->FlashMemAddr;
	pFlashConfig->Flash_Type = 0xFFFF;

	camWriteRegByte((lFlashPort+0x555), 0xAA);
	camWriteRegByte((lFlashPort+0x2AA), 0x55);
	camWriteRegByte((lFlashPort+0x555), 0x90);
	FlashID = camReadRegWord(lFlashPort);
	camWriteRegByte((lFlashPort+0x555), 0xAA);
	camWriteRegByte((lFlashPort+0x2AA), 0x55);
	camWriteRegByte((lFlashPort+0x555), 0xF0);
	if ( FlashID == 0x1D9D  	/* PMC Pm29F002 */
	  || FlashID == 0xB0C2		/* MXIC MX29F002 */
	  || FlashID == 0x8C37 )	/* AMIC A290021 */
	{
		pFlashConfig->Flash_Type = 2;
		goto MAP_MODEL_NAME;
	}
	
	
	camWriteRegByte((lFlashPort+0x5555), 0xAA);
	camWriteRegByte((lFlashPort+0x2AAA), 0x55);
	camWriteRegByte((lFlashPort+0x5555), 0x80);
	camWriteRegByte((lFlashPort+0x5555), 0xAA);
	camWriteRegByte((lFlashPort+0x2AAA), 0x55);
	camWriteRegByte((lFlashPort+0x5555), 0x60);
	FlashID = camReadRegWord(lFlashPort);
	camWriteRegByte((lFlashPort+0x5555), 0xAA);
	camWriteRegByte((lFlashPort+0x2AAA), 0x55);
	camWriteRegByte((lFlashPort+0x5555), 0xF0);
	if ( FlashID == 0x45DA ) 	/* Winbond W29C020 */
	{
		pFlashConfig->Flash_Type = 3;
		goto MAP_MODEL_NAME;
	}	

	camWriteRegByte((lFlashPort+0x5555), 0xAA);
	camWriteRegByte((lFlashPort+0x2AAA), 0x55);
	camWriteRegByte((lFlashPort+0x5555), 0x90);
	FlashID = camReadRegWord(lFlashPort);
	camWriteRegByte((lFlashPort+0x5555), 0xAA);
	camWriteRegByte((lFlashPort+0x2AAA), 0x55);
	camWriteRegByte((lFlashPort+0x5555), 0xF0);
	if ( FlashID == 0x081F		/* ATMEL AT49F002NT */
	  || FlashID == 0x008C )	/* EFST F49B002UA */
	{
		pFlashConfig->Flash_Type = 4;
		goto MAP_MODEL_NAME;
	}
	
MAP_MODEL_NAME:
	/* restore */
	if ( pFlashConfig->Flag & FLASH_620 ) {
		BaseAddress = HostBaseAddr[Adapter_ID];
		camWriteRegDword(BaseAddress+oFFSETHOSTPCICTL, pFlashConfig->Old_Timing );
	}
	else if ( pFlashConfig->Flag & FLASH_320 ) {
		BaseAddress = ATABaseAddr[Adapter_ID*MAX_ATA_CHNL];
		camWriteRegDword(BaseAddress+iNDEXIDETBGmode, pFlashConfig->Old_Timing );
	}
	camStallExecution(1);		/* wait a while (10 ms) after clock is changed*/
	
	if ( pFlashConfig->Flash_Type != 0xFFFF )
	{	
		switch (FlashID)
		{
			case 0x1D9D:
				pModelString = (PU8)flash_model1;
				break;
			case 0xB0C2:
				pModelString = (PU8)flash_model2;
				break;
			case 0x8C37:
				pModelString = (PU8)flash_model3;
				break;
			case 0x45DA:
				pModelString = (PU8)flash_model4;
				break;
			case 0x081F:
				pModelString = (PU8)flash_model5;
				break;
			case 0x008C:
				pModelString = (PU8)flash_model6;
				break;	
			default:
				break;
		}
		for ( i = 0; i < 20; i++ )
			*pModelName++ = *pModelString++;
		
		return(camSUCCESS);
	}
	else
		return(camFAIL);

}

U8 CAM_Erase_FlashMemory(U8 Adapter_ID)
{
	PFLASH_CONFIG pFlashConfig = &gFlashConfig[Adapter_ID];
	U32 BaseAddress;
	U32 lFlashPort = pFlashConfig->FlashMemAddr;
	U32 i;
	
	/* set */	
	if ( pFlashConfig->Flag & FLASH_620 ) {
		BaseAddress = HostBaseAddr[Adapter_ID];
		camWriteRegDword(BaseAddress+oFFSETHOSTPCICTL, pFlashConfig->New_Timing );
	}
	else if ( pFlashConfig->Flag & FLASH_320 ) {
		BaseAddress = ATABaseAddr[Adapter_ID*MAX_ATA_CHNL];
		camWriteRegDword(BaseAddress+iNDEXIDETBGmode, pFlashConfig->New_Timing );
	}
	camStallExecution(1);		/* wait a while (10 ms) after clock is changed*/
	
	if ( pFlashConfig->Flash_Type == 2 )
	{
		camWriteRegByte((lFlashPort+0x555), 0xAA);
		camWriteRegByte((lFlashPort+0x2AA), 0x55);
		camWriteRegByte((lFlashPort+0x555), 0x80);
		camWriteRegByte((lFlashPort+0x555), 0xAA);
		camWriteRegByte((lFlashPort+0x2AA), 0x55);	
		camWriteRegByte((lFlashPort+0x555), 0x10);	
	}
	else /* type 3 or 4 */
	{
		camWriteRegByte((lFlashPort+0x5555), 0xAA);
		camWriteRegByte((lFlashPort+0x2AAA), 0x55);
		camWriteRegByte((lFlashPort+0x5555), 0x80);
		camWriteRegByte((lFlashPort+0x5555), 0xAA);
		camWriteRegByte((lFlashPort+0x2AAA), 0x55);
		camWriteRegByte((lFlashPort+0x5555), 0x10);
	}
	
	camStallExecution(5);		/* wait a while (50 ms) */
	
	for ( i = 0; i < 100*0x10000; i++ )
	{
		if ( camReadRegByte(lFlashPort) == 0xFF)
			break;
	}
	
	/* restore */
	if ( pFlashConfig->Flag & FLASH_620 ) {
		BaseAddress = HostBaseAddr[Adapter_ID];		
		camWriteRegDword(BaseAddress+oFFSETHOSTPCICTL, pFlashConfig->Old_Timing );
	}
	else if ( pFlashConfig->Flag & FLASH_320 ) {
		BaseAddress = ATABaseAddr[Adapter_ID*MAX_ATA_CHNL];
		camWriteRegDword(BaseAddress+iNDEXIDETBGmode, pFlashConfig->Old_Timing );
	}
	camStallExecution(1);		/* wait a while (10 ms) after clock is changed*/
	
	if ( i == 100*0x10000 )
		return (camFAIL);
	else
		return(camSUCCESS);
}

U8 CAM_Write_FlashMemory(U8 Adapter_ID, U32 Offset, U32 BufSize, PU8 pDatabuf)
{
	PFLASH_CONFIG pFlashConfig = &gFlashConfig[Adapter_ID];
	U32 BaseAddress;
	U32 lFlashPort = pFlashConfig->FlashMemAddr;
	U32 lFlashAddress = pFlashConfig->FlashMemAddr+Offset;
	U32 retry, i;
	U16 j;
	U8  blockcnt;
	U8  tmp_ch;
	
	/* set */	
	if ( pFlashConfig->Flag & FLASH_620 ) {
		BaseAddress = HostBaseAddr[Adapter_ID];
		camWriteRegDword(BaseAddress+oFFSETHOSTPCICTL, pFlashConfig->New_Timing );
	}
	else if ( pFlashConfig->Flag & FLASH_320 ) {
		BaseAddress = ATABaseAddr[Adapter_ID*MAX_ATA_CHNL];
		camWriteRegDword(BaseAddress+iNDEXIDETBGmode, pFlashConfig->New_Timing );
	}
	camStallExecution(1);		/* wait a while (10 ms) after clock is changed*/
		
	
	if ( pFlashConfig->Flash_Type == 2 )
	{
		BufSize <<= 10;	/* convert to byte count */
		for ( i = 0 ; i < BufSize ; i++ )
		{
			camWriteRegByte((lFlashPort+0x555), 0xAA);
			camWriteRegByte((lFlashPort+0x2AA), 0x55);
			camWriteRegByte((lFlashPort+0x555), 0xA0);
			tmp_ch = camReadRegByte(lFlashPort);	/* insert a extra read PCI memory action to break the merge by chipset */
			camWriteRegByte((lFlashAddress+i), *(pDatabuf+i));
	
			// check toggle - probe program byte complete or not
	
			for( retry =0; retry < 0x1000000 ; retry ++)
			{
				tmp_ch = camReadRegByte((lFlashAddress+i));
				if( tmp_ch == *(pDatabuf+i))
					break;
			}
			if( tmp_ch != *(pDatabuf+i) )
				break;
		}
		camStallExecution(5);		/* wait a while (50 ms) */
		camWriteRegByte((lFlashPort+0x555), 0xAA);
		camWriteRegByte((lFlashPort+0x2AA), 0x55);
		camWriteRegByte((lFlashPort+0x555), 0xF0);	/* reset to normal mode */
	}
	else if ( pFlashConfig->Flash_Type == 3 )
	{
		for ( i = 0 ; i < BufSize ; i++ )
		{
			for ( blockcnt = 0; blockcnt < 8; blockcnt++ )
			{
				for ( j = 0; j < 128; j++ )
				{
					camWriteRegByte((lFlashPort+0x5555), 0xAA);
					camWriteRegByte((lFlashPort+0x2AAA), 0x55);
					camWriteRegByte((lFlashPort+0x5555), 0xA0);
					tmp_ch = camReadRegByte(lFlashPort);	/* insert a extra read PCI memory action to break the merge by chipset */
					camWriteRegByte((lFlashAddress++), *(pDatabuf++));
				}
				camStallExecution(1);		/* wait a while (10 ms) */				
			}
		}
		camWriteRegByte((lFlashPort+0x5555), 0xAA);
		camWriteRegByte((lFlashPort+0x2AAA), 0x55);
		camWriteRegByte((lFlashPort+0x5555), 0xF0);	/* reset to normal mode */
	}
	else if ( pFlashConfig->Flash_Type == 4 )
	{
		BufSize <<= 10;	/* convert to byte count */
		for ( i = 0 ; i < BufSize ; i++ )
		{
			camWriteRegByte((lFlashPort+0x5555), 0xAA);
			camWriteRegByte((lFlashPort+0x2AAA), 0x55);
			camWriteRegByte((lFlashPort+0x5555), 0xA0);
			tmp_ch = camReadRegByte(lFlashPort);	/* insert a extra read PCI memory action to break the merge by chipset */
			camWriteRegByte((lFlashAddress+i), *(pDatabuf+i));
	
			// check toggle - probe program byte complete or not
	
			for( retry =0; retry < 0x1000000 ; retry ++)
			{
				tmp_ch = camReadRegByte((lFlashAddress+i));
				if( tmp_ch == *(pDatabuf+i))
					break;
			}
			if( tmp_ch != *(pDatabuf+i) )
				break;
		}
		camStallExecution(5);		/* wait a while (50 ms) */
		camWriteRegByte((lFlashPort+0x5555), 0xAA);
		camWriteRegByte((lFlashPort+0x2AAA), 0x55);
		camWriteRegByte((lFlashPort+0x5555), 0xF0);	/* reset to normal mode */		
	}	

	/* restore */
	if ( pFlashConfig->Flag & FLASH_620 ) {
		BaseAddress = HostBaseAddr[Adapter_ID];
		camWriteRegDword(BaseAddress+oFFSETHOSTPCICTL, pFlashConfig->Old_Timing );
	}
	else if ( pFlashConfig->Flag & FLASH_320 ) {
		BaseAddress = ATABaseAddr[Adapter_ID*MAX_ATA_CHNL];
		camWriteRegDword(BaseAddress+iNDEXIDETBGmode, pFlashConfig->Old_Timing );
	}
	camStallExecution(1);		/* wait a while (10 ms) after clock is changed*/
	
	if( i == BufSize )	
		return(camSUCCESS);
	else
		return(camFAIL);	
}

U8 CAM_Read_FlashMemory(U8 Adapter_ID, U32 Offset, U32 BufSize, PU8 pDatabuf)
{
	PFLASH_CONFIG pFlashConfig = &gFlashConfig[Adapter_ID];
	U32 lFlashAddress = pFlashConfig->FlashMemAddr+Offset;
	U32 i;
	
	
	BufSize <<= 10;	/* convert to byte count */
	
	for (i = 0; i < BufSize; i+=4 ) {
		*((PU32)(pDatabuf+i)) = camReadRegDword((lFlashAddress+i));
	}
	
	return(camSUCCESS);
}

#endif
