/******************************************************************************
 *
 * Name:	skrlmt.h
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.2 $
 * Date:	$Date: 2001/08/08 13:43:02 $
 * Purpose:	Header file for Redundant Link Management Technology.
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 *
 *	$Log: skrlmt.h,v $
 *	Revision 1.2  2001/08/08 13:43:02  rschmidt
 *	Added all defines and structure definitions from skrlmt.c
 *	
 *	Revision 1.1  2001/06/05 08:28:25  rassmann
 *	First public version.
 *	
 *
 ******************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 * This is the header file for Redundant Link ManagemenT.
 *
 * Include File Hierarchy:
 *
 *	"skdrv1st.h"
 *	...
 *	"sktypes.h"
 *	"skqueue.h"
 *	"skaddr.h"
 *	"skrlmt.h"
 *	...
 *	"skdrv2nd.h"
 *
 ******************************************************************************/

#ifndef __INC_SKRLMT_H
#define __INC_SKRLMT_H

#ifdef __cplusplus
#error C++ is not yet supported.
extern "C" {
#endif	/* cplusplus */

/* defines ********************************************************************/

#ifndef SK_HWAC_LINK_LED
#define SK_HWAC_LINK_LED(a,b,c,d)
#endif	/* !defined(SK_HWAC_LINK_LED) */

#ifndef DEBUG
#define RLMT_STATIC	static
#else	/* DEBUG */
#define RLMT_STATIC

#ifndef SK_LITTLE_ENDIAN
/* First 32 bits */
#define OFFS_LO32	1

/* Second 32 bits */
#define OFFS_HI32	0
#else	/* SK_LITTLE_ENDIAN */
/* First 32 bits */
#define OFFS_LO32	0

/* Second 32 bits */
#define OFFS_HI32	1
#endif	/* SK_LITTLE_ENDIAN */

#endif	/* DEBUG */

/* ----- Private timeout values ----- */

#define SK_RLMT_MIN_TO_VAL			   125000	/* 1/8 sec. */
#define SK_RLMT_DEF_TO_VAL			  1000000	/* 1 sec. */
#define SK_RLMT_PORTDOWN_TIM_VAL	   900000	/* another 0.9 sec. */
#define SK_RLMT_PORTUP_TIM_VAL		  2500000	/* 2.5 sec. */

/* Assume tick counter increment is 1 - may be set OS-dependent. */
#ifndef SK_TICK_INCR
#define SK_TICK_INCR	SK_CONSTU64(1)
#endif	/* !defined(SK_TICK_INCR) */

/*
 * Amount that a time stamp must be later to be recognized as "substantially
 * later". This is about 1/128 sec, but above 1 tick counter increment.
 */
#define SK_RLMT_BC_DELTA		(1 + ((SK_TICKS_PER_SEC >> 7) > SK_TICK_INCR ? \
									(SK_TICKS_PER_SEC >> 7) : SK_TICK_INCR))

/* ----- Private RLMT defaults ----- */

#define SK_RLMT_DEF_PREF_PORT	0					/* "Lower" port. */
#define SK_RLMT_DEF_MODE 		SK_RLMT_CHECK_LINK	/* Default RLMT Mode. */

/* ----- Private PORT checking states ----- */

#define SK_RLMT_PCS_TX			1		/* Port Check State: check tx. */
#define SK_RLMT_PCS_RX			2		/* Port Check State: check rx. */

/* ----- Private PORT events ----- */

/* Note: Update simulation when changing these. */
#define SK_RLMT_PORTUP_TIM		1101	/* Port can now go up. */
#define SK_RLMT_PORTDOWN_RX_TIM	1102	/* Port did not receive once ... */
#define SK_RLMT_PORTDOWN		1103	/* Port went down. */
#define SK_RLMT_PORTDOWN_TX_TIM	1104	/* Partner did not receive ... */


#define TO_SHORTEN(tim)	((tim) / 2)

/* LLC field values. */
#define LLC_COMMAND_RESPONSE_BIT		1
#define LLC_TEST_COMMAND				0xE3
#define LLC_UI							0x03

/* RLMT Packet fields. */
#define	SK_RLMT_DSAP					0
#define	SK_RLMT_SSAP					0
#define SK_RLMT_CTRL					(LLC_TEST_COMMAND)
#define SK_RLMT_INDICATOR0				0x53	/* S */
#define SK_RLMT_INDICATOR1				0x4B	/* K */
#define SK_RLMT_INDICATOR2				0x2D	/* - */
#define SK_RLMT_INDICATOR3				0x52	/* R */
#define SK_RLMT_INDICATOR4				0x4C	/* L */
#define SK_RLMT_INDICATOR5				0x4D	/* M */
#define SK_RLMT_INDICATOR6				0x54	/* T */
#define SK_RLMT_PACKET_VERSION			0

/* RLMT SPT Flag values. */
#define	SK_RLMT_SPT_FLAG_CHANGE			0x01
#define	SK_RLMT_SPT_FLAG_CHANGE_ACK		0x80

/* RLMT SPT Packet fields. */
#define	SK_RLMT_SPT_DSAP				0x42
#define	SK_RLMT_SPT_SSAP				0x42
#define SK_RLMT_SPT_CTRL				(LLC_UI)
#define	SK_RLMT_SPT_PROTOCOL_ID0		0x00
#define	SK_RLMT_SPT_PROTOCOL_ID1		0x00
#define	SK_RLMT_SPT_PROTOCOL_VERSION_ID	0x00
#define	SK_RLMT_SPT_BPDU_TYPE			0x00
#define	SK_RLMT_SPT_FLAGS				0x00	/* ?? */
#define	SK_RLMT_SPT_ROOT_ID0			0xFF	/* Lowest possible priority. */
#define	SK_RLMT_SPT_ROOT_ID1			0xFF	/* Lowest possible priority. */

/* Remaining 6 bytes will be the current port address. */
#define	SK_RLMT_SPT_ROOT_PATH_COST0		0x00
#define	SK_RLMT_SPT_ROOT_PATH_COST1		0x00
#define	SK_RLMT_SPT_ROOT_PATH_COST2		0x00
#define	SK_RLMT_SPT_ROOT_PATH_COST3		0x00
#define	SK_RLMT_SPT_BRIDGE_ID0			0xFF	/* Lowest possible priority. */
#define	SK_RLMT_SPT_BRIDGE_ID1			0xFF	/* Lowest possible priority. */

/* Remaining 6 bytes will be the current port address. */
#define	SK_RLMT_SPT_PORT_ID0			0xFF	/* Lowest possible priority. */
#define	SK_RLMT_SPT_PORT_ID1			0xFF	/* Lowest possible priority. */
#define	SK_RLMT_SPT_MSG_AGE0			0x00
#define	SK_RLMT_SPT_MSG_AGE1			0x00
#define	SK_RLMT_SPT_MAX_AGE0			0x00
#define	SK_RLMT_SPT_MAX_AGE1			0xFF
#define	SK_RLMT_SPT_HELLO_TIME0			0x00
#define	SK_RLMT_SPT_HELLO_TIME1			0xFF
#define	SK_RLMT_SPT_FWD_DELAY0			0x00
#define	SK_RLMT_SPT_FWD_DELAY1			0x40

/* Size defines. */
#define SK_RLMT_MIN_PACKET_SIZE			34
#define SK_RLMT_MAX_PACKET_SIZE			(SK_RLMT_MAX_TX_BUF_SIZE)
#define SK_PACKET_DATA_LEN				(SK_RLMT_MAX_PACKET_SIZE - \
										SK_RLMT_MIN_PACKET_SIZE)

/* ----- RLMT packet types ----- */
#define SK_PACKET_ANNOUNCE				1	/* Port announcement. */
#define SK_PACKET_ALIVE					2	/* Alive packet to port. */
#define SK_PACKET_ADDR_CHANGED			3	/* Port address changed. */
#define SK_PACKET_CHECK_TX				4	/* Check your tx line. */


/* ----- NET states ----- */

#define	SK_RLMT_NET_DOWN_TEMP	1	/* NET_DOWN due to last port down. */
#define	SK_RLMT_NET_DOWN_FINAL	2	/* NET_DOWN due to RLMT_STOP. */

#define SK_RLMT_MAX_TX_BUF_SIZE	60	/* Maximum RLMT transmit size. */

/* ----- PORT states ----- */

#define SK_RLMT_PS_INIT			0	/* Port state: Init. */
#define SK_RLMT_PS_LINK_DOWN	1	/* Port state: Link down. */
#define SK_RLMT_PS_DOWN			2	/* Port state: Port down. */
#define SK_RLMT_PS_GOING_UP		3	/* Port state: Going up. */
#define SK_RLMT_PS_UP			4	/* Port state: Up. */

/* ----- RLMT states ----- */

#define SK_RLMT_RS_INIT			0	/* RLMT state: Init. */
#define SK_RLMT_RS_NET_DOWN		1	/* RLMT state: Net down. */
#define SK_RLMT_RS_NET_UP		2	/* RLMT state: Net up. */

/* ----- PORT events ----- */

#define SK_RLMT_LINK_UP			1001	/* Link came up. */
#define SK_RLMT_LINK_DOWN		1002	/* Link went down. */
#define SK_RLMT_PORT_ADDR		1003	/* Port address changed. */

/* ----- RLMT events ----- */

#define SK_RLMT_START			2001	/* Start RLMT. */
#define SK_RLMT_STOP			2002	/* Stop RLMT. */
#define SK_RLMT_PACKET_RECEIVED	2003	/* Packet was received for RLMT. */
#define SK_RLMT_STATS_CLEAR		2004	/* Clear statistics. */
#define SK_RLMT_STATS_UPDATE	2005	/* Update statistics. */
#define SK_RLMT_PREFPORT_CHANGE	2006	/* Change preferred port. */
#define SK_RLMT_MODE_CHANGE		2007	/* New RlmtMode. */

/* ----- RLMT mode bits ----- */

/*
 * CAUTION:	These defines are private to RLMT.
 *			Please use the RLMT mode defines below.
 */

#define SK_RLMT_CHECK_LINK		  1		/* Check link. */

#ifndef SK_RLMT_ENABLE_TRANSPARENT
#define SK_RLMT_TRANSPARENT		  0		/* RLMT transparent - inactive. */
#else	/* SK_RLMT_ENABLE_TRANSPARENT */
#define SK_RLMT_TRANSPARENT		128		/* RLMT transparent. */
#endif	/* SK_RLMT_ENABLE_TRANSPARENT */

/* ----- RLMT modes ----- */

/* Check Link State. */
#define SK_RLMT_MODE_CLS	(SK_RLMT_CHECK_LINK)

/* ----- RLMT lookahead result bits ----- */

#define SK_RLMT_RX_RLMT			1	/* Give packet to RLMT. */
#define SK_RLMT_RX_PROTOCOL		2	/* Give packet to protocol. */

/* Error numbers and messages. */
#define SKERR_RLMT_E001		(SK_ERRBASE_RLMT + 0)
#define SKERR_RLMT_E001_MSG	"No Packet."
#define SKERR_RLMT_E002		(SKERR_RLMT_E001 + 1)
#define SKERR_RLMT_E002_MSG	"Short Packet."
#define SKERR_RLMT_E003		(SKERR_RLMT_E002 + 1)
#define SKERR_RLMT_E003_MSG	"Unknown RLMT event."
#define SKERR_RLMT_E004		(SKERR_RLMT_E003 + 1)
#define SKERR_RLMT_E004_MSG	"PortsUp incorrect."
#define SKERR_RLMT_E005		(SKERR_RLMT_E004 + 1)
#define SKERR_RLMT_E005_MSG	\
 "Net seems to be segmented (different root bridges are reported on the ports)."
#define SKERR_RLMT_E006		(SKERR_RLMT_E005 + 1)
#define SKERR_RLMT_E006_MSG	"Duplicate MAC Address detected."
#define SKERR_RLMT_E007		(SKERR_RLMT_E006 + 1)
#define SKERR_RLMT_E007_MSG	"LinksUp incorrect."
#define SKERR_RLMT_E008		(SKERR_RLMT_E007 + 1)
#define SKERR_RLMT_E008_MSG	"Port not started but link came up."
#define SKERR_RLMT_E009		(SKERR_RLMT_E008 + 1)
#define SKERR_RLMT_E009_MSG	"Corrected illegal setting of Preferred Port."
#define SKERR_RLMT_E010		(SKERR_RLMT_E009 + 1)
#define SKERR_RLMT_E010_MSG	"Ignored illegal Preferred Port."


/* Macros */

#ifdef SK_LITTLE_ENDIAN
#define SK_U16_TO_NETWORK_ORDER(Val,Addr) { \
	SK_U8	*_Addr = (SK_U8*)(Addr); \
	SK_U16	_Val = (SK_U16)(Val); \
	*_Addr++ = (SK_U8)(_Val >> 8); \
	*_Addr = (SK_U8)(_Val & 0xFF); \
}
#else
#define SK_U16_TO_NETWORK_ORDER(Val,Addr) (*(SK_U16*)(Addr) = (SK_U16)(Val))
#endif	/* SK_LITTLE_ENDIAN */

#if 0
SK_AC		*pAC		/* adapter context */
unsigned	PktLen		/* received packet's length */
SK_BOOL		IsBc		/* Flag: packet is broadcast */
unsigned	*pOffset	/* offs. of bytes to present to SK_RLMT_LOOKAHEAD */
unsigned	*pNumBytes	/* #Bytes to present to SK_RLMT_LOOKAHEAD */
#endif	/* 0 */

#define SK_RLMT_PRE_LOOKAHEAD(pAC,PktLen,IsBc,pOffset,pNumBytes) { \
	SK_AC	*_pAC; \
	_pAC = (pAC); \
	/* _pAC->Rlmt.Port.PacketsRx++; */ \
	_pAC->Rlmt.Port.PacketsPerTimeSlot++; \
	if ((_pAC->Rlmt.Port.Net->RlmtMode & SK_RLMT_TRANSPARENT) != 0) { \
		*(pNumBytes) = 0; \
	} \
	else if (IsBc) { \
		if (_pAC->Rlmt.Port.Net->RlmtMode != SK_RLMT_MODE_CLS) { \
			*(pNumBytes) = 6; \
			*(pOffset) = 6; \
		} \
		else { \
			*(pNumBytes) = 0; \
		} \
	} \
	else { \
		if ((PktLen) > SK_RLMT_MAX_TX_BUF_SIZE) { \
			/* _pAC->Rlmt.Port.DataPacketsPerTimeSlot++; */ \
			*(pNumBytes) = 0; \
		} \
		else { \
			*(pNumBytes) = 6; \
			*(pOffset) = 0; \
		} \
	} \
}

#if 0
SK_AC		*pAC		/* adapter context */
SK_U8		*pLaPacket,	/* received packet's data (points to pOffset) */
SK_BOOL		IsBc		/* Flag: packet is broadcast */
SK_BOOL		IsMc		/* Flag: packet is multicast */
unsigned	*pForRlmt	/* Result: bits SK_RLMT_RX_RLMT, SK_RLMT_RX_PROTOCOL */
SK_RLMT_LOOKAHEAD() expects *pNumBytes from
packet offset *pOffset (s.a.) at *pLaPacket.

If you use SK_RLMT_LOOKAHEAD in a path where you already know if the packet is
BC, MC, or UC, you should use constants for IsBc and IsMc, so that your compiler
can trash unneeded parts of the if construction.
#endif	/* 0 */

extern	SK_MAC_ADDR	BridgeMcAddr;
extern	SK_MAC_ADDR	SkRlmtMcAddr;

#define SK_RLMT_LOOKAHEAD(pAC,pLaPacket,IsBc,IsMc,pForRlmt) { \
	SK_AC	*_pAC; \
	SK_U8	*_pLaPacket; \
	_pAC = (pAC); \
	_pLaPacket = (SK_U8 *)(pLaPacket); \
	if (IsBc) {\
		if (!SK_ADDR_EQUAL(_pLaPacket, _pAC->Addr.Net[_pAC->Rlmt.Port. \
			Net->NetNumber].CurrentMacAddress.a)) { \
		} \
		/* _pAC->Rlmt.Port.DataPacketsPerTimeSlot++; */ \
		*(pForRlmt) = SK_RLMT_RX_PROTOCOL; \
	} \
	else if (IsMc) { \
		if (SK_ADDR_EQUAL(_pLaPacket, SkRlmtMcAddr.a)) { \
			*(pForRlmt) = SK_RLMT_RX_RLMT; \
		} \
		else { \
			/* _pAC->Rlmt.Port.DataPacketsPerTimeSlot++; */ \
			*(pForRlmt) = SK_RLMT_RX_PROTOCOL; \
		} \
	} \
	else { \
		if (SK_ADDR_EQUAL( \
			_pLaPacket, \
			_pAC->Addr.Port.CurrentMacAddress.a)) { \
			*(pForRlmt) = SK_RLMT_RX_RLMT; \
		} \
		else { \
			/* _pAC->Rlmt.Port.DataPacketsPerTimeSlot++; */ \
			*(pForRlmt) = SK_RLMT_RX_PROTOCOL; \
		} \
	} \
}

/* typedefs *******************************************************************/

#ifdef SK_RLMT_MBUF_PRIVATE
typedef struct s_RlmtMbuf {
	some content
} SK_RLMT_MBUF;
#endif	/* SK_RLMT_MBUF_PRIVATE */


typedef struct s_RootId {
	SK_U8		Id[8];					/* Root Bridge Id. */
} SK_RLMT_ROOT_ID;


typedef struct s_RlmtNet SK_RLMT_NET;


typedef struct s_RlmtPort {

/* ----- Public part (read-only) ----- */

	SK_U8			PortState;				/* Current state of this port. */

	/* For PNMI */
	SK_BOOL			LinkDown;
	SK_BOOL			PortDown;
	SK_U8			Align01;

	SK_RLMT_NET		*Net;					/* Net port belongs to. */

	SK_U64			TxHelloCts;
	SK_U64			RxHelloCts;

/* ----- Private part ----- */

/*	SK_U64			PacketsRx; */				/* Total packets received. */
	SK_U32			PacketsPerTimeSlot;		/* Packets rxed between TOs. */
/*	SK_U32			DataPacketsPerTimeSlot; */	/* Data packets ... */

	SK_TIMER		UpTimer;				/* Timer struct Link/Port up. */
	SK_TIMER		DownRxTimer;			/* Timer struct down rx. */
	SK_TIMER		DownTxTimer;			/* Timer struct down tx. */

	SK_ADDR_PORT	*AddrPort;

	SK_U8			Random[4];				/* Random value. */

	SK_BOOL			PortStarted;			/* Port is started. */
	SK_BOOL			PortNoRx;				/* NoRx for >= 1 time slot. */
	SK_BOOL			RootIdSet;
	SK_RLMT_ROOT_ID	Root;					/* Root Bridge Id. */
} SK_RLMT_PORT;


struct s_RlmtNet {

/* ----- Public part (read-only) ----- */

	SK_RLMT_PORT	*Port;				/* Port that belongs to this net. */

	/* For PNMI */
	SK_U32			RlmtMode;			/* Check ... */
	SK_U8			RlmtState;			/* Current RLMT state. */

/* ----- Private part ----- */
	SK_BOOL			RootIdSet;
	SK_U16			Align01;

	int				LinksUp;			/* #Links up. */
	int				PortsUp;			/* #Ports up. */
	SK_U32			TimeoutValue;		/* RLMT timeout value. */

	SK_RLMT_ROOT_ID	Root;				/* Root Bridge Id. */
};


typedef struct s_Rlmt {

/* ----- Public part (read-only) ----- */

	SK_U32			NumNets;			/* Number of nets. */
	SK_U32			NetsStarted;		/* Number of nets started. */
	SK_RLMT_NET		Net;				/* Available net. */
	SK_RLMT_PORT	Port;				/* Available port. */

/* ----- Private part ----- */

} SK_RLMT;


/* typedefs *******************************************************************/

/* RLMT packet.  Length: SK_RLMT_MAX_PACKET_SIZE (60) bytes. */
typedef struct s_RlmtPacket {
	SK_U8	DstAddr[SK_MAC_ADDR_LEN];
	SK_U8	SrcAddr[SK_MAC_ADDR_LEN];
	SK_U8	TypeLen[2];
	SK_U8	DSap;
	SK_U8	SSap;
	SK_U8	Ctrl;
	SK_U8	Indicator[7];
	SK_U8	RlmtPacketType[2];
	SK_U8	Align1[2];
	SK_U8	Random[4];				/* Random value of requesting(!) station. */
	SK_U8	RlmtPacketVersion[2];	/* RLMT Packet version. */
	SK_U8	Data[SK_PACKET_DATA_LEN];
} SK_RLMT_PACKET;

typedef struct s_SpTreeRlmtPacket {
	SK_U8	DstAddr[SK_MAC_ADDR_LEN];
	SK_U8	SrcAddr[SK_MAC_ADDR_LEN];
	SK_U8	TypeLen[2];
	SK_U8	DSap;
	SK_U8	SSap;
	SK_U8	Ctrl;
	SK_U8	ProtocolId[2];
	SK_U8	ProtocolVersionId;
	SK_U8	BpduType;
	SK_U8	Flags;
	SK_U8	RootId[8];
	SK_U8	RootPathCost[4];
	SK_U8	BridgeId[8];
	SK_U8	PortId[2];
	SK_U8	MessageAge[2];
	SK_U8	MaxAge[2];
	SK_U8	HelloTime[2];
	SK_U8	ForwardDelay[2];
} SK_SPTREE_PACKET;

/* function prototypes ********************************************************/


#ifndef SK_KR_PROTO

/* Functions provided by SkRlmt */

/* ANSI/C++ compliant function prototypes */

extern	void	SkRlmtInit(
	SK_AC	*pAC,
	SK_IOC	IoC,
	int		Level);

extern	int	SkRlmtEvent(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U32		Event,
	SK_EVPARA	Para);

#else	/* defined(SK_KR_PROTO) */

/* Non-ANSI/C++ compliant function prototypes */

#error KR-style function prototypes are not yet provided.

#endif	/* defined(SK_KR_PROTO)) */


#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif	/* __INC_SKRLMT_H */

