#include "config.h"

#if HAVE_AFINET6
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include <linux/route.h>
#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <resolv.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <netinet6/in6.h>
#include <netinet6/ipv6.h>
#include "version.h"
#include "net-support.h"
#include "pathnames.h"
#define  EXTERN
#include "net-locale.h"

#include "net-features.h"

extern     struct aftype   inet6_aftype;


int rprint_fib6(int ext, int numeric)
{
  char buff[4096], iface[16], flags[16];
  char addr6[128], naddr6[128];
  struct sockaddr_in6 saddr6, snaddr6;
  int num, iflags, metric, refcnt, use, prefix_len;
  FILE *fp=fopen(_PATH_PROCNET_ROUTE6, "r");
  char addr6p[8][5], naddr6p[8][5];

  if (!fp) {
	ESYSNOT("getroute","INET6 FIB");
	return 1;
  }

  printf(NLS_CATGETS(catfd, inet6Set, inet6_table, "Kernel IPv6 routing table\n"));

  printf(NLS_CATGETS(catfd, inet6Set, inet6_header2,
		     "Destination                                 "
		     "Next Hop                                "
		     "Flags Metric Ref    Use Iface\n"));

  while (fgets(buff, 1023, fp))
  {
	num = sscanf(buff, "%4s%4s%4s%4s%4s%4s%4s%4s %02x %4s%4s%4s%4s%4s%4s%4s%4s %02x %02x %02x %04x %s\n",
		     addr6p[0], addr6p[1], addr6p[2], addr6p[3],
		     addr6p[4], addr6p[5], addr6p[6], addr6p[7],
		     &prefix_len,
		     naddr6p[0], naddr6p[1], naddr6p[2], naddr6p[3],
		     naddr6p[4], naddr6p[5], naddr6p[6], naddr6p[7],
		     &metric, &use, &refcnt, &iflags, iface);
#if 0
	if (num < 23) continue;
#endif
	/* Fetch and resolve the target address. */
	sprintf(addr6, "%s:%s:%s:%s:%s:%s:%s:%s",
		addr6p[0], addr6p[1], addr6p[2], addr6p[3],
		addr6p[4], addr6p[5], addr6p[6], addr6p[7]);
	inet6_aftype.input(1, addr6, (struct sockaddr *)&saddr6);
	sprintf(addr6, "%s/%d",
		inet6_aftype.sprint((struct sockaddr *)&saddr6, 1),
		prefix_len);
	
	/* Fetch and resolve the nexthop address. */
	sprintf(naddr6, "%s:%s:%s:%s:%s:%s:%s:%s",
		naddr6p[0], naddr6p[1], naddr6p[2], naddr6p[3],
		naddr6p[4], naddr6p[5], naddr6p[6], naddr6p[7]);
	inet6_aftype.input(1, naddr6, (struct sockaddr *)&snaddr6);
	sprintf(naddr6, "%s",
		inet6_aftype.sprint((struct sockaddr *)&snaddr6, 1));
	
	/* Decode the flags. */
	flags[0] = '\0';
	if (iflags & RTF_UP) strcat(flags, "U");
	if (iflags & RTF_GATEWAY) strcat(flags, "G");
	if (iflags & RTF_HOST) strcat(flags, "H");
	if (iflags & RTF_DYNAMIC) strcat(flags, "D");
	if (iflags & RTF_MODIFIED) strcat(flags, "M");
	if (iflags & RTF_DCACHE) strcat(flags, "C");
	
	/* Print the info. */
	printf("%-43s %-39s %-5s %-6d %-2d %7d %-8s\n",
	       addr6, naddr6, flags, metric, refcnt, use, iface);
  }

  (void) fclose(fp);
  return(0);
}

int INET6_rprint(int options)
{
  int ext = options & FLAG_EXT;
  int numeric = options & (FLAG_NUM|FLAG_SYM);
  int rc = E_INTERN;
  
  if (options & FLAG_FIB)
	if ((rc = rprint_fib6(ext,numeric)))
  		return(rc);
  
  return(rc);
}

#endif	/* HAVE_AFINET6 */
