#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <linux/in6.h>


char *inet_ntop(int af, const void *ap, size_t len, char *cp);
int inet_pton(int af, const char *s, void *ap);


int main(int argc, char *argv[])
{
        struct in6_addr addr;
        char buffer[100], inbuff[100];
	char *tmp;

	while(fgets(inbuff,99, stdin) != NULL) {
		tmp = strchr(inbuff, '\n');
		if (tmp) *tmp = '\0';
		memset(&addr,0,sizeof(addr));
		if (inet_pton(AF_INET6,inbuff,(void *)&addr) < 0) {
			fprintf(stderr,"Couldn't get address from %s\n",inbuff);
		} else {
			if (inet_ntop(AF_INET6,&addr, sizeof(addr), buffer) ==
			    inet_ntop(AF_INET6,&addr, sizeof(addr), NULL)) {
				fprintf(stderr,"External buffer not used\n");
			}
			printf("%s<->%s\n",inbuff,buffer);
		}
        }
	
}

