/*  getstats.c: A utility for the DIGITAL EtherWORKS 3 ethernet cards.

    Written 1994 by David C. Davies.

    Copyright 1994 Digital Equipment Corporation.

    This software may be used and distributed according to the terms of
    the GNU Public License, incorporated herein by reference.

    This utility is written for the Digital  Equipment Corporation series of
    EtherWORKS 3 ethernet cards:

	DE203 Turbo (BNC)
	DE204 Turbo (TP)
	DE205 Turbo (TP BNC)

    The author may    be  reached as davies@wanton.lkg.dec.com  or   Digital
    Equipment Corporation, 550 King Street, Littleton MA 01460.

    =========================================================================
    This utility  is designed to present  the network statistics gathered by
    the ewrk3 driver.

    TO DO:
    ------


    Revision History
    ----------------

    Version   Date        Description
  
      0.10   21-sep-94     Initial writing. ALPHA code release.

    =========================================================================
*/

static char *version = "getstats.c:v0.10 9/21/94 davies@wanton.lkg.dec.com\n";

#include <stdio.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <string.h>
#include <linux/if.h>

#include "../ewrk3.h"


main(int argc, char **argv)
{
  union {
    unsigned char buff[1024];
    unsigned long pkt[256];
  } data;
  int i, skfd;
  float pc;
  struct ifreq ifr;
  struct ewrk3_ioctl *ioc;

  if (argc > 1) {
    if ((skfd = socket(AF_INET, SOCK_DGRAM, 0)) >= 0) {
    
      strcpy(ifr.ifr_name, argv[1]);
      ioc = (struct ewrk3_ioctl *) &ifr.ifr_data;
      ioc->data = (char *)data.buff;

      ioc->cmd = EWRK3_GET_STATS;
      if (ioctl(skfd, EWRK3IOCTL, &ifr) != -1) {

	for (i=1; i<13; i++) {
	  if (data.pkt[0] > 0) {
	    pc = (float)(data.pkt[i]) / (float)data.pkt[0] * 100.0;
	  } else {
	    pc = 0.0;
	  }
	  printf("<%4d:     %11ld \t (%.1f%%)\n",i*128,(unsigned long)data.pkt[i], pc);
	}
	printf("Total: %ld\n\n",(unsigned long)data.pkt[0]);

	if (data.pkt[0] > 0) {
	  printf("Unicast:   %11ld \t (%.1f%%)\n",(unsigned long)data.pkt[16], 
	                          (float)data.pkt[16]/(float)data.pkt[0]*100.);
	  printf("Multicast: %11ld \t (%.1f%%)\n",(unsigned long)data.pkt[17],
		                  (float)data.pkt[17]/(float)data.pkt[0]*100.);
	  printf("Broadcast: %11ld \t (%.1f%%)\n",(unsigned long)data.pkt[18], 
	                          (float)data.pkt[18]/(float)data.pkt[0]*100.);
	  printf("Tx URs   : %11ld \t (%.1f%%)\n",(unsigned long)data.pkt[19], 
	                          (float)data.pkt[19]/(float)data.pkt[0]*100.);
	  printf("Excess URs:%11ld \t (%.1f%%)\n",(unsigned long)data.pkt[20], 
	                          (float)data.pkt[20]/(float)data.pkt[0]*100.);
	}
      } else {
	perror("getstats\007");
      }
    } else {
      printf("%s: Unable to open socket.\007\n", argv[0]);
    }
  } else {
    printf("%s: Need a device name\007\n", argv[0]);
  }
}

