/*
 * ps.h
 *
 * Copyright (c) 1992 Branko Lankester
 *
 */

extern unsigned long nr_pages;

extern int show_env;	/* -e flag */
extern int kern_comm;	/* -c flag */
extern int maxcmd;

extern char *swappath[];
extern char *kmem_path;

#define	MAXCMD	512	/* max # bytes to copy from args/env */

#define	PZERO	15	/* priority of init (in sched.h) */

#define	PAGE_MASK	0xfff


extern caddr_t kbase;

#define	KWORD(a)	(*((unsigned long *)(kbase + (a))))
#define	KPTR(p)		((void *) ((unsigned long) (p) + kbase))


#define	KSTK_EIP(stack)	((stack)[1019])
#define	KSTK_ESP(stack)	((stack)[1022])

#define	_SSIZE(stack)	(TASK_SIZE - KSTK_ESP(stack))
#define	SSIZE(stack)	(KSTK_ESP(stack) ? _SSIZE(stack) : 0)

#define	VSIZE(task,stack) (((task)->brk + 1023 + SSIZE(stack)) / 1024)
#define	SIZE(task,stack)  (((task)->brk - (task)->end_code + 1023 + \
			  SSIZE(stack)) / 1024)

typedef unsigned reg_t;

struct mem_info {
    int size;
    int rss;	/* should be the same as task->rss */
    int trs;	/* text resident set size */
    int drs;	/* dirty pages */
    int swap;	/* pages swapped out */
    int share;
    int lrs;	/* shared library rss */
    int dt;	/* dirty library pages */
    int acc;
    int dirt;
    int wp;
    int pmem;
};

struct mem_info *get_mem_info();
char *find_func();
unsigned long k_addr();
unsigned long get_kword();
char *cmd_args();
char *dev_to_tty();
char *wchan();
char *status();
char *xmalloc();
