/*
 * devname.c
 *
 */

#include <sys/stat.h>
#include <string.h>

/*
 * ttynames:
 *
 * define VC_a if you have:
 * 	ttya0 a1 a2...	virtual consoles
 *
 * define SERIAL_S if you have:
 *	ttyS0 S1 S2...	serial lines
 * or define SERIAL_s if you have:
 *	ttys0 s1 s2...	serial lines
 *
 */

#ifdef SERIAL_S
#define SER	"STUV"
#elif SERIAL_s
#define SER	"stuv"
#else
#define SER	"0123"
#endif

#ifdef VC_a
#define VC	"abcd"
#else
#define VC	" abc"
#endif

static char *ttgrp = VC SER "PQRSpqrs";
static char *ttsub = "0123456789abcdef";

char *
dev_to_tty(int dev)
{
    static char tty[3];

    if (dev == -1)
	return "? ";
    if (dev == 0)
	return "co";

    tty[0] = ttgrp[(dev >> 4) & 017];
    tty[1] = ttsub[dev & 017];
    if (tty[0] == ' ')
	return tty+1;
    else
	return(tty);
}

tty_to_dev(tty)
char *tty;
{
    char *p, *q;

    if (*tty == '\0') {		/* empty string: controlling tty */
	struct stat buf;
	if (fstat(0, &buf) != -1)
	    return(buf.st_rdev & 0xff);
	else
	    return -1;
    }
    if (tty[1] == '\0' && *tty >= '0' && *tty <= '9')
	return(*tty - '0');
    if (strcmp(tty, "co") == 0)
	return 0;
    if ((p = strchr(ttgrp, *tty)) != NULL &&
	(q = strchr(ttsub, tty[1])) != NULL)
	return(((p - ttgrp) << 4) | (q - ttsub));
    else
	return -1;
}
