/* 
 *  printid.c - print user or group id
 *  Copyright (C) 1994  Thomas Koenig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <getopt.h>
#include <grp.h>
#include <pwd.h>
#include <stdlib.h>
#include <stdio.h>

#define USAGE do {\
		   fprintf(stderr,"%s [-g groupid | -u userid]\n",argv[0]);\
		   exit(1);\
	   } while(0)

char options[]="g:u:";

void print_groupid(const char *s)
{
    struct group *pwe;

    pwe = getgrnam(s);
    if (pwe == NULL)
    {
	fprintf(stderr,"%s: ");
	perror("Group entry not found");
	exit(1);
    }
    printf("%ld\n",(long) pwe->gr_gid); 
}

void print_userid(const char *s)
{
    struct passwd *pwe;

    pwe = getpwnam(s);
    if (pwe == NULL)
    {
	fprintf(stderr,"%s: ");
	perror("Userid not found");
	exit(1);
    }
    printf("%ld\n",(long) pwe->pw_uid);
}

int main(int argc,char **argv)
{
    int c, opterr;

    opterr=1;
    while ((c=getopt(argc, argv, options)) != EOF)
	switch(c)
	{
	case 'g':
	    print_groupid(optarg);
	    break;
	case 'u':
	    print_userid(optarg);
	}
    if ((optind!=argc) || (optind < 1))
	USAGE;
    exit(0);
}
