/* write.c - send AAL5 PDU */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>


int main(int argc,char **argv)
{
    struct sockaddr_atmpvc addr;
    int s,size,offset;

    if (argc != 5 && argc != 6) {
	fprintf(stderr,"usage: %s itf vpi vci data [ offset ] \n",argv[0]);
	return 1;
    }
    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,ATM_AAL5)) < 0) {
	perror("socket");
	return 1;
    }
    memset(&addr,0,sizeof(addr));
    addr.sap_family = AF_ATMPVC;
    addr.sap_addr.itf = atoi(argv[1]);
    addr.sap_addr.vpi = atoi(argv[2]);
    addr.sap_addr.vci = atoi(argv[3]);
    addr.sap_txtp.class = ATM_UBR;
    offset = argc == 5 ? 0 : atoi(argv[5]);
    if (connect(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    size = write(s,argv[4]+offset,strlen(argv[4])-offset);
    printf("%d(%s)\n",size,strerror(errno));
    return 0;
}
