/* itf.c - IP interface registry */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

#include <string.h>

#include "atmd.h"

#include "table.h"
#include "itf.h"


#define COMPONENT "ITF"


ITF *lookup_itf(int number)
{
    ITF *walk;

    for (walk = itfs; walk; walk = walk->next)
	if (walk->number == number) break;
    return walk;
}


int itf_up(int number)
{
    ITF *itf;

    diag(COMPONENT,DIAG_DEBUG,"UP %d",number);
    itf = alloc_t(ITF);
    itf->local_ip = 0;
    memset(&itf->local_addr,0,sizeof(struct sockaddr_atmsvc));
    itf->number = number;
    itf->table = itf->arp_srv = NULL;
    Q_INSERT_HEAD(itfs,itf);
    return 0;
}


void itf_down(int number)
{
    diag(COMPONENT,DIAG_DEBUG,"DOWN %d",number);
}
