/* qgen.c - constructor/parser generator for Q.2931-like data structures */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

#include <stdio.h>
#include <string.h>

#include "common.h"
#include "file.h"
#include "qgen.h"


extern int yyparse(void);

extern ITEM *def;
extern int group,item,offset,varlen_items;
extern int constr_size,parser_size;


int debug = 0;


int main(int argc,char **argv)
{
    if (argc == 2 && !strcmp(argv[1],"-d")) debug = 1;
    open_files();
    to_h("/* THIS IS A MACHINE-GENERATED FILE. DO NOT EDIT ! */\n\n");
    to_c("/* THIS IS A MACHINE-GENERATED FILE. DO NOT EDIT ! */\n\n");
    to_c("/* (optional) user includes go here */\n\n");
    if (yyparse()) return 1;
    to_h("#ifndef Q_OUT_H\n#define Q_OUT_H\n\n");
    to_c("\n\n#include <stdlib.h>\n#include <stdio.h>\n");
    to_c("#include <string.h>\n#include <sys/types.h>\n\n");
    to_c("#include \"common.h\"\n#include \"op.h\"\n");
    to_c("#include \"qlib.h\"\n\n");
    to_c("\n\nstatic void q_put(unsigned char *table,int pos,int size,"
      "unsigned long value);\n\n");
    first(def);
    second(def);
    third(def);
    to_h("#endif\n");
    to_c("\n/*\n * Sorry, this is necessary ...\n */\n\n");
    to_c("#include \"qlib.c\"\n");
    close_files();
    fprintf(stderr,"  %d groups, %d fields (%d var-len), construction area is "
      "%d bytes,\n",group,item,varlen_items,(offset+7)/8);
    fprintf(stderr,"  %d words in constructor, %d words in parser.\n",
      constr_size,parser_size);
    return 0;
}
