%{
/* ql.l - Q.2931 data structures description language */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdio.h>
#include <string.h>

#include "common.h"
#include "qgen.h"
#include "y.tab.h"


typedef struct _tree {
    const char *str;
    struct _tree *left,*right;
} TREE;


static TREE *tree = NULL;
static int lineno = 1;


static const char *ident(const char *str)
{
    TREE **walk;
    int diff;
 
    walk = &tree;
    while (*walk) {
        if (!(diff = strcmp(str,(*walk)->str))) return (*walk)->str;
        if (diff < 0) walk = &(*walk)->left;
        else walk = &(*walk)->right;
    }
    *walk = alloc_t(TREE);
    (*walk)->left = (*walk)->right = NULL;
    return (*walk)->str = stralloc(str);
}

%}

%%

case				return TOK_CASE;
def				return TOK_DEF;
default				return TOK_DEFAULT;
length				return TOK_LENGTH;
multi				return TOK_MULTI;
[_a-zA-Z0-9]+			{ yylval.str = ident(yytext);
				  return TOK_ID; }
\n?[\t ]*			lineno += *yytext && *yytext == '\n';
include[\ \t]+\"[^\"\n\t]+\"	|
include[\ \t]+\<[^\<\>\n\t]+\>	{ yylval.str = ident(yytext);
				  return TOK_INCLUDE; }
#[^\n]*\n			lineno++;
.				return *yytext;

%%

void yyerror(char *s)
{
    fprintf(stderr,"line %d: %s near \"%s\"\n",lineno,s,yytext);
    exit(1);
}
