/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   cm.h
*   
* Overview:
*   This describes the management interface to the Connection Manager (CM).
*
* Authors:
*   TLR - Theodore L. Ross
*
* Modification History:
*   Date       Name  Description 
*   17-Oct-94  TLR   Created.
*   19-Jan-94  TLR   Added LAN Emulation map list hook.
*
* Description:
*   This is the interface through which the CM is managed.  It enables
*   instances of the the CM to be initialized at system start-up time (or any
*   other time).
*
*   The CM provides connection management services on a per-adapter basis.
*   Thus if there is more than one physical adapter in a system,
*   there are multiple instantiations of the CM.  The management
*   interface provides calls to create instantiations of the CM module.
*
* Future Extensions:
*   This interface shall be extended with calls that allow management entities
*   to access the internal state of a CM instance.
*
* Call Sequence Requirements:
*
*   Creation of instances of the CM is a two-step process.  First, each
*   instance must be created using the cm_create call.  The instance must
*   then be configured using the cm_config call.  This two-step process
*   is needed because it breaks a circular dependency in the architecture (i.e.
*   other module instances need the CM handle during creation and the handles
*   of those module instances are needed during creation the CM instance).
*
*   The call sequence for each instance will look like the following:
*
*       <os_utilities created>..............OS Utilities are created.
*
*       cm_create...........................Create a CM module instance.  OS
*                                           handle is passed so create routine
*                                           can allocate memory.
*
*       <other module instances created>....Create other module instances using
*                                           the CM handle from the
*                                           cm_create.
*
*       cm_drv_config.......................Called during lower driver creation.
*
*       cm_svc_config.......................Called during SVC module creation.
*
*       cm_map_get..........................Called by the LAN Emulation Client
*                                           (if it exists) to gain access to
*                                           the CM's VC and ATM address lists.
*/

typedef void (*LINK_CALLBACK) (HANDLE link_handle);


/*++
* ==============
* = cm_map_get =
* ==============
*
* Overview:
*   Gets pointers to this CM instance's mapping lists (VC list and ATM address
*   list).  This function is called by the LAN Emulation Client module during
*   module creation.
*
* Arguments:
*   cm_handle             - (IN)  Handle returned by cm_create.
*   link_update_callback  - (IN)  Callback for MAC address link updates.
*   link_remove_callback  - (IN)  Callback for MAC address link removal.
*   callback_context      - (IN)  Context to be passed back with the callbacks.
*   p_vc_list             - (OUT) VC List handle for this cm instance.
*   p_atm_list            - (OUT) ATM Address List handle for this cm instance.
*              
* Returns:
*   None
*
* Preconditions:
*   The cm_handle must be valid.
*
* Postconditions:
*   None
--*/
void cm_map_get(LINK_CALLBACK  link_update_callback,
                LINK_CALLBACK  link_remove_callback,
                HANDLE         callback_context,
                HANDLE        *p_vc_list,
                HANDLE        *p_atm_list);
