/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _FIJI_PWRVIRUS_H_
#define _FIJI_PWRVIRUS_H_

#define mmCP_HYP_MEC1_UCODE_ADDR	0xf81a
#define mmCP_HYP_MEC1_UCODE_DATA	0xf81b
#define mmCP_HYP_MEC2_UCODE_ADDR	0xf81c
#define mmCP_HYP_MEC2_UCODE_DATA	0xf81d

enum PWR_Command
{
   PwrCmdNull = 0,
   PwrCmdWrite,
   PwrCmdEnd,
   PwrCmdMax
};
typedef enum PWR_Command PWR_Command;

struct PWR_Command_Table
{
   PWR_Command        command;
   ULONG              data;
   ULONG              reg;
};
typedef struct PWR_Command_Table PWR_Command_Table;

#define PWR_VIRUS_TABLE_SIZE  10243
static const PWR_Command_Table PwrVirusTable[PWR_VIRUS_TABLE_SIZE] =
{
    { PwrCmdWrite, 0x100100b6, mmPCIE_INDEX                               },
    { PwrCmdWrite, 0x00000000, mmPCIE_DATA                                },
    { PwrCmdWrite, 0x100100b6, mmPCIE_INDEX                               },
    { PwrCmdWrite, 0x0300078c, mmPCIE_DATA                                },
    { PwrCmdWrite, 0x00000000, mmBIF_CLK_CTRL                             },
    { PwrCmdWrite, 0x00000001, mmBIF_CLK_CTRL                             },
    { PwrCmdWrite, 0x00000000, mmBIF_CLK_CTRL                             },
    { PwrCmdWrite, 0x00000003, mmBIF_FB_EN                                },
    { PwrCmdWrite, 0x00000000, mmBIF_FB_EN                                },
    { PwrCmdWrite, 0x00000001, mmBIF_DOORBELL_APER_EN                     },
    { PwrCmdWrite, 0x00000000, mmBIF_DOORBELL_APER_EN                     },
    { PwrCmdWrite, 0x014000c0, mmPCIE_INDEX                               },
    { PwrCmdWrite, 0x00000000, mmPCIE_DATA                                },
    { PwrCmdWrite, 0x014000c0, mmPCIE_INDEX                               },
    { PwrCmdWrite, 0x22000000, mmPCIE_DATA                                },
    { PwrCmdWrite, 0x014000c0, mmPCIE_INDEX                               },
    { PwrCmdWrite, 0x00000000, mmPCIE_DATA                                },
    /*
    { PwrCmdWrite, 0x009f0090, mmMC_VM_FB_LOCATION                        },
    { PwrCmdWrite, 0x00000000, mmMC_CITF_CNTL                             },
    { PwrCmdWrite, 0x00000000, mmMC_VM_FB_LOCATION                        },
    { PwrCmdWrite, 0x009f0090, mmMC_VM_FB_LOCATION                        },
    { PwrCmdWrite, 0x00000000, mmMC_VM_FB_LOCATION                        },
    { PwrCmdWrite, 0x009f0090, mmMC_VM_FB_LOCATION                        },
    { PwrCmdWrite, 0x00000000, mmMC_VM_FB_OFFSET                          },*/
    { PwrCmdWrite, 0x00000000, mmRLC_CSIB_ADDR_LO                         },
    { PwrCmdWrite, 0x00000000, mmRLC_CSIB_ADDR_HI                         },
    { PwrCmdWrite, 0x00000000, mmRLC_CSIB_LENGTH                          },
    /*
    { PwrCmdWrite, 0x00000000, mmMC_VM_MX_L1_TLB_CNTL                     },
    { PwrCmdWrite, 0x00000001, mmMC_VM_SYSTEM_APERTURE_LOW_ADDR           },
    { PwrCmdWrite, 0x00000000, mmMC_VM_SYSTEM_APERTURE_HIGH_ADDR          },
    { PwrCmdWrite, 0x00000000, mmMC_VM_FB_LOCATION                        },
    { PwrCmdWrite, 0x009f0090, mmMC_VM_FB_LOCATION                        },*/
    { PwrCmdWrite, 0x00000000, mmVM_CONTEXT0_CNTL                         },
    { PwrCmdWrite, 0x00000000, mmVM_CONTEXT1_CNTL                         },
    /*
    { PwrCmdWrite, 0x00000000, mmMC_VM_AGP_BASE                           },
    { PwrCmdWrite, 0x00000002, mmMC_VM_AGP_BOT                            },
    { PwrCmdWrite, 0x00000000, mmMC_VM_AGP_TOP                            },*/
    { PwrCmdWrite, 0x04000000, mmATC_VM_APERTURE0_LOW_ADDR                },
    { PwrCmdWrite, 0x0400ff20, mmATC_VM_APERTURE0_HIGH_ADDR               },
    { PwrCmdWrite, 0x00000002, mmATC_VM_APERTURE0_CNTL                    },
    { PwrCmdWrite, 0x0000ffff, mmATC_VM_APERTURE0_CNTL2                   },
    { PwrCmdWrite, 0x00000001, mmATC_VM_APERTURE1_LOW_ADDR                },
    { PwrCmdWrite, 0x00000000, mmATC_VM_APERTURE1_HIGH_ADDR               },
    { PwrCmdWrite, 0x00000000, mmATC_VM_APERTURE1_CNTL                    },
    { PwrCmdWrite, 0x00000000, mmATC_VM_APERTURE1_CNTL2                   },
    //{ PwrCmdWrite, 0x00000000, mmMC_ARB_RAMCFG                            },
    { PwrCmdWrite, 0x12011003, mmGB_ADDR_CONFIG                           },
    { PwrCmdWrite, 0x00800010, mmGB_TILE_MODE0                            },
    { PwrCmdWrite, 0x00800810, mmGB_TILE_MODE1                            },
    { PwrCmdWrite, 0x00801010, mmGB_TILE_MODE2                            },
    { PwrCmdWrite, 0x00801810, mmGB_TILE_MODE3                            },
    { PwrCmdWrite, 0x00802810, mmGB_TILE_MODE4                            },
    { PwrCmdWrite, 0x00802808, mmGB_TILE_MODE5                            },
    { PwrCmdWrite, 0x00802814, mmGB_TILE_MODE6                            },
    { PwrCmdWrite, 0x00000000, mmGB_TILE_MODE7                            },
    { PwrCmdWrite, 0x00000004, mmGB_TILE_MODE8                            },
    { PwrCmdWrite, 0x02000008, mmGB_TILE_MODE9                            },
    { PwrCmdWrite, 0x02000010, mmGB_TILE_MODE10                           },
    { PwrCmdWrite, 0x06000014, mmGB_TILE_MODE11                           },
    { PwrCmdWrite, 0x00000000, mmGB_TILE_MODE12                           },
    { PwrCmdWrite, 0x02400008, mmGB_TILE_MODE13                           },
    { PwrCmdWrite, 0x02400010, mmGB_TILE_MODE14                           },
    { PwrCmdWrite, 0x02400030, mmGB_TILE_MODE15                           },
    { PwrCmdWrite, 0x06400014, mmGB_TILE_MODE16                           },
    { PwrCmdWrite, 0x00000000, mmGB_TILE_MODE17                           },
    { PwrCmdWrite, 0x0040000c, mmGB_TILE_MODE18                           },
    { PwrCmdWrite, 0x0100000c, mmGB_TILE_MODE19                           },
    { PwrCmdWrite, 0x0100001c, mmGB_TILE_MODE20                           },
    { PwrCmdWrite, 0x01000034, mmGB_TILE_MODE21                           },
    { PwrCmdWrite, 0x01000024, mmGB_TILE_MODE22                           },
    { PwrCmdWrite, 0x00000000, mmGB_TILE_MODE23                           },
    { PwrCmdWrite, 0x0040001c, mmGB_TILE_MODE24                           },
    { PwrCmdWrite, 0x01000020, mmGB_TILE_MODE25                           },
    { PwrCmdWrite, 0x01000038, mmGB_TILE_MODE26                           },
    { PwrCmdWrite, 0x02c00008, mmGB_TILE_MODE27                           },
    { PwrCmdWrite, 0x02c00010, mmGB_TILE_MODE28                           },
    { PwrCmdWrite, 0x06c00014, mmGB_TILE_MODE29                           },
    { PwrCmdWrite, 0x00000000, mmGB_TILE_MODE30                           },
    { PwrCmdWrite, 0x00000000, mmGB_TILE_MODE31                           },
    { PwrCmdWrite, 0x000000a8, mmGB_MACROTILE_MODE0                       },
    { PwrCmdWrite, 0x000000a4, mmGB_MACROTILE_MODE1                       },
    { PwrCmdWrite, 0x00000090, mmGB_MACROTILE_MODE2                       },
    { PwrCmdWrite, 0x00000090, mmGB_MACROTILE_MODE3                       },
    { PwrCmdWrite, 0x00000090, mmGB_MACROTILE_MODE4                       },
    { PwrCmdWrite, 0x00000090, mmGB_MACROTILE_MODE5                       },
    { PwrCmdWrite, 0x00000090, mmGB_MACROTILE_MODE6                       },
    { PwrCmdWrite, 0x00000000, mmGB_MACROTILE_MODE7                       },
    { PwrCmdWrite, 0x000000ee, mmGB_MACROTILE_MODE8                       },
    { PwrCmdWrite, 0x000000ea, mmGB_MACROTILE_MODE9                       },
    { PwrCmdWrite, 0x000000e9, mmGB_MACROTILE_MODE10                      },
    { PwrCmdWrite, 0x000000e5, mmGB_MACROTILE_MODE11                      },
    { PwrCmdWrite, 0x000000e4, mmGB_MACROTILE_MODE12                      },
    { PwrCmdWrite, 0x000000e0, mmGB_MACROTILE_MODE13                      },
    { PwrCmdWrite, 0x00000090, mmGB_MACROTILE_MODE14                      },
    { PwrCmdWrite, 0x00000000, mmGB_MACROTILE_MODE15                      },
    { PwrCmdWrite, 0x00900000, mmHDP_NONSURFACE_BASE                      },
    { PwrCmdWrite, 0x00008000, mmHDP_NONSURFACE_INFO                      },
    { PwrCmdWrite, 0x3fffffff, mmHDP_NONSURFACE_SIZE                      },
    { PwrCmdWrite, 0x00000003, mmBIF_FB_EN                                },
    //{ PwrCmdWrite, 0x00000000, mmMC_VM_FB_OFFSET                          },
    { PwrCmdWrite, 0x00000000, mmSRBM_CNTL                                },
    { PwrCmdWrite, 0x00020000, mmSRBM_CNTL                                },
    { PwrCmdWrite, 0x80000000, mmATC_VMID0_PASID_MAPPING                  },
    { PwrCmdWrite, 0x00000000, mmATC_VMID_PASID_MAPPING_UPDATE_STATUS     },
    { PwrCmdWrite, 0x00000000, mmRLC_CNTL                                 },
    { PwrCmdWrite, 0x00000000, mmRLC_CNTL                                 },
    { PwrCmdWrite, 0x00000000, mmRLC_CNTL                                 },
    { PwrCmdWrite, 0xe0000000, mmGRBM_GFX_INDEX                           },
    { PwrCmdWrite, 0x00000000, mmCGTS_TCC_DISABLE                         },
    { PwrCmdWrite, 0x00000000, mmTCP_ADDR_CONFIG                          },
    { PwrCmdWrite, 0x000000ff, mmTCP_ADDR_CONFIG                          },
    { PwrCmdWrite, 0x76543210, mmTCP_CHAN_STEER_LO                        },
    { PwrCmdWrite, 0xfedcba98, mmTCP_CHAN_STEER_HI                        },
    { PwrCmdWrite, 0x00000000, mmDB_DEBUG2                                },
    { PwrCmdWrite, 0x00000000, mmDB_DEBUG                                 },
    { PwrCmdWrite, 0x00002b16, mmCP_QUEUE_THRESHOLDS                      },
    { PwrCmdWrite, 0x00006030, mmCP_MEQ_THRESHOLDS                        },
    { PwrCmdWrite, 0x01000104, mmSPI_CONFIG_CNTL_1                        },
    { PwrCmdWrite, 0x98184020, mmPA_SC_FIFO_SIZE                          },
    { PwrCmdWrite, 0x00000001, mmVGT_NUM_INSTANCES                        },
    { PwrCmdWrite, 0x00000000, mmCP_PERFMON_CNTL                          },
    { PwrCmdWrite, 0x01180000, mmSQ_CONFIG                                },
    { PwrCmdWrite, 0x00000000, mmVGT_CACHE_INVALIDATION                   },
    { PwrCmdWrite, 0x00000000, mmSQ_THREAD_TRACE_BASE                     },
    { PwrCmdWrite, 0x0000df80, mmSQ_THREAD_TRACE_MASK                     },
    { PwrCmdWrite, 0x02249249, mmSQ_THREAD_TRACE_MODE                     },
    { PwrCmdWrite, 0x00000000, mmPA_SC_LINE_STIPPLE_STATE                 },
    { PwrCmdWrite, 0x00000000, mmCB_PERFCOUNTER0_SELECT1                  },
    { PwrCmdWrite, 0x06000100, mmCGTT_VGT_CLK_CTRL                        },
    { PwrCmdWrite, 0x00000007, mmPA_CL_ENHANCE                            },
    { PwrCmdWrite, 0x00000001, mmPA_SC_ENHANCE                            },
    { PwrCmdWrite, 0x00ffffff, mmPA_SC_FORCE_EOV_MAX_CNTS                 },
    { PwrCmdWrite, 0x00000000, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000010, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000020, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000030, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000040, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000050, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000060, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000070, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000080, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000090, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x000000a0, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x000000b0, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x000000c0, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x000000d0, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x000000e0, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x000000f0, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000000, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmRLC_PG_CNTL                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS2                             },
    { PwrCmdWrite, 0x15000000, mmCP_ME_CNTL                               },
    { PwrCmdWrite, 0x50000000, mmCP_MEC_CNTL                              },
    { PwrCmdWrite, 0x00000000, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x0000000e, mmSH_MEM_APE1_BASE                         },
    { PwrCmdWrite, 0x0000020d, mmSH_MEM_APE1_LIMIT                        },
    { PwrCmdWrite, 0x00000000, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000320, mmSH_MEM_CONFIG                            },
    { PwrCmdWrite, 0x00000000, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_RB_VMID                               },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmRLC_CNTL                                 },
    { PwrCmdWrite, 0x00000000, mmRLC_CNTL                                 },
    { PwrCmdWrite, 0x00000000, mmRLC_SRM_CNTL                             },
    { PwrCmdWrite, 0x00000002, mmRLC_SRM_CNTL                             },
    { PwrCmdWrite, 0x00000000, mmCP_ME_CNTL                               },
    { PwrCmdWrite, 0x15000000, mmCP_ME_CNTL                               },
    { PwrCmdWrite, 0x00000000, mmCP_MEC_CNTL                              },
    { PwrCmdWrite, 0x50000000, mmCP_MEC_CNTL                              },
    { PwrCmdWrite, 0x80000004, mmCP_DFY_CNTL                              },
    { PwrCmdWrite, 0x0840800a, mmCP_RB0_CNTL                              },
    { PwrCmdWrite, 0xf30fff0f, mmTCC_CTRL                                 },
    { PwrCmdWrite, 0x00000002, mmTCC_EXE_DISABLE                          },
    { PwrCmdWrite, 0x000000ff, mmTCP_ADDR_CONFIG                          },
    { PwrCmdWrite, 0x540ff000, mmCP_CPC_IC_BASE_LO                        },
    { PwrCmdWrite, 0x000000b4, mmCP_CPC_IC_BASE_HI                        },
    { PwrCmdWrite, 0x00010000, mmCP_HYP_MEC1_UCODE_ADDR                   },
    { PwrCmdWrite, 0x00041b75, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000710e8, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000910dd, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000a1081, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000b016f, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000c0e3c, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000d10ec, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000e0188, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00101b5d, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00150a6c, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00170c5e, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x001d0c8c, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x001e0cfe, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00221408, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00370d7b, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00390dcb, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x003c142f, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x003f0b27, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00400e63, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00500f62, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00460fa7, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00490fa7, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x005811d4, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00680ad6, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00760b00, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00780b0c, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00790af7, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x007d1aba, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x007e1abe, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00591260, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x005a12fb, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00861ac7, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x008c1b01, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x008d1b34, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a014b9, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a1152e, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a216fb, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a41890, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a31906, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a50b14, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00621387, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x005c0b27, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00160a75, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC1_UCODE_DATA                   },
    { PwrCmdWrite, 0x00010000, mmCP_HYP_MEC2_UCODE_ADDR                   },
    { PwrCmdWrite, 0x00041b75, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000710e8, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000910dd, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000a1081, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000b016f, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000c0e3c, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000d10ec, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000e0188, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00101b5d, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00150a6c, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00170c5e, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x001d0c8c, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x001e0cfe, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00221408, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00370d7b, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00390dcb, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x003c142f, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x003f0b27, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00400e63, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00500f62, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00460fa7, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00490fa7, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x005811d4, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00680ad6, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00760b00, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00780b0c, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00790af7, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x007d1aba, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x007e1abe, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00591260, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x005a12fb, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00861ac7, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x008c1b01, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x008d1b34, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a014b9, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a1152e, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a216fb, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a41890, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a31906, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00a50b14, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00621387, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x005c0b27, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x00160a75, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x000f016a, mmCP_HYP_MEC2_UCODE_DATA                   },
    { PwrCmdWrite, 0x80000004, mmCP_DFY_CNTL                              },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_ADDR_HI                           },
    { PwrCmdWrite, 0x540fe800, mmCP_DFY_ADDR_LO                           },
    { PwrCmdWrite, 0x7e000200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e020201, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e040204, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e060205, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a080500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a0a0303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xbf810000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54106f00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000400b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00004000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00804fac, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000004, mmCP_DFY_CNTL                              },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_ADDR_HI                           },
    { PwrCmdWrite, 0x540fef00, mmCP_DFY_ADDR_LO                           },
    { PwrCmdWrite, 0xc0031502, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00001e00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000004, mmCP_DFY_CNTL                              },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_ADDR_HI                           },
    { PwrCmdWrite, 0x540ff000, mmCP_DFY_ADDR_LO                           },
    { PwrCmdWrite, 0xc424000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000145, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc810000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdcc10000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdd010000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdd410000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdd810000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4080061, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24ccffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3cd08000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9500fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1cd0ffcf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d018001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4140004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x050c0019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x84c00000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000067, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000006a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000006d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000084, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000008f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000099, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800000a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800000af, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400053, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4080007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x388c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08880002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98800003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000002d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000043, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00050, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000055, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28080001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d808001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd88130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc180000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc100000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc0c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc080000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc0700, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113255, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d10ffdf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10cc0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d10c017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d0d000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd0130b7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14cc0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9c00036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000005d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00c4000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14d00011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9500fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc030000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c01b10, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00e0080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000013b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00e0800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000013b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400053, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000043, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00050, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000055, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x280c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00052, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28180039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400053, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000043, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00050, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000055, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x280c0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00052, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28180039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400053, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000043, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00050, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000055, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x280c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00052, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28180039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc030000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000069, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28080001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca88004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc00006f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000013b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000043, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000055, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28180080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00c4000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d10c017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd0130b7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000013b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97400001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc810000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd4c0380, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdcc0388, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55dc0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdcc038c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce0c0390, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce0c0394, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce4c0398, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56640020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce4c039c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce8c03a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56a80020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce8c03a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcecc03a8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcecc03ac, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf0c03b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57300020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf0c03b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf4c03b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57740020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf4c03bc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf8c03c0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57b80020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf8c03c4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfcc03c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57fc0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfcc03cc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05dc002f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc12009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d200a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc012009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25e01c00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25e40300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25e800c0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25ec003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e25c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de5c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xddc10000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02ee000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31100006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9500007b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc1c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc1c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4df0388, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d7038c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d5dc01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4e30390, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d70394, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d62001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4e70398, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d7039c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d66401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4eb03a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d703a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d6a801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4ef03a8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d703ac, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d6ec01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4f303b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d703b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d73001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4f703b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d703bc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d77401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4fb03c0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d703c4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d7b801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4ff03c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d703cc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d7fc01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc080000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4d70380, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4080001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1c88001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc0e0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc01e3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3cd00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0085, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc006a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc01e3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3cd00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900fffa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc180000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc100000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc0c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc080000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4080001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1c88001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc180000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc100000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc0c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc080000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400051, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04180018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aac0027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce813265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80002f1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04080002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08880001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080228, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000367, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9880fff3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04080010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08880001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80c0309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80c0319, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9880fffc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00e0100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d0003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d4001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x155c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05e80180, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x202c003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000bfc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc410001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000031, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900091a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05280196, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d4fe04, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29540008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800001b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000032b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000350, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000352, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000035f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000701, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000047c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000019f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc419325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d98001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4140004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000043, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00050, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0044, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27fc0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00c4000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000055, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd88130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9400036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15540008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd40005b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd40005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd40005d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840006d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11540015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19a4003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1998003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1af0007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1264001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15dc000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d65400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a38003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd5c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7df1c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800045, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411326a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc415326b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc419326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425326e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293279, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd000056, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800058, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00059, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x259c8000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce40005a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29988000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2510000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd000073, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411326f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17300019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25140fff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001b6d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4153279, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd00005f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000075, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26f00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15100010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d190004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd000035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1af07fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001427, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdf430000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4412e01, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0434001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdf430000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdf030000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4412e40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c031, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43dc031, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04343000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf413267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51100020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd1c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0160, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc810001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b4c0057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b700213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b740199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f4f400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55180020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2198003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x248dfffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc12e00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00142b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1af4007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33740003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26d80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ae8003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9680000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26680001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253348, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413348, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253348, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x958000d8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000315, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04303000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26680001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800041, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b342010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1714000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25540800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b30c012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x459801b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d77400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x199c01e2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5e4002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e5c0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e540002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc80c0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54d00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55580020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000282, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc80c0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54d00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8180011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000282, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55580020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000282, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc80c0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8100011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55580020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1334e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01334f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd413350, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813351, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd881334d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193273, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3275, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3271, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4153274, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50cc0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cdcc011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05900008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd00006a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc0006b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3272, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d594002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54d00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc12e23, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd012e24, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc12e25, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15540002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc81c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b340057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b280213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980198, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2b000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55e40020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd40000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd40000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x20cc003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc13249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113274, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdd430000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc01e0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29dc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2d540002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x078c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07d40000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00120d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001239, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001232, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04f80000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x057c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd5c005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840007c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400069, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c018a6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4412e22, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800007c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c018a2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd4c005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9680fffc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800002e3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9680fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800002e3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000069, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013273, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013275, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9540188f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc013cfff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc13249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9680000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x38d00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04cc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdcc30000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c01882, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000304, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840002f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc81c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x49980198, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55e40020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x459801a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04302000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000329, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc812e00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04302000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16ec001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1998003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00031, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce00000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a18003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd88130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d43c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4093249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1888003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000671, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc419324c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x259c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1598001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14d80011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24dc00ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31e00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31dc0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580fff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9c00036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95801827, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840002f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14dc0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800006d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51dc0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32200002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a0000ad, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xde030000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04080000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27fc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1af4003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9740004d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4080060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca88005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24880001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f4b4009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97400046, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313274, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d33400c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97400009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28240100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a4004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1eecffdd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013273, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013275, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800003c3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429326f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aa80030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28240001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a8004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3272, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10cc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19e80042, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc0006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e8e800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de9c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3271, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50cc0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ce8c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd30011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11e80007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce80001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd300001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b30003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240059, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1660001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e320009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0328000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e72400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0430000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02ac000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d310002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa87600, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280222, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4280058, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x22ec003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013273, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce813275, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800007b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8380018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57b00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04343108, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13740008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2374007e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32a80003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18ec0057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e40213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc0199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cecc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ce4c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800003e7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xde030000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xde030000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980104, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x49980104, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc81c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55e00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800003f2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000448, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf813279, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf41326e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x254c0700, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10cc0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a641fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0726, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a640200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1237b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2264003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8813260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4280034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001427, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xde430000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce40000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c01755, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9680000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce80000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xde830000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce80000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0174c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00142b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4393265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bb80040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf813265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100044, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19180024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8100072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x551c003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000043d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00c8000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840006c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28200000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000043f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00c4000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x282000f0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113255, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd88130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000053, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x195c00e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2555fff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0360001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32200002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc5e124dc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0aa80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef6c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e624001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80fff9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02ee000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2555fff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29540008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc81c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55e00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3255, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353259, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980158, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x49980158, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980170, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16200010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d43c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x195400e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1154000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18dc00e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05e80488, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d0006c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18f807f0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e40077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18ec0199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6e400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000048e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000494, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800004de, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000685, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000686, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800006ac, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ccc001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1264000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d79400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e7a400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52a8001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d69401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x202c007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aec0028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d325c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800004cc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc419324e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26e8003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aec003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12f4000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d324d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d75401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d290004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f8f4001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f52800f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50e00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800004d1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d0dc002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x6665fc00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5e401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da1c011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a644000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f534002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x6665fc00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e76401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800004d7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aec003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3257, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213259, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12f4000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d75401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52200002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da1c011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a644000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x202c003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x259c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05e804e3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800004e7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800004f0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000505, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc435325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x277401ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf41325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000671, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640fff4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17e00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd84131db, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b301ff8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2330003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26edf000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8413260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05a80507, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000050c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000528, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000057d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800005c2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800005f3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000671, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bd400e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd40005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c004d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d150005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00063b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2511fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801326f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000624, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1be00fe4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000066, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400068, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000671, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bd400e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd40005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c004d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d150005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400067, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00063b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2511fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801326f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000624, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bd400e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ed6c005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113271, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4153270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193272, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3273, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51100020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d51401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113274, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213275, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253276, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400061, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2730000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7db1800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00062, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd000063, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000064, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400065, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce813260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc820001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b700057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b680213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b740199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x46ec0188, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56240020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17e00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26e01000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9c131fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25140001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x191807e4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x192007ec, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc1334a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x69dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de20014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x561c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013344, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc13345, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425334d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc419334e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d334f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213350, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253351, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b680057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b700213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b740199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x46ec01b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce813260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800068, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2010007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1910003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9500fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd00001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc410000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd00001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc410000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2010003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25140001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x191807e4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9540000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2511fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc1334a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013344, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013345, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180050, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0052, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280042, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813273, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc13275, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce813260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000068, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400067, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07d40000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00120d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00124f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001232, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x057c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b680057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b700213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b740199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc820001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x46ec0190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56240020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4153249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2154003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bd800e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd9c005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd80005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420004d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1e000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd413249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01326f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28340001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f598004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1be800e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce80005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801327a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800005f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000075, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424004c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41326e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28240100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a4004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc435325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x277401ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf41325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xda000068, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113277, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25140001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9540002d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc1334a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425334d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc419334e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d334f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213350, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253351, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b680057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b700213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b740199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x46ec01b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc1334a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1be000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0360001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc63124dc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0aa80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef6c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e724001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80fff9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02ee000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fc14001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x194c1c03, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc0003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c002d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000697, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x194c00e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc0005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c004c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27301fff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce00005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cf0c00d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0007e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b301ff8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2330003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25100007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31100005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900008e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000075e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x202c007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a9feff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1374000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1774000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d30b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce813265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00ac006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00e0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28880700, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0006de, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14cc0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30d4000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10cc0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41530b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19980028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800006c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15600008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8380023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11a00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fa38011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d1a0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x282c2002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e280008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd3800025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x202400d0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca48001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28240006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d8003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81a2a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x194c00e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc0005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c004c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27301fff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce00005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cf0c00d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000712, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x194c1c03, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc0003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c002d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05e80714, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000071c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000720, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000747, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000071d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800007c4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000732, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000745, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000744, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000072e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0007e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a64008c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b301fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2330003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000075e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c0fff1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0007e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000723, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41f02f1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000743, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8813247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd88130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c0ffde, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000072e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0007e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15600008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd84131db, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b301ff8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2330003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8413260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc8000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x195800e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd80005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418004c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81326e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc0005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dd7fff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc13265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51e00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1a001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x46200200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04283247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1af80057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1af40213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f7b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6f400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2000025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc6990000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x329c325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x329c3269, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x329c3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc01defff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d8009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000078a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25980000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fff2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03e7ff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f3f0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1f30001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03e4000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013255, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00120d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001219, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001232, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd88130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d30b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bf0003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000b80, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x203c003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300700, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf0130b7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x46200008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2000025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4080007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x259c0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31dc0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18ec0057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e40213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc0199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cecc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ce4c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000448, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31980002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19580066, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15600008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0120001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11980003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da18001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d24db, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd9c005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fff8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580137b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00ee000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840004f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113269, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19080070, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x190c00e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2510003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2518000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05a80809, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000080e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000080f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000898, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000946, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800009e1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04a80811, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000815, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000834, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000085e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000085e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04341001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3045, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1c091, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31300021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd84002f1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293059, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56a8001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2b000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000241, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000084a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43130b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02f0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec130b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4252087, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5668001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a80005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80130b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000084a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04341001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431ecaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02e0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec130b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80130b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31300021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd84002f1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293059, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56a8001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2b000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00021d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdd410000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd84802e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001a41, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43b02f1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd88130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec80278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56f00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001608, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8813247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80802e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000085e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31100011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x950001fa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02e0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aec0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc01c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11a40006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de6000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10e40008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e2e000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d10ffdf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2110003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013255, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d10ff9e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0245301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801325f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0121fff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29108eff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e524009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0127ff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e524009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0131fff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e524009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801326e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013279, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000866, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000866, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0100010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd2400c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0180003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd1c002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000866, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04a8089a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000089e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800008fa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000945, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000945, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31300022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04183000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51100020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d91801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x459801e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2738000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b342010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x172c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ec0800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b30c012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef7400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8300011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8340011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9740002f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13b80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc79d3300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc7a13301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8393300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0260001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce793301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x964012a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c028009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9740001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27580001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800008d2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce40001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x242c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06ec0400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27580001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02620c0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce81c080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01c082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57240020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0260400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6e400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c084, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae8001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2f0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800008d2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdf93300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce393301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04182000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000903, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31240022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4af0280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ec30011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32f80000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x67180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0bfc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd981325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000915, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9c1325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0fff6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f818001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001606, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d838001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3259, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16240014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a2801f0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2620ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e2a000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5e400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2264003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013259, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00075e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4af0228, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x66d80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1330000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13f40014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf80001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf80001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07fc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33e80010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9680ffec, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04a80948, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000094c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000099b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800009e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800009e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04183000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51100020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d91801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x459801e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2738000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b342010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x172c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ec0800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b30c012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef7400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8300011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8340011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9740002c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13b80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc79d3300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc7a13301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8393300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0260001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce793301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x964011fe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c028009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9740001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27580001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000978, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce40001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x242c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06ec0400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27580001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0260010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01c080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57240020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce81c082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0260800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6e400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c084, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae8001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2f0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000978, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdf93300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce393301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04182000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dda801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e838011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd84802e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001802, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x469c0390, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04183000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b342010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x172c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ec0800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b30c012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef7400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4280011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04182000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0014df, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31280014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce8802ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800062, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31280034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04a809e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800009ec, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a45, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a59, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a59, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51100020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d91801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4a70250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53300020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e72401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b342010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x172c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ec0800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b30c012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef7400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x66740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97400041, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04383000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4393267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b38007e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33b40003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x4598001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9740002f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf4002eb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf4002ec, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf4002ed, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf4002ee, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04382000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd84802e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001715, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04382000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0aec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffbc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04341001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431ecaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a55, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43130b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x233c0032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc130b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf0130b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49302ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8413247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5198001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193269, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2598000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80002f1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800004f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53b8001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7db9801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000a5e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c01106, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e01, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e02, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e03, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c010fd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50640020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ce4c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c00072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc80c0072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x58e801fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce80001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18dc01e2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5e4002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e5c0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e540002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8180011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8100011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8100011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9540000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8180011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x44cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55900020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4140011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x44cc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8100011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd812e01, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd012e02, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd412e03, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2264003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc410001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4140028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1e64001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14d00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ab1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a0010ac, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd880003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c0003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800010de, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc010ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d403f7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d0cc009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41b0367, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d958004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d85800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc1e0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d001fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05280adc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000af1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000adf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ae7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000ace, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd8d2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d803f7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc010ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d0cc009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11940014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29544001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29544003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000af4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd44d2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd44dc000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d0003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000ace, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd8d2c00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000b0a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd44d2c00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28148004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d800ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4593240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0105e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2198003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x199c0034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313255, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef3400c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14e80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a8000af, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c01c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000d61, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c01043, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18a01fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3620005c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2464003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc6290ce7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16ac001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ac003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ee6c00d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2620000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00fff8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000367, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640102e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x199c0037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19a00035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0005d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2330003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16f8001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9780000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc035f0ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e764009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19b401f8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13740008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e76400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1000072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8100072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x199c0034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ae4003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000b7c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aec003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19a4003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12ec001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1374000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02e4000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1774000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc01e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13fc0018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dbd800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d98ff15, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x592c00fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd80000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12e00016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da1800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x592c007e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12e00015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da1800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11a0000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1264001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1620000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e32000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12e4001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5924007e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19a4003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013257, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd413258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00fdb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9780f5ca, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00120d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001219, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001232, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001b6d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d324e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431324d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc435324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07740003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x269c003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5e4004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f67000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f674002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53740002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef6c011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ab42010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ab8c006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16a8000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a80800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b740000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f7b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf40001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000bec, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000b47, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b34060b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ec00ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03a8004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef6c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f3b000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc410001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc415325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18580037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x262001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d54001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a80004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14f00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd280200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd680208, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcda80210, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b400014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a80004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc6930200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc6970208, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc69b0210, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd900003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd940003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9400040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800010de, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14fc0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24f800ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33b80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd88130b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d83c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4093249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1888003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000671, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc419324c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x259c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1598001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14d80011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24e000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x321c0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580ffee, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c30, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9480000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800f29, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800f23, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9c00036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800f1a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c01c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000d61, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9600f502, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c0f500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000f05, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1f30001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16e4001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640f4f4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc434000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33740002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40f4f1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aec003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12ec001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1374000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02e4000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1774000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12780001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bb80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00ac005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00e0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc8000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28884900, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ff3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17fc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400ee1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c40a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c40c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c40d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d0007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15580010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x255400ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01c411, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81c40f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41c40e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c410, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e80033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18ec0034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c414, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c415, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81c413, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41c412, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18dc0032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c030011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c038011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431c417, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc435c416, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439c419, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43dc418, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf413261, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013262, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13263, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf813264, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18dc0030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17fc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d77000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000cd6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51b80020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53300020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f97801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f3b000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000cd6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ca7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18dc0031, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc435c40b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9740fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4280032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012c2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb81ff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f8cc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13f4000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bf0060b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc0077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ff3c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000cf4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc0677, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13fc0017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb81fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc032800b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb7800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ff3c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ffbc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d42011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17fc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d001e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd4c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800e6c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50580020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d59401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x596001fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ce0c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x505c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50600020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc0001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8240010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5e800c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x122c0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0aec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000d1f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8240010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x566c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413261, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13262, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b740008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x566c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce413261, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec13262, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012c2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb81fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f8cc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13f4000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bf0060b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc0077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ff3c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000d57, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc0677, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13fc0017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb81fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0328009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb7800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ff3c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ffbc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04143000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd413267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52640020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e51001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4153267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d2d0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19640057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19580213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19600199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da6400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1000025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04142000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd413267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4153267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d001e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d40030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d80034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05280d83, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c424001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000d8a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000d95, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000db1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000d95, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000dbc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11540010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e010001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00187c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d75400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4610000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580f3d8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439c040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x526c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e80058, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e2ec01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc82c0072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5ae0073a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ea2800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580f3c6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc3a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0bb80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80fffb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980fff5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02a0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16200002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01c405, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd441c406, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580f3b1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439c409, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11540010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29540002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4610000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580f3a5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439c040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00da7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50500020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c00072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8280072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5aac007e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12d80017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56a00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2620ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da1800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e82400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e58c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19d4003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28182002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00104f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc011000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11a00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c908009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d614011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca4800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d1a0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cb0800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e280008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x20880188, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cb4800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x20240090, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca48001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28240004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c018001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf80003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd901a2a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1624001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd841325f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27fc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c00038, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429325f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ac0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ac0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13f4000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b301ff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2330003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9680000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27fc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c00038, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0001a2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc80003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24b00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1330000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18ac0024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b304000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18a800e5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da9800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1910003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51100020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2220003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e2a000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27fc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c00038, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18dc003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c01c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000d61, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d40030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d001e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18fc0034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24e8000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80e71, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000edd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000e91, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000e91, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ea1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000eaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000e7c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000e7f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000e7f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000e87, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000e8f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51dc0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9e001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ee6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a200008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213262, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253261, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ee6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a200008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213264, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253263, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ee6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc820001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ee6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e82005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51e00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da1801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1800072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8180072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x59a001fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ea2800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce80001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd180001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8200011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ee6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15980002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81c400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421c401, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400041, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425c401, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52640020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ee6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac2580, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac260c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac0800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac0828, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac2440, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac2390, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac0093, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac31dc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac31e6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ede, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39ac7c06, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db07c00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ebc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39acc337, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db0c330, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ebc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39acc335, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db0c336, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ebc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39ac9002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db09001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ebc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39ac9012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db09011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ebc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39acec70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db0ec6f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ebc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc5a10000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc5a50000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52640020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05280eea, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ef1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000efe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f11, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f2e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000efe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f1f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce190000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce190000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0f26f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439c040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e80058, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7daec01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc82c0072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5af8073a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eba800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56240020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0f25c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02a0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15980002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81c405, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01c406, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56240020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c406, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0f24e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439c409, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40f247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce190000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce190000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0f240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439c040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac2580, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac260c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac0800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac0828, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac2440, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac2390, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac0093, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac31dc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31ac31e6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ef2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39ac7c06, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db07c00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39acc337, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db0c330, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39acc335, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db0c336, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39acec70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db0ec6f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39ac9002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db09002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39ac9012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3db09012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ef1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c43c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc434000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b740008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b780001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c1325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf80001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c034001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c038001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e0007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32240003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32240000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01c080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41c081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f88, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51640020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e52401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2400072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8280072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce81c080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56ac0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26f0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01c081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1af000fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1334000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24e02000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f63400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e00074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32240003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32240000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81c082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc1c083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000f9d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51e40020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5a401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2400072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8280072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce81c082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56ac0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26f0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01c083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1af000fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13380016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e00039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fa3800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb7800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e0007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1220001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fa3800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e00074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fa3800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf81c078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc1c084, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18dc003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c01c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000d61, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d001e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31140005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31140006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00104f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05280fb7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28140002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000fbe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000fbe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000fc2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000fbe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000fd1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ff2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ff2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1a2a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e80039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52a8003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50580020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d59401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d69401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140004b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1a2a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d958004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1a2a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d150005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9500000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x159c0011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x259800ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31a00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31a40001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e25800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0fff5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580fff4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000fef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411326f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d100010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01326f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc011000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33b40003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0340008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000ffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11a00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c908009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d614011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca4800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d1a0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cb0800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x282c2002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x208801a8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e280008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cb4800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x20240030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca48001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28340000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x507c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d7d401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x557c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28342002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000102f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c018001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1cccfe08, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1a2a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00b33, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da2400f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da28002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1ac002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0aec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d2ac002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3ef40010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40f11d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf81325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xde410000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdcc10000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdd010000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdd410000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdd810000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xddc10000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xde010000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c024001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8100086, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5510003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001075, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4140025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15800f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15c002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d520002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cde0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e20001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001071, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9c00036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00b01, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc200000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc1c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc180000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc100000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc0c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc240000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc0c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc240000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc40003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4080029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc80003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18a800e5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da9800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18a400e5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12500009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x248c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x200c006d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x200c0228, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc410002b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18881fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d4072c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc00d1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd4c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3094000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x38d80000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x311c0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30940007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1620001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800010c4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00041, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25140001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418002c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x259c007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19a00030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc0001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800010cb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x199c0fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc0001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800010cb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000aac, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc434002e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2020002c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17780001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07a810d8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000bfc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000104c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc400040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x200c007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28240007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xde430000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc80003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24b00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1330000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18a800e5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da9800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d3249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b304000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x192400fd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50580020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d59401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06681110, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18ac0024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19180070, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19100078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18f40058, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5978073a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f7b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001117, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001118, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001122, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000112d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001130, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001133, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000117b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24ec0f00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32ec0600, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000117b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24ec0f00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32ec0600, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000117b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc81c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55e00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001122, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc81c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55e00020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001122, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00116b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02a0200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e8e8009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x22a8003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x22a80074, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2774001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13740014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eb6800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25ecffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55700020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15f40010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13740002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x275c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c018001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15dc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39e00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dc1c01e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05e40008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00116e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dc2001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05e40008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e62000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da58001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00116e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001165, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dc2001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1a0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e0d000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95000007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e02401e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06640008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05d80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00116e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dc2401e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da58001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00116e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05e00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da2000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9600ffe6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00116e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00116b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce00001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce81c078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1c080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41c082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01c083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x22640435, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c084, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0528117e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x312c0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001185, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001182, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001182, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03a0400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1198001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d81c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc130b7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf8130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0049, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19a000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de2c00c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26200010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc415326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc420007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce40003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800011a3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d654001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c020001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4140025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800011b6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253279, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc415326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2730003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3b380006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3f38000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800011b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800011b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0430000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb10004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e57000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e578002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d67c002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0be40001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d3a4002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x202c002c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26200010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e640010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce81325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc434002e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17780001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07a811cf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00feb8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x954009a7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000bfc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00120d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1c07c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c07d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c08c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01c07e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18f0012f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18f40612, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc00c1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cf7400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x39600004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0140004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11600001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18fc003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9740001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400041, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425c07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x166c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800011ee, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a6c003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800011e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428002c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ac007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ab00030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aac0fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc434000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc434000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001205, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425c07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x166c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11600001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0fffa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001232, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27fc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd841c07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43dc07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc0078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ffbc00c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03a2800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf81c07c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c07d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c08c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c07e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf80001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf80001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0bb80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43dc07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17fc001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0fffa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801c07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43dc07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03ae000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf81c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03a0800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf81c07c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c07d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c08c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c07e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf80001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0bb80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43dc07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17fc001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0fffa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03ae000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf81c200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03a4000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf81c07c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c07d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c08c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c07e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0bb80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43dc07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17fc001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0fffa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30d00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000052, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640090f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1514001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19180038, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d324e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431324d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc435324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ab0c006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000127f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d3258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313257, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353259, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ab0c012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a0003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e624004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f67800f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53740002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef6c011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ab42010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16a8000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a80800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b740000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f6b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf40001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1514001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0012e1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x964008d7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9800036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300677, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012aa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b34060b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f37000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ec00ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03a8002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef6c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7edec00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f3b000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4140032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc410001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29540008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1858003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99800007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d0cc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d0006c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d407f0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2598003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d190004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d5d4001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d52000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012d8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d514002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012d8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193259, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d958001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd5c002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813259, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc1325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1ccc001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14f00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd980003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9c0003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9800040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd9c00040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800010de, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33f80003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800051, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc80003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24b00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1330000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18a800e5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1d980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7da9800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b74003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b304000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431326c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b4c00f8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50700020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04e81324, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18ac0024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50600020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30e40004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d71401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x596401fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b74008d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e76400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a640000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000132c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000133b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001344, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42530b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a68003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2024003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25980700, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11980014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d19000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd0130b7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce4130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce40001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de6800f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffea, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce40001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc428000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8240011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de6800f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffe0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00104f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28182002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340035, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140023, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11a00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d614011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4100026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05980008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca4800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d1a0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cb0800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3e280008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cb4800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x20240030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ca48001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b4c00f8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28340000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x507c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30e40004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d7d401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x557c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28342002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c018001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf81a2a4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c007eb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50500020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d0d001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1000072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8100072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x591c01fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45140210, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x595801fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11980009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29dc0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc0001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1624001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400069, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a307fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x23304076, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc00e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10cc0015, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x4514020c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a2001e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a204001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a64003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1264001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15dc000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dcdc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5dc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001427, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340022, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdf430000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4412e01, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0434001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdf430000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdf030000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4412e40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c030, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41c031, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x248dfffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc12e00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc812e00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00142b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45140248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8200011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013257, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0434000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdb000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45540008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd140001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9980ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8200011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013259, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0337fff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f220009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55300020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d01c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c01d0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000d61, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06ec0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f01c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000d61, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c01c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c000d61, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50500020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001427, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd0c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd0c00072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8240072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd240001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19682011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5a6c01fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12ec0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eeac00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aec0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4180011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c438001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99800007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdf830000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfa0000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00142b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00142b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4380007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17b80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d40038, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400029, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9540073d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18c80066, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30880001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00187c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd910000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x4220000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24e80007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24ec0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc5310000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001465, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1000072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc82c0072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2c0001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18f02011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5aec01fc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12ec0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aec0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0aa80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a8146a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f1f0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f1b400f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001478, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f1b400e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001478, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f1b400c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000147a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f1b400d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000147a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f1b400f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000147a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f1b400e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000147a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f334002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97400014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000147b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b400012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e024001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000144a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb81ff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fbfc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x251001ef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94800007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00187c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42c0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd910000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40d325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800012c2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13f4000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bf0060b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc0077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ff3c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800014a9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d325a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc0677, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb81ff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0328007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb7800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13fc0017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ff3c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ffbc00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc1325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03a0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf8130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29540008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd9c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45dc0390, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04183000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b380057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b340213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f7b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c424001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c428001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c42c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c430001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c434001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c438001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04182000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd813267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840004f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a0800fd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x109c000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd9c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc13265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2620ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce080228, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9880000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce480250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce880258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800004f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0ec75, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0fffb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc80230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce480250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce880258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52a80020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x66580001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0fffb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc80260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec80288, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf080290, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec80298, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf0802a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf4802a8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27580001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0fffb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc802b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80802b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x178c000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b8003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cf8c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf8802c0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc802c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf8802d0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf8802d8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800004f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bc800ea, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25b8ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd2800c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc5230309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2620ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e3a400c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2510000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001539, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd08034b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd880353, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00163f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49b0353, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0228, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2510000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd14005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2510000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000154f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd080238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd08034b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2598ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3d200008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc80230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd900309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8100319, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340801, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2198003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd910ce7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4190ce6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d918005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d918004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd810ce6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdd1054f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000156e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x090c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdcd050e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x040c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x110c0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc4001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41230a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41230b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41230c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc41230d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc480329, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc48032a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc4802e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000055, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f02e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d8003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09940001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x44100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580002c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x69100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000157f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4970290, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49b0288, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d59401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49b02a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49f0298, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x041c0040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dcdc002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d924019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d26400c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0fffa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00163f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001579, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d010021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d914019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55580020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd480298, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd8802a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10d40010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12180016, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc51f0309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d95800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d62000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd9c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdd00309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce113320, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f02e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49b02b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18dc01e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd9400e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c0001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00163f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800015aa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4a302b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12240004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e5e400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4ab02a8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04100000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce4c0319, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d9d8002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ea14005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2620000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800015bc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04240001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e624004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d25000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2620000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0fff4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd0d3330, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce0802b8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd8802b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4ab02e0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aa807f0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f02d0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49702d8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49b02c8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49f02c0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96800028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d4e000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9600000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d964002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d694001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800015e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cde4002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de94001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800015e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd64002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d694001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800015e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00163f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800015cd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930238, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d698002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd4802d8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x129c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc50f0319, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11a0000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11140001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1e000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1198000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd953300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e0e000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a8000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce953301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce100319, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b70280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73800a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x536c0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9780eb68, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001608, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001609, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30b40000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b400011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b70258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53780020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb3801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7faf8019, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x67b40001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x57b80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4bb0260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fab8001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf880260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x66f40001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97400005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4353247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f7f4009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fff7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x269c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a00018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a00060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x269c0018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a00007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a40060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11dc0006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29dc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de5c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b70228, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2510000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc80230, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f514005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2510000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001644, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd080240, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f130005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001688, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00120d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001219, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001232, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340801, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f130004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01051e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42d051f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ed2c005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96c0fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01051f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000055, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc5170309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x195c07f0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x196007f6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04340001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x6b740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001665, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4a702a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4ab0298, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52640020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f634014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e76401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56680020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8113320, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce480298, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce8802a0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc5170319, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b702b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x255c000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f5f4001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8113330, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf4802b0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11340001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x195c07e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x196007ee, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8353300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1e4001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8353301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce4802d0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8100309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8100319, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4970258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc48f0250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd4c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4af0280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x64d80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580005c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dc24001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd2000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3255, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc435324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7df5c00c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25980040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb0003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000049, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33380003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800046, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4393260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb000e4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800016f1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc033ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2f3000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f3b0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b800ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a7003e6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27380003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13b80004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a7000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07b80002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a700064, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17b00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf012082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800016df, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17b00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf012082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb30002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4392083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffdf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffca, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd841325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2030007b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800016f2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd841325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2b0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940ff9c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001608, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840004f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29540008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bc800ea, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd80802e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18fc0064, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00042, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51980020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dd9801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x45980400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b380057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b340213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f7b400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f73400a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14f4001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4bf02e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x192807fa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4bf0258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4a70250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53fc0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e7e401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x667c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0aec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eebc00c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fff8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x43300007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7db30011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd3000025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc03ec005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfca200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x192807fa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc01f007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d1d0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2110007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x203c003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0017f5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18fc01e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00185b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8413247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40ffd5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800004f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4bf02e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0ea24, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14d4001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d52400e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49f0258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4a30250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51dc0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400017, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d534002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4af0270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dae4005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32e0001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec80270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000174f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b740001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00178a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40fff3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4af0280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001608, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4ab0268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7daa4005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32a0001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001765, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc01f007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d1d0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2110007d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8013256, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c0017f2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd013254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4113248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b3034b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f13000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001855, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32a4001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8413247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800004f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd080260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce880268, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940ffc0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ec28001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32e0001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253255, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431324f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e72400c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a80040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9680fff7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aa4003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400049, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aa400e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32680003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a800046, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4293260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1aa400e4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800017e2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc027ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2e6400ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a4009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a800ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4240009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19e403e6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26680003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12a80004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ea68001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19e400e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ea68001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ea68001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19e40064, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x32640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16a40005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06640003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce412082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a640003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800017d0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16a40005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce412082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ea64002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4292083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ea68005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a80ffdf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc429325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26a400ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40ffca, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd841325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2024007b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800017e3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd841325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4a70280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4ab0278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52640020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7eae8014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e6a401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56680020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce480278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce880280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x042c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec80270, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c438001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800017fe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4bf02e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c438001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800017fe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43b02eb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42302ec, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf813245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fa3801a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x47b8020c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x15e00008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1220000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2a206032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x513c001e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e3e001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4bf02e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000180f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b3c0077, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ff3000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1330000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd200000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4200007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd3800002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dc30001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc1e0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04380032, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf80000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001427, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc413248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3269, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27fc000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33fc0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdfc30000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4413249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c43c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c43c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0bfc0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdfc30000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd441326a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x173c0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300303, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f3f0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ff3c004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13084, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001842, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdfc30000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4413249, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c43c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x23fc003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc1326d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0bb80026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdf830000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd441326e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c438001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c438001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4393265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1fb8ffc6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xddc30000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf813265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc0000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001852, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc0000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c00142b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc13252, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013253, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001878, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49f02e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c00018, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c420001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc13252, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013253, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c3000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c0012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001878, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41f02ed, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42302ee, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc13252, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013253, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e2a0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013084, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28340001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x313c0bcc, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x393c051f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3d3c050e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x393c0560, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3d3c054f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x393c1538, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3d3c1537, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b740800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bc800ea, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e8007c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c42c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a8189a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000189e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800018c5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800018f2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c414001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d0007e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x50580020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d59401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc8140072, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09240002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c418001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4340004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc42130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a24002c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2020002c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc418000d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1198001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10cc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14cc0004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7cd8c00a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc130b7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce0130b5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd1400025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x5978073a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bb80002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf800024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd800026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9600e8a8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9640e8a5, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800018a9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc55b0309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3d5c0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2598ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09780001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dad800c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0ffd2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580fff9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4970258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x442c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x65180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2b0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7df9c00c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c13260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd901325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940fff1, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x66d80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x56ec0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26240007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940fff7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000189e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc023007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19e4003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7de1c009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dee000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96000007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c13260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd901325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc421325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x261c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000189e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940fff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000189e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28cc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43d3265, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bc800ea, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18e00064, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06281911, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14f4001d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24cc0003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x86800000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001915, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x800019af, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001a2b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8000016a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc48032b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc480333, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc48033b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc480343, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98800011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x46640400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04203000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b3c0057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b200213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e3e000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e32000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4970258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4af0280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04180000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f438001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00068, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213254, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a1c003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00065, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc01f007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1e0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97800062, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0bb80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x43bc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fcbc001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc7df032b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1fc00c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0101, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c0102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb0003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000049, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33380003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800046, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4393260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb000e4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001994, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc033ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2f3000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f3b0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b800ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f003e6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27380003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13b80004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07b80002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f00064, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17b00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf012082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001982, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17b00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf012082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb30002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4392083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffdf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffcb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc1325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2030007b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001995, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc1325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2b0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98800009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x41bc0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x53fc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e7fc011, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd3c00025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0012, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9bc0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x653c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dbd8001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940ff8f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2bfc0008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x043c2000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcfc13267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c410001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc55b0309, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x3d5c0010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2598ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x05540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d91800c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580fff8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09780001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4970258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4af0280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x65180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9580005d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200101, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400058, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dc24001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41d3248, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25dc000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7df9c00c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95c00053, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e41c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a70003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000049, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a7000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33240003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a400046, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1a7000e4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001a21, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc033ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2f3000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f270009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x266400ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f003e6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27240003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12640004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e724001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e724001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e724001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06640002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f00064, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16700005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf012082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001a0f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x16700005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf012082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e730002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4252083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e724005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x26640001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a40ffdf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x267000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffca, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2030007b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001a22, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2b0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940ff9f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001a31, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8080280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213246, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4253245, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52200020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e26401a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x46640400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04203000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce013267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4213267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b180057, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b200213, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1b300199, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e1a000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e32000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce000024, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4970258, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4930250, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x51540020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4af0280, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4b30278, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x52ec0020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140020, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04280000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x65180001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800060, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x8c001628, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4193247, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x25980001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200101, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x30f00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95800056, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb0003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000049, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33380003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b800046, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4393260, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bb000e4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001aa2, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc033ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2f3000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f3b0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf01325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b800ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4300009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9700fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f003e6, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27380003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13b80004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f000e8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07b80002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x19f00064, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33300002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17b00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf012082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0b300003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001a90, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x17b00005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf012082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01203f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x13300005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb30002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4392083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7fb38005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b80ffdf, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c00034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc00013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc431325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27300010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc439325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27b000ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b00ffca, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2030007b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf00325b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001aa3, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce01325d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04300001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7f2b0014, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ef2c01a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49b02e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99800005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd2400025, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x4664001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000026, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400027, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x06a80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55100001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940ff9c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc49b02e9, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99800008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc430000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2b300008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf000013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04302000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcf013267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc4313267, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x244c00ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc4c0200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc44f0200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc410000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d158010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x059cc000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccdd0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0037, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000049, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c003a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9500e69a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d0003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d40021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd840004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c003c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x14cc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c00028, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000033, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc438000b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0009, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x27fc0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd841c07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43dc07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1bfc0078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7ffbc00c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x97c0fffd, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x99000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0120840, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x282c0040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001ae8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0121841, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x282c001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01c07c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c07d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c08c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c079, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c07e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcec0001b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a200001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9a00ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425c07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x166c001f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04200004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9ac0fffb, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc434000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9b40ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801c07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc425c07f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8000034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940e66b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800004a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0036, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9900fffe, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18cc0021, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc00047, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc000046, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0039, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c003d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c40c001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24d003ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d47fea, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x18d87ff4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd00004c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd40004e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd80004d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41c405, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc02a0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2aa80001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01c406, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c406, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c406, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc414000e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x29540008, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x295c0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8c1325e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcdc0001a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11980002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x4110000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0160800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7d15000a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0164010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41c078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c080, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c081, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81c082, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc01c083, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01c084, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x98c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400048, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c003b, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x94c0ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000c16, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801c40a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd901c40d, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801c410, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801c40e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd801c40f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc40c0040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x09540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9940ffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04140096, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8400013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1c400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc411c401, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9500fffa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424003e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04d00001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x11100002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd01c40c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0180034, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd81c411, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd841c414, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0a540001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcd41c412, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x2468000f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc419c416, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x41980003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc41c003f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7dda0001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x12200002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x10cc0002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xccc1c40c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd901c411, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce41c412, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd8800013, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xce292e40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e01, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e02, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e03, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc412e00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000aa7, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc43c0007, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc120000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x31144000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x95400005, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xdc030000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd800002a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xcc3c000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b70, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x33f80003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd4400078, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x9780e601, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x188cfff0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x04e40002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001190, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400006, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x90000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc424005e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x96400003, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7c408001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x88000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80001b74, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000168, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110501, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120206, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130703, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92100400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92110105, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92120602, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x92130307, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xbf810000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000004, mmCP_DFY_CNTL                              },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_ADDR_HI                           },
    { PwrCmdWrite, 0x54106500, mmCP_DFY_ADDR_LO                           },
    { PwrCmdWrite, 0x7e000200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e020204, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc00a0505, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xbf8c007f, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb8900904, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb8911a04, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb8920304, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb8930b44, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x921c0d0c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x921c1c13, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x921d0c12, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x811c1d1c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x811c111c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x921cff1c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000400, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x921dff10, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000100, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x81181d1c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e040218, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0701000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0701000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0701000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0701000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0701000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0701000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050102, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xe0501000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80050302, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xbf810000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000004, mmCP_DFY_CNTL                              },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_ADDR_HI                           },
    { PwrCmdWrite, 0x54106900, mmCP_DFY_ADDR_LO                           },
    { PwrCmdWrite, 0x7e080200, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x7e100204, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xbefc00ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00010000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x24200087, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x262200ff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000001f0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x20222282, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x28182111, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000040c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd81a0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000080c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xd86c0000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x1100000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xbf810000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x80000004, mmCP_DFY_CNTL                              },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_ADDR_HI                           },
    { PwrCmdWrite, 0x54116f00, mmCP_DFY_ADDR_LO                           },
    { PwrCmdWrite, 0xc0310800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb4540fe8, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000041, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000000c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07808000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x540fee40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54116f00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00005301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb4540fef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x540fee20, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0310800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb454105e, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000c0, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07808000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x540fee40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54117300, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00005301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb4540fef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x540fee20, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0310800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb4541065, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000500, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000001c, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07808000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x540fee40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54117700, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00005301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb4540fef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x540fee20, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xc0310800, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000040, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb4541069, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000444, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x0000008a, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x07808000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xffffffff, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000002, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xaaaaaaaa, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x55555555, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x540fee40, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000010, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000001, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000004, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x54117b00, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00005301, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0xb4540fef, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x540fee20, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x000000b4, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x08000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_DFY_DATA_0                            },
    { PwrCmdWrite, 0x00000000, mmCP_MEC_CNTL                              },
    { PwrCmdWrite, 0x00000000, mmCP_MEC_CNTL                              },
    { PwrCmdWrite, 0x00000004, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x54116f00, mmCP_MQD_BASE_ADDR                         },
    { PwrCmdWrite, 0x000000b4, mmCP_MQD_BASE_ADDR_HI                      },
    { PwrCmdWrite, 0xb4540fef, mmCP_HQD_PQ_BASE                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_BASE_HI                        },
    { PwrCmdWrite, 0x540fee20, mmCP_HQD_PQ_WPTR_POLL_ADDR                 },
    { PwrCmdWrite, 0x000000b4, mmCP_HQD_PQ_WPTR_POLL_ADDR_HI              },
    { PwrCmdWrite, 0x00005301, mmCP_HQD_PERSISTENT_STATE                  },
    { PwrCmdWrite, 0x00010000, mmCP_HQD_VMID                              },
    { PwrCmdWrite, 0xc8318509, mmCP_HQD_PQ_CONTROL                        },
    { PwrCmdWrite, 0x00000005, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x54117300, mmCP_MQD_BASE_ADDR                         },
    { PwrCmdWrite, 0x000000b4, mmCP_MQD_BASE_ADDR_HI                      },
    { PwrCmdWrite, 0xb4540fef, mmCP_HQD_PQ_BASE                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_BASE_HI                        },
    { PwrCmdWrite, 0x540fee20, mmCP_HQD_PQ_WPTR_POLL_ADDR                 },
    { PwrCmdWrite, 0x000000b4, mmCP_HQD_PQ_WPTR_POLL_ADDR_HI              },
    { PwrCmdWrite, 0x00005301, mmCP_HQD_PERSISTENT_STATE                  },
    { PwrCmdWrite, 0x00010000, mmCP_HQD_VMID                              },
    { PwrCmdWrite, 0xc8318509, mmCP_HQD_PQ_CONTROL                        },
    { PwrCmdWrite, 0x00000006, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x54117700, mmCP_MQD_BASE_ADDR                         },
    { PwrCmdWrite, 0x000000b4, mmCP_MQD_BASE_ADDR_HI                      },
    { PwrCmdWrite, 0xb4540fef, mmCP_HQD_PQ_BASE                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_BASE_HI                        },
    { PwrCmdWrite, 0x540fee20, mmCP_HQD_PQ_WPTR_POLL_ADDR                 },
    { PwrCmdWrite, 0x000000b4, mmCP_HQD_PQ_WPTR_POLL_ADDR_HI              },
    { PwrCmdWrite, 0x00005301, mmCP_HQD_PERSISTENT_STATE                  },
    { PwrCmdWrite, 0x00010000, mmCP_HQD_VMID                              },
    { PwrCmdWrite, 0xc8318509, mmCP_HQD_PQ_CONTROL                        },
    { PwrCmdWrite, 0x00000007, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x54117b00, mmCP_MQD_BASE_ADDR                         },
    { PwrCmdWrite, 0x000000b4, mmCP_MQD_BASE_ADDR_HI                      },
    { PwrCmdWrite, 0xb4540fef, mmCP_HQD_PQ_BASE                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_BASE_HI                        },
    { PwrCmdWrite, 0x540fee20, mmCP_HQD_PQ_WPTR_POLL_ADDR                 },
    { PwrCmdWrite, 0x000000b4, mmCP_HQD_PQ_WPTR_POLL_ADDR_HI              },
    { PwrCmdWrite, 0x00005301, mmCP_HQD_PERSISTENT_STATE                  },
    { PwrCmdWrite, 0x00010000, mmCP_HQD_VMID                              },
    { PwrCmdWrite, 0xc8318509, mmCP_HQD_PQ_CONTROL                        },
    { PwrCmdWrite, 0x00000004, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000104, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000204, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000304, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000404, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000504, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000604, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000704, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000005, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000105, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000205, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000305, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000405, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000505, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000605, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000705, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000006, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000106, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000206, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000306, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000406, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000506, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000606, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000706, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000007, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000107, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000207, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000307, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000407, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000507, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000607, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000707, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000008, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000108, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000208, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000308, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000408, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000508, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000608, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000708, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000009, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000109, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000209, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000309, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000409, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000509, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000609, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000709, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_RPTR                           },
    { PwrCmdWrite, 0x00000000, mmCP_HQD_PQ_WPTR                           },
    { PwrCmdWrite, 0x00000001, mmCP_HQD_ACTIVE                            },
    { PwrCmdWrite, 0x00000004, mmSRBM_GFX_CNTL                            },
    { PwrCmdWrite, 0x01010101, mmCP_PQ_WPTR_POLL_CNTL1                    },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdWrite, 0x00000000, mmGRBM_STATUS                              },
    { PwrCmdEnd,   0x00000000, 0x00000000                                 },
};

#endif
