/*
 * SiRF Audio port controllers define
 *
 * Copyright (c) 2011 Cambridge Silicon Radio Limited, a CSR plc group company.
 *
 * Licensed under GPLv2 or later.
 */

#ifndef _SIRF_AUDIO_PORT_H
#define _SIRF_AUDIO_PORT_H

#define AUDIO_PORT_TX_FIFO_LEVEL_CHECK_MASK     0x3F
#define AUDIO_PORT_TX_FIFO_SC_OFFSET    0
#define AUDIO_PORT_TX_FIFO_LC_OFFSET    10
#define AUDIO_PORT_TX_FIFO_HC_OFFSET    20

#define TX_FIFO_SC(x)           (((x) & AUDIO_PORT_TX_FIFO_LEVEL_CHECK_MASK) \
				<< AUDIO_PORT_TX_FIFO_SC_OFFSET)
#define TX_FIFO_LC(x)           (((x) & AUDIO_PORT_TX_FIFO_LEVEL_CHECK_MASK) \
				<< AUDIO_PORT_TX_FIFO_LC_OFFSET)
#define TX_FIFO_HC(x)           (((x) & AUDIO_PORT_TX_FIFO_LEVEL_CHECK_MASK) \
				<< AUDIO_PORT_TX_FIFO_HC_OFFSET)

#define AUDIO_PORT_RX_FIFO_LEVEL_CHECK_MASK     0x0F
#define AUDIO_PORT_RX_FIFO_SC_OFFSET    0
#define AUDIO_PORT_RX_FIFO_LC_OFFSET    10
#define AUDIO_PORT_RX_FIFO_HC_OFFSET    20

#define RX_FIFO_SC(x)           (((x) & AUDIO_PORT_RX_FIFO_LEVEL_CHECK_MASK) \
				<< AUDIO_PORT_RX_FIFO_SC_OFFSET)
#define RX_FIFO_LC(x)           (((x) & AUDIO_PORT_RX_FIFO_LEVEL_CHECK_MASK) \
				<< AUDIO_PORT_RX_FIFO_LC_OFFSET)
#define RX_FIFO_HC(x)           (((x) & AUDIO_PORT_RX_FIFO_LEVEL_CHECK_MASK) \
				<< AUDIO_PORT_RX_FIFO_HC_OFFSET)
#define AUDIO_PORT_IC_CODEC_TX_CTRL		(0x00F4)
#define AUDIO_PORT_IC_CODEC_RX_CTRL		(0x00F8)

#define AUDIO_PORT_IC_TXFIFO_OP			(0x00FC)
#define AUDIO_PORT_IC_TXFIFO_LEV_CHK		(0x0100)
#define AUDIO_PORT_IC_TXFIFO_STS		(0x0104)
#define AUDIO_PORT_IC_TXFIFO_INT		(0x0108)
#define AUDIO_PORT_IC_TXFIFO_INT_MSK		(0x010C)

#define AUDIO_PORT_IC_RXFIFO_OP			(0x0110)
#define AUDIO_PORT_IC_RXFIFO_LEV_CHK		(0x0114)
#define AUDIO_PORT_IC_RXFIFO_STS		(0x0118)
#define AUDIO_PORT_IC_RXFIFO_INT		(0x011C)
#define AUDIO_PORT_IC_RXFIFO_INT_MSK		(0x0120)

#define AUDIO_FIFO_START		(1 << 0)
#define AUDIO_FIFO_RESET		(1 << 1)

#define AUDIO_FIFO_FULL			(1 << 0)
#define AUDIO_FIFO_EMPTY		(1 << 1)
#define AUDIO_FIFO_OFLOW		(1 << 2)
#define AUDIO_FIFO_UFLOW		(1 << 3)

#define IC_TX_ENABLE		(0x03)
#define IC_RX_ENABLE_MONO	(0x01)
#define IC_RX_ENABLE_STEREO	(0x03)

#endif /*__SIRF_AUDIO_PORT_H*/
