/*
 * Coldfire generic GPIO support
 *
 * (C) Copyright 2009, Steven King <sfking@fdwdc.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
*/

#include <linux/kernel.h>
#include <linux/init.h>

#include <asm/coldfire.h>
#include <asm/mcfsim.h>
#include <asm/mcfgpio.h>

static struct mcf_gpio_chip mcf_gpio_chips[] = {
#if defined(CONFIG_M5271)
	{
		.gpio_chip			= {
			.label			= "PIRQ",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value,
			.base			= 1,
			.ngpio			= 7,
		},
		.pddr				= MCFEPORT_EPDDR,
		.podr				= MCFEPORT_EPDR,
		.ppdr				= MCFEPORT_EPPDR,
	},
	{
		.gpio_chip			= {
			.label			= "ADDR",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 13,
			.ngpio			= 3,
		},
		.pddr				= MCFGPIO_PDDR_ADDR,
		.podr				= MCFGPIO_PODR_ADDR,
		.ppdr				= MCFGPIO_PPDSDR_ADDR,
		.setr				= MCFGPIO_PPDSDR_ADDR,
		.clrr				= MCFGPIO_PCLRR_ADDR,
	},
	{
		.gpio_chip			= {
			.label			= "DATAH",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 16,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_DATAH,
		.podr				= MCFGPIO_PODR_DATAH,
		.ppdr				= MCFGPIO_PPDSDR_DATAH,
		.setr				= MCFGPIO_PPDSDR_DATAH,
		.clrr				= MCFGPIO_PCLRR_DATAH,
	},
	{
		.gpio_chip			= {
			.label			= "DATAL",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 24,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_DATAL,
		.podr				= MCFGPIO_PODR_DATAL,
		.ppdr				= MCFGPIO_PPDSDR_DATAL,
		.setr				= MCFGPIO_PPDSDR_DATAL,
		.clrr				= MCFGPIO_PCLRR_DATAL,
	},
	{
		.gpio_chip			= {
			.label			= "BUSCTL",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 32,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_BUSCTL,
		.podr				= MCFGPIO_PODR_BUSCTL,
		.ppdr				= MCFGPIO_PPDSDR_BUSCTL,
		.setr				= MCFGPIO_PPDSDR_BUSCTL,
		.clrr				= MCFGPIO_PCLRR_BUSCTL,
	},
	{
		.gpio_chip			= {
			.label			= "BS",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 40,
			.ngpio			= 4,
		},
		.pddr				= MCFGPIO_PDDR_BS,
		.podr				= MCFGPIO_PODR_BS,
		.ppdr				= MCFGPIO_PPDSDR_BS,
		.setr				= MCFGPIO_PPDSDR_BS,
		.clrr				= MCFGPIO_PCLRR_BS,
	},
	{
		.gpio_chip			= {
			.label			= "CS",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 49,
			.ngpio			= 7,
		},
		.pddr				= MCFGPIO_PDDR_CS,
		.podr				= MCFGPIO_PODR_CS,
		.ppdr				= MCFGPIO_PPDSDR_CS,
		.setr				= MCFGPIO_PPDSDR_CS,
		.clrr				= MCFGPIO_PCLRR_CS,
	},
	{
		.gpio_chip			= {
			.label			= "SDRAM",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 56,
			.ngpio			= 6,
		},
		.pddr				= MCFGPIO_PDDR_SDRAM,
		.podr				= MCFGPIO_PODR_SDRAM,
		.ppdr				= MCFGPIO_PPDSDR_SDRAM,
		.setr				= MCFGPIO_PPDSDR_SDRAM,
		.clrr				= MCFGPIO_PCLRR_SDRAM,
	},
	{
		.gpio_chip			= {
			.label			= "FECI2C",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 64,
			.ngpio			= 4,
		},
		.pddr				= MCFGPIO_PDDR_FECI2C,
		.podr				= MCFGPIO_PODR_FECI2C,
		.ppdr				= MCFGPIO_PPDSDR_FECI2C,
		.setr				= MCFGPIO_PPDSDR_FECI2C,
		.clrr				= MCFGPIO_PCLRR_FECI2C,
	},
	{
		.gpio_chip			= {
			.label			= "UARTH",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 72,
			.ngpio			= 2,
		},
		.pddr				= MCFGPIO_PDDR_UARTH,
		.podr				= MCFGPIO_PODR_UARTH,
		.ppdr				= MCFGPIO_PPDSDR_UARTH,
		.setr				= MCFGPIO_PPDSDR_UARTH,
		.clrr				= MCFGPIO_PCLRR_UARTH,
	},
	{
		.gpio_chip			= {
			.label			= "UARTL",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 80,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_UARTL,
		.podr				= MCFGPIO_PODR_UARTL,
		.ppdr				= MCFGPIO_PPDSDR_UARTL,
		.setr				= MCFGPIO_PPDSDR_UARTL,
		.clrr				= MCFGPIO_PCLRR_UARTL,
	},
	{
		.gpio_chip			= {
			.label			= "QSPI",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 88,
			.ngpio			= 5,
		},
		.pddr				= MCFGPIO_PDDR_QSPI,
		.podr				= MCFGPIO_PODR_QSPI,
		.ppdr				= MCFGPIO_PPDSDR_QSPI,
		.setr				= MCFGPIO_PPDSDR_QSPI,
		.clrr				= MCFGPIO_PCLRR_QSPI,
	},
	{
		.gpio_chip			= {
			.label			= "TIMER",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 96,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_TIMER,
		.podr				= MCFGPIO_PODR_TIMER,
		.ppdr				= MCFGPIO_PPDSDR_TIMER,
		.setr				= MCFGPIO_PPDSDR_TIMER,
		.clrr				= MCFGPIO_PCLRR_TIMER,
	},
#elif defined(CONFIG_M5275)
	{
		.gpio_chip			= {
			.label			= "PIRQ",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value,
			.base			= 1,
			.ngpio			= 7,
		},
		.pddr				= MCFEPORT_EPDDR,
		.podr				= MCFEPORT_EPDR,
		.ppdr				= MCFEPORT_EPPDR,
	},
	{
		.gpio_chip			= {
			.label			= "BUSCTL",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 8,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_BUSCTL,
		.podr				= MCFGPIO_PODR_BUSCTL,
		.ppdr				= MCFGPIO_PPDSDR_BUSCTL,
		.setr				= MCFGPIO_PPDSDR_BUSCTL,
		.clrr				= MCFGPIO_PCLRR_BUSCTL,
	},
	{
		.gpio_chip			= {
			.label			= "ADDR",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 21,
			.ngpio			= 3,
		},
		.pddr				= MCFGPIO_PDDR_ADDR,
		.podr				= MCFGPIO_PODR_ADDR,
		.ppdr				= MCFGPIO_PPDSDR_ADDR,
		.setr				= MCFGPIO_PPDSDR_ADDR,
		.clrr				= MCFGPIO_PCLRR_ADDR,
	},
	{
		.gpio_chip			= {
			.label			= "CS",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 25,
			.ngpio			= 7,
		},
		.pddr				= MCFGPIO_PDDR_CS,
		.podr				= MCFGPIO_PODR_CS,
		.ppdr				= MCFGPIO_PPDSDR_CS,
		.setr				= MCFGPIO_PPDSDR_CS,
		.clrr				= MCFGPIO_PCLRR_CS,
	},
	{
		.gpio_chip			= {
			.label			= "FEC0H",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 32,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_FEC0H,
		.podr				= MCFGPIO_PODR_FEC0H,
		.ppdr				= MCFGPIO_PPDSDR_FEC0H,
		.setr				= MCFGPIO_PPDSDR_FEC0H,
		.clrr				= MCFGPIO_PCLRR_FEC0H,
	},
	{
		.gpio_chip			= {
			.label			= "FEC0L",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 40,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_FEC0L,
		.podr				= MCFGPIO_PODR_FEC0L,
		.ppdr				= MCFGPIO_PPDSDR_FEC0L,
		.setr				= MCFGPIO_PPDSDR_FEC0L,
		.clrr				= MCFGPIO_PCLRR_FEC0L,
	},
	{
		.gpio_chip			= {
			.label			= "FECI2C",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 48,
			.ngpio			= 6,
		},
		.pddr				= MCFGPIO_PDDR_FECI2C,
		.podr				= MCFGPIO_PODR_FECI2C,
		.ppdr				= MCFGPIO_PPDSDR_FECI2C,
		.setr				= MCFGPIO_PPDSDR_FECI2C,
		.clrr				= MCFGPIO_PCLRR_FECI2C,
	},
	{
		.gpio_chip			= {
			.label			= "QSPI",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 56,
			.ngpio			= 7,
		},
		.pddr				= MCFGPIO_PDDR_QSPI,
		.podr				= MCFGPIO_PODR_QSPI,
		.ppdr				= MCFGPIO_PPDSDR_QSPI,
		.setr				= MCFGPIO_PPDSDR_QSPI,
		.clrr				= MCFGPIO_PCLRR_QSPI,
	},
	{
		.gpio_chip			= {
			.label			= "SDRAM",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 64,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_SDRAM,
		.podr				= MCFGPIO_PODR_SDRAM,
		.ppdr				= MCFGPIO_PPDSDR_SDRAM,
		.setr				= MCFGPIO_PPDSDR_SDRAM,
		.clrr				= MCFGPIO_PCLRR_SDRAM,
	},
	{
		.gpio_chip			= {
			.label			= "TIMERH",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 72,
			.ngpio			= 4,
		},
		.pddr				= MCFGPIO_PDDR_TIMERH,
		.podr				= MCFGPIO_PODR_TIMERH,
		.ppdr				= MCFGPIO_PPDSDR_TIMERH,
		.setr				= MCFGPIO_PPDSDR_TIMERH,
		.clrr				= MCFGPIO_PCLRR_TIMERH,
	},
	{
		.gpio_chip			= {
			.label			= "TIMERL",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 80,
			.ngpio			= 4,
		},
		.pddr				= MCFGPIO_PDDR_TIMERL,
		.podr				= MCFGPIO_PODR_TIMERL,
		.ppdr				= MCFGPIO_PPDSDR_TIMERL,
		.setr				= MCFGPIO_PPDSDR_TIMERL,
		.clrr				= MCFGPIO_PCLRR_TIMERL,
	},
	{
		.gpio_chip			= {
			.label			= "UARTL",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 88,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_UARTL,
		.podr				= MCFGPIO_PODR_UARTL,
		.ppdr				= MCFGPIO_PPDSDR_UARTL,
		.setr				= MCFGPIO_PPDSDR_UARTL,
		.clrr				= MCFGPIO_PCLRR_UARTL,
	},
	{
		.gpio_chip			= {
			.label			= "FEC1H",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 96,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_FEC1H,
		.podr				= MCFGPIO_PODR_FEC1H,
		.ppdr				= MCFGPIO_PPDSDR_FEC1H,
		.setr				= MCFGPIO_PPDSDR_FEC1H,
		.clrr				= MCFGPIO_PCLRR_FEC1H,
	},
	{
		.gpio_chip			= {
			.label			= "FEC1L",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 104,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_FEC1L,
		.podr				= MCFGPIO_PODR_FEC1L,
		.ppdr				= MCFGPIO_PPDSDR_FEC1L,
		.setr				= MCFGPIO_PPDSDR_FEC1L,
		.clrr				= MCFGPIO_PCLRR_FEC1L,
	},
	{
		.gpio_chip			= {
			.label			= "BS",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 114,
			.ngpio			= 2,
		},
		.pddr				= MCFGPIO_PDDR_BS,
		.podr				= MCFGPIO_PODR_BS,
		.ppdr				= MCFGPIO_PPDSDR_BS,
		.setr				= MCFGPIO_PPDSDR_BS,
		.clrr				= MCFGPIO_PCLRR_BS,
	},
	{
		.gpio_chip			= {
			.label			= "IRQ",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 121,
			.ngpio			= 7,
		},
		.pddr				= MCFGPIO_PDDR_IRQ,
		.podr				= MCFGPIO_PODR_IRQ,
		.ppdr				= MCFGPIO_PPDSDR_IRQ,
		.setr				= MCFGPIO_PPDSDR_IRQ,
		.clrr				= MCFGPIO_PCLRR_IRQ,
	},
	{
		.gpio_chip			= {
			.label			= "USBH",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 128,
			.ngpio			= 1,
		},
		.pddr				= MCFGPIO_PDDR_USBH,
		.podr				= MCFGPIO_PODR_USBH,
		.ppdr				= MCFGPIO_PPDSDR_USBH,
		.setr				= MCFGPIO_PPDSDR_USBH,
		.clrr				= MCFGPIO_PCLRR_USBH,
	},
	{
		.gpio_chip			= {
			.label			= "USBL",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 136,
			.ngpio			= 8,
		},
		.pddr				= MCFGPIO_PDDR_USBL,
		.podr				= MCFGPIO_PODR_USBL,
		.ppdr				= MCFGPIO_PPDSDR_USBL,
		.setr				= MCFGPIO_PPDSDR_USBL,
		.clrr				= MCFGPIO_PCLRR_USBL,
	},
	{
		.gpio_chip			= {
			.label			= "UARTH",
			.request		= mcf_gpio_request,
			.free			= mcf_gpio_free,
			.direction_input	= mcf_gpio_direction_input,
			.direction_output	= mcf_gpio_direction_output,
			.get			= mcf_gpio_get_value,
			.set			= mcf_gpio_set_value_fast,
			.base			= 144,
			.ngpio			= 4,
		},
		.pddr				= MCFGPIO_PDDR_UARTH,
		.podr				= MCFGPIO_PODR_UARTH,
		.ppdr				= MCFGPIO_PPDSDR_UARTH,
		.setr				= MCFGPIO_PPDSDR_UARTH,
		.clrr				= MCFGPIO_PCLRR_UARTH,
	},
#endif
};

static int __init mcf_gpio_init(void)
{
	unsigned i = 0;
	while (i < ARRAY_SIZE(mcf_gpio_chips))
		(void)gpiochip_add((struct gpio_chip *)&mcf_gpio_chips[i++]);
	return 0;
}

core_initcall(mcf_gpio_init);
