/*
 * arch/sh/drivers/pci/ops-landisk.c
 *
 * PCI initialization for the I-O DATA Device, Inc. LANDISK board
 *
 * Copyright (C) 2006 kogiidena
 *
 * May be copied or modified under the terms of the GNU General Public
 * License.  See linux/COPYING for more information.
 */
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/pci.h>
#include "pci-sh4.h"

int pcibios_map_platform_irq(struct pci_dev *pdev, u8 slot, u8 pin)
{
	/*
	 * slot0: pin1-4 = irq5,6,7,8
	 * slot1: pin1-4 = irq6,7,8,5
	 * slot2: pin1-4 = irq7,8,5,6
	 * slot3: pin1-4 = irq8,5,6,7
	 */
	int irq = ((slot + pin - 1) & 0x3) + 5;

	if ((slot | (pin - 1)) > 0x3) {
		printk("PCI: Bad IRQ mapping request for slot %d pin %c\n",
		       slot, pin - 1 + 'A');
		return -1;
	}
	return irq;
}
