/* Written 2000 by Andi Kleen */
/* This program is never executed, just its assembly is examined for offsets 
   (this trick is needed to get cross compiling right) */  
/* $Id: offset.c,v 1.13 2002/01/08 15:19:57 ak Exp $ */
#define ASM_OFFSET_H 1
#ifndef __KERNEL__
#define __KERNEL__ 
#endif
#include <linux/sched.h> 
#include <linux/stddef.h>
#include <linux/errno.h> 
#include <asm/pda.h>
#include <asm/hardirq.h>
#include <asm/processor.h>
#include <asm/segment.h>
#include <asm/thread_info.h>

#define output(x) asm volatile ("--- " x)
#define outconst(x,y) asm volatile ("--- " x : : "i" (y)) 

int main(void) 
{ 
	output("/* Auto generated by arch/../tools/offset.c at " __DATE__ ". Do not edit. */\n"); 
	output("#ifndef ASM_OFFSET_H\n");
	output("#define ASM_OFFSET_H 1\n"); 

#define ENTRY(entry) outconst("#define tsk_" #entry " %0", offsetof(struct task_struct, entry))
	ENTRY(state);
	ENTRY(flags); 
	ENTRY(thread); 
#undef ENTRY
#define ENTRY(entry) outconst("#define threadinfo_" #entry " %0", offsetof(struct thread_info, entry))
	ENTRY(flags);
	ENTRY(addr_limit);
	ENTRY(preempt_count);
#undef ENTRY
#define ENTRY(entry) outconst("#define pda_" #entry " %0", offsetof(struct x8664_pda, entry))
	ENTRY(kernelstack); 
	ENTRY(oldrsp); 
	ENTRY(pcurrent); 
	ENTRY(irqrsp);
	ENTRY(irqcount);
	ENTRY(cpunumber);
	ENTRY(irqstackptr);
#undef ENTRY
	output("#endif\n"); 

	return(0); 
} 
