/* $Id: gen-hash.h,v 1.2 2002/07/16 23:13:26 kyle Exp $
 *
 * Generic template for adding hash algorithms to CryptoAPI.
 *
 * Copyright (c) 2002, Kyle McMartin <kyle@achilles.net>.
 * 
 * This source is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * at your option any later version.
 *
 */

#ifndef _GEN_HASH_H_
#define _GEN_HASH_H_

#if !defined(DIGEST_ID)
# error DIGEST_ID not defined
#endif

#if !defined(DIGEST_SIZE)
# error DIGEST_SIZE not defined
#endif

#if !defined(DIGEST_BLOCKSIZE)
# error DIGEST_BLOCKSIZE not defined
#endif

/* __x* defines needed for proper expansion of nested macros */
#define __STR(x) # x
#define __xSTR(x) __STR(x)

#define __CAT(x,y) x ## y
#define __xCAT(x,y) __CAT(x,y)

#define DIGEST_SYMBOL(x) __xCAT(DIGEST_ID,x)
#define __xINIT_DIGEST_OPS(name)       INIT_DIGEST_OPS(name)

#include "gen-hmac.h"

#if !defined(NO_DIGEST_DEFAULT_LOCK_OPS)
static void
DIGEST_SYMBOL(_lock)(void)
{
	MOD_INC_USE_COUNT;
}

static void
DIGEST_SYMBOL(_unlock)(void)
{
	MOD_DEC_USE_COUNT;
}
#endif /* NO_DIGEST_DEFAULT_LOCK_OPS */

static struct digest_implementation DIGEST_ID = {
	{{NULL, NULL}, 0, __xSTR(DIGEST_ID)},
	blocksize: DIGEST_BLOCKSIZE,
	working_size: DIGEST_SIZE,
	__xINIT_DIGEST_OPS(DIGEST_ID)
};

static int __init
DIGEST_SYMBOL(_init)(void)
{
	register_digest(& DIGEST_ID);
	return 0;
}

#define __xmodule_init(s) module_init(s)
__xmodule_init(DIGEST_SYMBOL(_init));
#undef __xmodule_init

static void __exit
DIGEST_SYMBOL(_cleanup)(void)
{
	unregister_digest(& DIGEST_ID);
}

#define __xmodule_exit(s) module_exit(s)
__xmodule_exit(DIGEST_SYMBOL(_cleanup));
#undef __xmodule_exit

#endif /* _GEN_HASH_H_ */
