#ifndef __PCMCIA_H__
#define __PCMCIA_H__

/***********************************************************************
 * 82365.h -- information necessary for direct manipulation of PCMCIA
 * cards and controllers
 *
 * Support is included for Intel 82365SL PCIC controllers and clones
 * thereof.
 *
 * $Id: pcmcia.h,v 1.4 1993/09/07 20:53:13 bjaspan Exp $
 ***********************************************************************/

/*
 * data structures used to store information about PCIC sockets and
 * PCMCIA cards, and functions to manipulate them
 */
#define MAX_CONFIGS 12		/* config table entries */
#define MAX_IOADDRS 2		/* i/o port ranges */
#define MAX_MEMS 4		/* memory ranges */
#define MAX_SOCKS 8		/* pcic sockets */
#define MAX_NAMELEN 16		/* version info string len */

struct pcmcia_cfentry {
     int idx, defp;
     int irqp, irq, irq_mask;
     int iop, ios, io_16, io_addrs[MAX_IOADDRS], io_lens[MAX_IOADDRS];
     int memp, mems, mem_caddrs[MAX_MEMS], mem_lens[MAX_MEMS];
     int mem_haddrs[MAX_MEMS];
};

struct pcic_sock {
     u_short base, ofs;
     int valid;
     char cardp;
     char manufacturer[MAX_NAMELEN], prod_name[MAX_NAMELEN];
     char addl_info1[MAX_NAMELEN], addl_info2[MAX_NAMELEN];
     u_long base_addr;
     int regmask[4];
     int config_midx;
     struct pcmcia_cfentry configs[MAX_CONFIGS];
};

/*
 * Configuration Registers
 *
 * These are the registers required by Release 2.0 of the standard
 * (Section 4.15)
 */

/* Offsets for register ordering */
#define PCMCIA_COR	0x00	/* Configuration and Option Register */
#define PCMCIA_CCSR	0x02	/* Card Configuration and Status Register */
#define PCMCIA_PIR	0x04	/* Pin Replacement Register */
#define PCMCIA_SCR	0x06	/* Socket and Copy Register */

/* Now register bits, ordered by reg # */

/* For Configuration and Option Register (PCMCIA_COR) */
#define PCMCIA_MEMIO	0x01	/* Use I/O Space */
#define PCMCIA_CNFGIO	0x0e	/* I/O decoding configuration */
#define PCMCIA_LVLREQ	0x40	/* Generate level mode interrupts */
#define PCMCIA_SRESET	0x80	/* Reset Card */

/* For Card Configuration and Status Register (PCMCIA_CCSR) */
#define PCMCIA_INTR	0x02	/* Interrupt Pending */

/* For Socket and Copy Register (PCMCIA_SCR) */
#define PCMCIA_SOCKNUM	0x0f	/* Which socket I'm sitting in */
#define PCMCIA_COPNUM	0x70	/* Which instance I am. */

/*
 * CIS Tuple defines
 */

/* Define tuple types */
#define CIS_NULL	0x00	/* null tuple */
#define CIS_DEVICE	0x01	/* Device descriptor, common mem */
#define CIS_DEVICE_A	0x17	/* Device descriptor, attribute mem */
#define 	CIS_DEVICE_TYPE 	0xf0 	/* type mask */
#define		CIS_DEVICE_TYPE_SHIFT 	4	/* type offset */
#define		CIS_DEVICE_WPS		0x08	/* WPS mask */
#define		CIS_DEVICE_SPEED	0x07	/* speed mask */
#define		CIS_DEVICE_ADDRS	0xf8	/* # addr units */
#define 	CIS_DEVICE_ADDRS_SHIFT	3	/* # addr units offset */
#define		CIS_DEVICE_SIZE		0x07
#define CIS_CSUM	0x10	/* Checksum field */
#define CIS_NOLINK	0x14	/* No Link */
#define CIS_VER1	0x15	/* Level 1 Version/Product info */
#define CIS_CFG_INFO	0x1a	/* Configuration info map */
#define		TPCC_RASZ		0x03	/* size of regaddr */
#define		TPCC_RASZ_SHIFT		0
#define		TPCC_RMSZ		0x3c	/* size of regmask */
#define		TPCC_RMSZ_SHIFT		2
#define		TPCC_LAST		0x3f	/* last con entry idx */
#define		TPCC_LAST_SHIFT		0
#define CIS_CFG_ENT	0x1b	/* Configuration info entry */
#define		TPCE_INDX_ENTRY		0x3f	/* config entry # */
#define		TPCE_INDX_DEF		0x40	/* default bit */
#define		TPCE_INDX_INT		0x80	/* interface bit */
#define		TPCE_IF_TYPE		0x0f	/* interface type */
#define 	TPCE_IF_BVD		0x10	/* BVD active bit */
#define		TPCE_IF_WP		0x20	/* WP active bit */
#define		TPCE_IF_RDYBSY		0x40	/* RdyBsy active bit */
#define		TPCE_IF_MWAIT		0x80	/* Wait Sig req. bit */
#define 	TPCE_FS_PWR		0x03	/* Power */
#define			TPCE_FS_PWR_VCC		0x01	/* Vcc struct */
#define			TPCE_FS_PWR_VPP		0x02	/* Vpp struct */
#define 	TPCE_FS_TD		0x04	/* Timing */
#define			TPCE_FS_TD_WAIT		0x03	/* wait scale */
#define			TPCE_FS_TD_RDY		0x1c	/* rdy/bsy scale */
#define			TPCE_FS_TD_RDY_SHIFT	2
#define			TPCE_FS_TD_RSV		0xe0	/* reserved scale */
#define			TPCE_FS_TD_RSV_SHIFT	5
#define		TPCE_FS_IO		0x08	/* I/O Space */
#define			TPCE_FS_IO_LINES	0x1f	/* IO addr lines */
#define			TPCE_FS_IO_BUS8		0x20	/* bus 8 bit */
#define			TPCE_FS_IO_BUS16	0x40	/* bus 16 bit */
#define			TPCE_FS_IO_RANGE	0x80	/* range bit */
#define			TPCE_FS_IO_LEN		0xc0	/* block len size */
#define			TPCE_FS_IO_LEN_SHIFT	6
#define			TPCE_FS_IO_SIZE		0x30	/* block size size */
#define			TPCE_FS_IO_SIZE_SHIFT	4
#define			TPCE_FS_IO_NUM		0x0f	/* # of blocks */
#define		TPCE_FS_IRQ		0x10	/* IRQ */
#define			TPCE_FS_IRQ_SHARE	0x80	/* int sharing */
#define			TPCE_FS_IRQ_PULSE	0x40	/* pulse request */
#define			TPCE_FS_IRQ_LEVEL	0x20	/* level-trig int */
#define			TPCE_FS_IRQ_MASK	0x10	/* irq mask bit */
#define			TPCE_FS_IRQ_IRQN	0x0f	/* irqn mask */
#define			TPCE_FS_IRQ_VEND	0x08	/* vendor sig */
#define			TPCE_FS_IRQ_BERR	0x04	/* bus error */
#define			TPCE_FS_IRQ_IOCK	0x02	/* io check */
#define			TPCE_FS_IRQ_NMI		0x01	/* nmi */
#define		TPCE_FS_MEM		0x60	/* Mem Space */
#define		TPCE_FS_MEM_SHIFT	5
#define			TPCE_FS_MEM_HOST	0x80
#define			TPCE_FS_MEM_ADDR	0x60
#define			TPCE_FS_MEM_ADDR_SHIFT	5
#define			TPCE_FS_MEM_LEN		0x18
#define			TPCE_FS_MEM_LEN_SHIFT	3
#define			TPCE_FS_MEM_WINS	0x07
#define		TPCE_FS_MISC		0x80	/* Misc */
#define CIS_MFG		0x20	/* Manufacturer's ID */
#define CIS_FUNC	0x21	/* Function ID */
#define CIS_FUNE	0x22	/* Function Extension */
#define CIS_DRIVER	0x77	/* Driver ID */
#define CIS_END		0xff	/* Last Entry */

/*
 * PCIC Registers
 *     Each register is given a name, and most of the bits are named too.
 *     I should really name them all.
 * 
 *     Finally, since the banks can be addressed with a regular syntax,
 *     some macros are provided for that purpose.
 */

#define PCIC_BASE 0x03e0	/* base adddress of pcic register set */

/* First, all the registers */
#define PCIC_ID_REV	0x00	/* Identification and Revision */
#define PCIC_STATUS	0x01	/* Interface Status */
#define PCIC_POWER	0x02	/* Power and RESETDRV control */
#define PCIC_INT_GEN	0x03	/* Interrupt and General Control */
#define PCIC_STAT_CHG	0x04	/* Card Status Change */
#define PCIC_STAT_INT	0x05	/* Card Status Change Interrupt Config */
#define PCIC_ADDRWINE	0x06	/* Address Window Enable */
#define PCIC_IOCTL	0x07	/* I/O Control */
#define PCIC_IO0_STL	0x08	/* I/O Address 0 Start Low Byte */
#define PCIC_IO0_STH	0x09	/* I/O Address 0 Start High Byte */
#define PCIC_IO0_SPL	0x0a	/* I/O Address 0 Stop Low Byte */
#define PCIC_IO0_SPH	0x0b	/* I/O Address 0 Stop High Byte */
#define PCIC_IO1_STL	0x0c	/* I/O Address 1 Start Low Byte */
#define PCIC_IO1_STH	0x0d	/* I/O Address 1 Start High Byte */
#define PCIC_IO1_SPL	0x0e	/* I/O Address 1 Stop Low Byte */
#define PCIC_IO1_SPH	0x0f	/* I/O Address 1 Stop High Byte */
#define PCIC_SM0_STL	0x10	/* System Memory Address 0 Mapping Start Low Byte */
#define PCIC_SM0_STH	0x11	/* System Memory Address 0 Mapping Start High Byte */
#define PCIC_SM0_SPL	0x12	/* System Memory Address 0 Mapping Stop Low Byte */
#define PCIC_SM0_SPH	0x13	/* System Memory Address 0 Mapping Stop High Byte */
#define PCIC_CM0_L	0x14	/* Card Memory Offset Address 0 Low Byte */
#define PCIC_CM0_H	0x15	/* Card Memory Offset Address 0 High Byte */
#define PCIC_CDGC	0x16	/* Card Detect and General Control */
#define PCIC_RES17	0x17	/* Reserved */
#define PCIC_SM1_STL	0x18	/* System Memory Address 1 Mapping Start Low Byte */
#define PCIC_SM1_STH	0x19	/* System Memory Address 1 Mapping Start High Byte */
#define PCIC_SM1_SPL	0x1a	/* System Memory Address 1 Mapping Stop Low Byte */
#define PCIC_SM1_SPH	0x1b	/* System Memory Address 1 Mapping Stop High Byte */
#define PCIC_CM1_L	0x1c	/* Card Memory Offset Address 1 Low Byte */
#define PCIC_CM1_H	0x1d	/* Card Memory Offset Address 1 High Byte */
#define PCIC_RES1E	0x1e	/* Reserved */
#define PCIC_RES1F	0x1f	/* Reserved */
#define PCIC_SM2_STL	0x20	/* System Memory Address 2 Mapping Start Low Byte */
#define PCIC_SM2_STH	0x21	/* System Memory Address 2 Mapping Start High Byte */
#define PCIC_SM2_SPL	0x22	/* System Memory Address 2 Mapping Stop Low Byte */
#define PCIC_SM2_SPH	0x23	/* System Memory Address 2 Mapping Stop High Byte */
#define PCIC_CM2_L	0x24	/* Card Memory Offset Address 2 Low Byte */
#define PCIC_CM2_H	0x25	/* Card Memory Offset Address 2 High Byte */
#define PCIC_RES26	0x26	/* Reserved */
#define PCIC_RES27	0x27	/* Reserved */
#define PCIC_SM3_STL	0x28	/* System Memory Address 3 Mapping Start Low Byte */
#define PCIC_SM3_STH	0x29	/* System Memory Address 3 Mapping Start High Byte */
#define PCIC_SM3_SPL	0x2a	/* System Memory Address 3 Mapping Stop Low Byte */
#define PCIC_SM3_SPH	0x2b	/* System Memory Address 3 Mapping Stop High Byte */
#define PCIC_CM3_L	0x2c	/* Card Memory Offset Address 3 Low Byte */
#define PCIC_CM3_H	0x2d	/* Card Memory Offset Address 3 High Byte */
#define PCIC_RES2E	0x2e	/* Reserved */
#define PCIC_RES2F	0x2f	/* Reserved */
#define PCIC_SM4_STL	0x30	/* System Memory Address 4 Mapping Start Low Byte */
#define PCIC_SM4_STH	0x31	/* System Memory Address 4 Mapping Start High Byte */
#define PCIC_SM4_SPL	0x32	/* System Memory Address 4 Mapping Stop Low Byte */
#define PCIC_SM4_SPH	0x33	/* System Memory Address 4 Mapping Stop High Byte */
#define PCIC_CM4_L	0x34	/* Card Memory Offset Address 4 Low Byte */
#define PCIC_CM4_H	0x35	/* Card Memory Offset Address 4 High Byte */
#define PCIC_RES36	0x36	/* Reserved */
#define PCIC_RES37	0x37	/* Reserved */
#define PCIC_RES38	0x38	/* Reserved */
#define PCIC_RES39	0x39	/* Reserved */
#define PCIC_RES3A	0x3a	/* Reserved */
#define PCIC_RES3B	0x3b	/* Reserved */
#define PCIC_RES3C	0x3c	/* Reserved */
#define PCIC_RES3D	0x3d	/* Reserved */
#define PCIC_RES3E	0x3e	/* Reserved */
#define PCIC_RES3F	0x3f	/* Reserved */

/* Now register bits, ordered by reg # */

/* For Identification and Revision (PCIC_ID_REV) */
#define PCIC_INTEL0	0x82	/* Intel 82365SL Rev. 0; Both Memory and I/O */
#define PCIC_INTEL1	0x83	/* Intel 82365SL Rev. 1; Both Memory and I/O */
#define PCIC_IBM1	0x88	/* IBM PCIC clone; Both Memory and I/O */
#define PCIC_IBM2	0x89	/* IBM PCIC clone; Both Memory and I/O */

/* For Interface Status register (PCIC_STATUS) */
#define PCIC_VPPV	0x80	/* Vpp_valid */
#define PCIC_POW	0x40	/* PC Card power active */
#define PCIC_READY	0x20	/* Ready/~Busy */
#define PCIC_MWP	0x10	/* Memory Write Protect */
#define PCIC_CD		0x0C	/* Both card detect bits */
#define PCIC_BVD	0x03	/* Both Battery Voltage Detect bits */

/* For the Power and RESETDRV register (PCIC_POWER) */
#define PCIC_OUTENA	0x80	/* Output Enable */
#define PCIC_DISRST	0x40	/* Disable RESETDRV */
#define PCIC_APSENA	0x20	/* Auto Pwer Switch Enable */
#define PCIC_PCPWRE	0x10	/* PC Card Power Enable */

/* For the Interrupt and General Control register (PCIC_INT_GEN) */
#define PCIC_CARDTYPE	0x20	/* Card Type 0 = memory, 1 = I/O */
#define		PCIC_IOCARD	0x20
#define		PCIC_MEMCARD	0x00
#define PCIC_CARDRESET	0x40	/* Card reset 0 = Reset, 1 = Normal */

/* For the Card Status Change register (PCIC_STAT_CHG) */
#define PCIC_CDTCH	0x08	/* Card Detect Change */
#define PCIC_RDYCH	0x04	/* Ready Change */
#define PCIC_BATWRN	0x02	/* Battery Warning */
#define PCIC_BATDED	0x01	/* Battery Dead */

/* For the Address Window Enable Register (PCIC_ADDRWINE) */
#define PCIC_SM0_EN	0x01	/* Memory Window 0 Enable */
#define PCIC_SM1_EN	0x02	/* Memory Window 1 Enable */
#define PCIC_SM2_EN	0x04	/* Memory Window 2 Enable */
#define PCIC_SM3_EN	0x08	/* Memory Window 3 Enable */
#define PCIC_SM4_EN	0x10	/* Memory Window 4 Enable */
#define PCIC_MEMCS16	0x20	/* ~MEMCS16 Decode A23-A12 */
#define PCIC_IO0_EN	0x40	/* I/O Window 0 Enable */
#define PCIC_IO1_EN	0x80	/* I/O Window 1 Enable */

/* For the I/O Control Register (PCIC_IOCTL) */
#define PCIC_IO0_16BIT	0x01	/* I/O to this segment is 16 bit */
#define PCIC_IO0_CS16	0x02	/* I/O cs16 source is the card */
#define PCIC_IO0_0WS	0x04	/* zero wait states added on 8 bit cycles */
#define PCIC_IO0_WS	0x08	/* Wait states added for 16 bit cycles */
#define PCIC_IO1_16BIT	0x10	/* I/O to this segment is 16 bit */
#define PCIC_IO1_CS16	0x20	/* I/O cs16 source is the card */
#define PCIC_IO1_0WS	0x04	/* zero wait states added on 8 bit cycles */
#define PCIC_IO1_WS	0x80	/* Wait states added for 16 bit cycles */

/* For the various I/O and Memory windows */
#define PCIC_ADDR_LOW	0
#define PCIC_ADDR_HIGH	1
#define PCIC_START	0x00	/* Start of mapping region */
#define PCIC_END	0x02	/* End of mapping region */
#define PCIC_MOFF	0x04	/* Card Memory Mapping region offset */
#define PCIC_IO0	0x08	/* I/O Address 0 */
#define PCIC_IO1	0x0c	/* I/O Address 1 */
#define PCIC_SM0	0x10	/* System Memory Address 0 Mapping */
#define PCIC_SM1	0x18	/* System Memory Address 1 Mapping */
#define PCIC_SM2	0x20	/* System Memory Address 2 Mapping */
#define PCIC_SM3	0x28	/* System Memory Address 3 Mapping */
#define PCIC_SM4	0x30	/* System Memory Address 4 Mapping */

/* For System Memory Window start registers
   (PCIC_SMx|PCIC_START|PCIC_ADDR_HIGH) */
#define PCIC_ZEROWS	0x40	/* Zero wait states */
#define PCIC_DATA16	0x80	/* Data width is 16 bits */

/* For System Memory Window stop registers
   (PCIC_SMx|PCIC_END|PCIC_ADDR_HIGH) */
#define PCIC_MW0	0x40	/* Wait state bit 0 */
#define PCIC_MW1	0x80	/* Wait state bit 1 */

/* For System Memory Window offset registers
   (PCIC_SMx|PCIC_MOFF|PCIC_ADDR_HIGH) */
#define PCIC_REG	0x40	/* Attribute/Common select (why called Reg?) */
#define PCIC_WP		0x80	/* Write-protect this window */

/* For Card Detect and General Control register (PCIC_CDGC) */
#define PCIC_16_DL_INH	0x01	/* 16-bit memory delay inhibit */
#define PCIC_CNFG_RST_EN 0x02	/* configuration reset enable */
#define PCIC_GPI_EN	0x04	/* GPI Enable */
#define PCIC_GPI_TRANS	0x08	/* GPI Transition Control */
#define PCIC_CDRES_EN	0x10	/* card detect resume enable */
#define PCIC_SW_CD_INT	0x20	/* s/w card detect interrupt */

/* DON'T ADD ANYTHING AFTER THIS #endif */
#endif /* __PCMCIA_H__ */
