#!/bin/sh

DC3DD="src/dc3dd"

MD5_DIR="/home/amedico/NESSIE Test Files/MD5_Orig"
SHA1_DIR="/home/amedico/NESSIE Test Files/SHA1"

find "$MD5_DIR"/* -type f | while read f
do
        h=`"$DC3DD" if="$f" of=/dev/null hash=md5 hashconv=after 2>&1 | grep md5\ TOTAL | awk '{print $3}'`
        b=`basename "$f"`
        o=`md5sum "$f" | awk '{print $1}'`
        if [ "$h" != "$o" ]
        then 
            echo "hash mismatch for $b"
            exit 1
        fi
done

find "$SHA1_DIR"/* -type f | while read f
do
        h=`"$DC3DD" if="$f" of=/dev/null hash=sha1 hashconv=after 2>&1 | grep sha1\ TOTAL | awk '{print $3}'`
        b=`basename "$f"`
        o=`sha1sum "$f" | awk '{print $1}'`
        if [ "$h" != "$o" ]
        then
            echo "hash mismatch for $b"
            exit 2
        fi
done

