/*
   This file is part of KDE/aRts (Noatun) - xine integration
   Copyright (C) 2002 Ewald Snel <ewald@rambo.its.tudelft.nl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
*/

#ifndef __VIDEO_FIFO_OUT_H
#define __VIDEO_FIFO_OUT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <X11/Xlib.h>

typedef struct
{
    Display	*display;
    Window	 window;
    Window	 xcom_window;
    Atom	 xcom_atom;
    Atom	 xcom_resize;

    int		 width;
    int		 height;
    int		 ds_counter;
    int		 shm_completion;
} xine_arts_video;


vo_driver_t *init_video_out_plugin( config_values_t *config, xine_arts_video *video );

Pixmap vo_fifo_snapshot( xine_arts_video *video, xine_t *xine );

void vo_fifo_resize_notify( xine_arts_video *video );

#ifdef __cplusplus
}
#endif

#endif
