/* main.c: PnP config tool main module */
/*
 * $Header: /root/pnp/tools/RCS/main.c,v 1.1 1996/06/24 23:31:22 root Exp $
 *
 * $Log: main.c,v $
 * Revision 1.1  1996/06/24  23:31:22  root
 * Initial revision
 *
 *
 */

/*
 * (c) Copyright 1996  D.W.Howells <dwh@nexor.co.uk>,
 */

#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include "tools.h"

WINDOW *topwin, *listwin, *vworkwin, *workwin, *barwin, *vconfwin, *confwin,
*extrawin;
int pnpconf;

/*****************************************************************************/
/* define the handler used to catch ^C - just cleans up and exits */
void sigint(int x)
{
    clear();
    refresh();
    endwin();
    exit(0);
}

/*****************************************************************************/
/* normal banner display */
static void normal_banners()
{
    mvwprintw(topwin,0,0,
	      "  Linux PnP Configuration Utility  (c) 1996 D.W.Howells");
    wclrtoeol(topwin);
    wrefresh(topwin);

    mvwprintw(barwin,0,0,
	      "  PgUp/Dn - Prev/Next Device"
	      "  C - Configure Device"
	      "  Q - quit"
	      );
    wclrtoeol(barwin);
    wrefresh(barwin);

} /* end normal_banners() */

/*****************************************************************************/
/* main entry point */
int main()
{
    initscr(); 

    /* catch ^C */
    signal(SIGINT,sigint);

    /* set up the terminal and ncurses as I want */
    start_color();
    cbreak();
    noecho();
    nonl();
    intrflush(stdscr,FALSE);
    keypad(stdscr,TRUE);

    /* create my colour set */
    init_pair(1,COLOR_RED,COLOR_CYAN);
    init_pair(2,COLOR_WHITE,COLOR_BLUE);
    init_pair(3,COLOR_BLACK,COLOR_GREEN);
    init_pair(4,COLOR_CYAN,COLOR_BLUE);
    init_pair(5,COLOR_GREEN,COLOR_BLUE);
    init_pair(6,COLOR_YELLOW,COLOR_BLUE);

    /*=======================================================================*/
    /* create a title bar */
    topwin = newwin(1,COLS,0,0);
    if (!topwin)
	goto DONE;
    wbkgd(topwin,COLOR_PAIR(1)|' ');
    wattrset(topwin,COLOR_PAIR(1));
    wrefresh(topwin);

    /*=======================================================================*/
    /* create a list */
    listwin = newwin(LINES-2,10,1,0);
    if (!listwin)
	goto DONE;
    wbkgd(listwin,COLOR_PAIR(2)|' ');
    wattrset(listwin,COLOR_PAIR(4));
    box(listwin,0,0);
    wattrset(listwin,COLOR_PAIR(2));
    wrefresh(listwin);

    /* create a workspace holder */
    vworkwin = newwin(LINES-2,COLS-10,1,10);
    if (!vworkwin)
	goto DONE;
    wbkgd(vworkwin,COLOR_PAIR(2)|' ');
    wattrset(vworkwin,COLOR_PAIR(4));
    box(vworkwin,0,0);
    wattrset(vworkwin,COLOR_PAIR(2));
    wrefresh(vworkwin);

    /* create the workspace */
    workwin = derwin(vworkwin,LINES-4,COLS-12,1,1);
    if (!workwin)
	goto DONE;

    /*=======================================================================*/
    /* create a configuration window holder */
    vconfwin = newwin(LINES-3,COLS,1,0);
    if (!vconfwin)
	goto DONE;
    wbkgd(vconfwin,COLOR_PAIR(2)|' ');
    wattrset(vconfwin,COLOR_PAIR(4));
    box(vconfwin,0,0);
    wattrset(vconfwin,COLOR_PAIR(2));

    /* create the config window */
    confwin = derwin(vconfwin,LINES-5,COLS-2,1,1);
    if (!confwin)
	goto DONE;

    /* create a window to display extra config keypresses */
    extrawin = newwin(1,COLS,LINES-2,0);
    if (!extrawin)
	goto DONE;
    wbkgd(extrawin,COLOR_PAIR(1)|' ');
    wattrset(extrawin,COLOR_PAIR(1));
    mvwprintw(extrawin,0,0,
	      " C-L - Refresh  Q - Cancel  C-F - Force  C-T - Try");

    /*=======================================================================*/
    /* create a bar at the bottom */
    barwin = newwin(1,COLS,LINES-1,0);
    if (!barwin)
	goto DONE;
    wbkgd(barwin,COLOR_PAIR(1)|' ');
    wattrset(barwin,COLOR_PAIR(1));
    wrefresh(barwin);

    normal_banners();

    /*=======================================================================*/
    /* open the config file */
    if (geteuid()==0)
	pnpconf = open("/proc/pnpconf",O_RDWR);
    else
	pnpconf = open("/proc/pnpconf",O_RDONLY);
    if (pnpconf<0)
	goto DONE;

    read_devicelist();
    pnp_read_index();

    draw_device_list();
    info_display();

    while (1) {
	wmove(barwin,0,COLS-1);
	wrefresh(barwin);
	switch (getch()) {
	 case 'Q':
	 case 'q':
	    goto DONE;

	 case '\n':
	 case '\r':
	 case ' ':
	 case 'C':
	 case 'c':
	    if (strcmp(index_list[index_current]->pi_interface,"CARD")==0)
		break;
	    configure_device();
	    normal_banners();
	    wrefresh(listwin);
	    wrefresh(vworkwin);
	    info_display();
	    break;

	 case KEY_NPAGE:
	 case KEY_DOWN:
	 case 'N':
	 case 'n':
	    if (down_device_list())
		info_display();
	    break;

	 case KEY_PPAGE:
	 case KEY_UP:
	 case 'P':
	 case 'p':
	    if (up_device_list())
		info_display();
	    break;

	 case 12:	/* ^L */
	 case 'L':
	 case 'l':
	    touchwin(stdscr); wrefresh(stdscr);
	    touchwin(topwin); wrefresh(topwin);
	    touchwin(listwin); wrefresh(listwin);
	    touchwin(vworkwin); wrefresh(vworkwin);
	    touchwin(workwin); wrefresh(workwin);
	    touchwin(barwin); wrefresh(barwin);
	    break;
	}
    }

    /*=======================================================================*/
    /* tidy up */
 DONE:
    bkgd(COLOR_PAIR(0)|' ');
    clear();
    refresh();
    endwin();

    return 0;
} /* end main() */

/*****************************************************************************/
/* pop-up a window displaying an error message, and wait for ACK */
void popup(const char *title, const char *mesg, const char *err)
{
    WINDOW *win;

    win = newwin(10,32,(LINES-10)/2,(COLS-32)/2);
    if (!win)
	return;
    wbkgd(win,COLOR_PAIR(1)|' ');
    wattrset(win,COLOR_PAIR(1));
    box(win,0,0);

    mvwprintw(win,0,(32-strlen(title))/2,"%s",title);
    mvwprintw(win,2,(32-strlen(mesg))/2,"%s",mesg);
    mvwprintw(win,4,(32-strlen(err))/2,"%s",err);
    mvwprintw(win,8,(32-(sizeof("Press a key")-1))/2,"Press a key");

    wrefresh(win);
    getch();
} /* end popup() */
