/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.event.util;

import java.io.PrintStream;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.event.RepositoryConnectionListener;

public class DebugRepositoryConnectionListener
implements RepositoryConnectionListener {
    private boolean printing;
    private PrintStream stream;
    private boolean dumpingStack;

    public DebugRepositoryConnectionListener() {
        this(System.err);
    }

    public DebugRepositoryConnectionListener(PrintStream stream) {
        this.stream = stream;
        this.printing = stream != null;
        this.dumpingStack = false;
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public void setPrinting(boolean printing) {
        this.printing = printing;
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public void setStream(PrintStream stream) {
        this.stream = stream;
    }

    public boolean isDumpingStack() {
        return this.dumpingStack;
    }

    public void setDumpingStack(boolean dumpingStack) {
        this.dumpingStack = dumpingStack;
    }

    public void close(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("CLOSE (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void setAutoCommit(RepositoryConnection conn, boolean autoCommit) {
        if (this.printing) {
            this.stream.println("SETAUTOCOMMIT (" + this.getConnectionID(conn) + ") " + autoCommit);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void commit(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("COMMIT (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void rollback(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("ROLLBACK (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void add(RepositoryConnection conn, Resource subject, URI predicate, Value object, Resource ... contexts) {
        if (this.printing) {
            this.stream.println("ADD (" + this.getConnectionID(conn) + ") " + subject + ", " + predicate + ", " + object + ", " + contexts);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void remove(RepositoryConnection conn, Resource subject, URI predicate, Value object, Resource ... contexts) {
        if (this.printing) {
            this.stream.println("REMOVE (" + this.getConnectionID(conn) + ") " + subject + ", " + predicate + ", " + object + ", " + contexts);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void clear(RepositoryConnection conn, Resource ... contexts) {
        if (this.printing) {
            this.stream.println("CLEAR (" + this.getConnectionID(conn) + ") " + contexts);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void setNamespace(RepositoryConnection conn, String prefix, String name) {
        if (this.printing) {
            this.stream.println("SETNAMESPACE  (" + this.getConnectionID(conn) + ") " + prefix + ", " + name);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void removeNamespace(RepositoryConnection conn, String prefix) {
        if (this.printing) {
            this.stream.println("REMOVENAMESPACE (" + this.getConnectionID(conn) + ") " + prefix);
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    public void clearNamespaces(RepositoryConnection conn) {
        if (this.printing) {
            this.stream.println("CLEARNAMESPACES (" + this.getConnectionID(conn) + ")");
        }
        if (this.dumpingStack) {
            Thread.dumpStack();
        }
    }

    protected String getConnectionID(RepositoryConnection conn) {
        int maxLength;
        String id = conn.toString();
        int length = id.length();
        return length <= (maxLength = 20) ? id : "..." + id.substring(length - maxLength);
    }
}

