		/* parser for xygraf strings */

#define YES	1
#define NO	0
#define NOFONT	0
#define ROMAN	1
#define SYMBOL  2
#define PLOT 	3
#define RF	"sr"
#define SF	"ss"
#define PF	"sp"
#define HB	" mk dr (\\305) sr ju rt (h) sr"
#define LB	" mk dr (\\305) sr ju rt (l) ss"
#define LI	" mk (\\362) ss rt dr (\\260) ss ju"

#include <stdio.h>
#include <ctype.h>
#include <string.h>


static char Name[30];
static char *out;
static int oi;
static int currentfont;


parse(output,input)
char *output,*input;
{
	extern char *out;
	extern int currentfont;

	int i,j,font;
	char p[3],code,*in;

	in=input;
	i=0; currentfont=NOFONT;initialize(output);
	outchar('{');
	while( in[i]!='\0' ) {
	  if(in[i]=='\\') {
		++i;
		if(in[i]=='\\') {
			addchar(ROMAN,'\\');
			++i;
		} else if (in[i]=='\"') {
			addchar(ROMAN,'\"');
			++i;
		} else {
			getpair(p,in+i);
			i += 2;
			if ( !special(p) ) {
				if(!getcode(p,&font,&code)) {
				   font=ROMAN;
				   code='?';
				} 
				addchar(font,code);
			}
		}
	  } else {
		addchar(ROMAN,in[i]);
		++i;
	  }
	}

	closefont();
	stick(out," }");
}

initialize(sa)
char sa[];
{
	extern int oi;
	extern char *out;

	out = sa ;
	oi=0;
	out[0]='\0';
}

outchar(c)
int c;
{
	extern char *out;
	extern int oi;

	out[oi++]=c;
	out[oi]='\0';
}

stick(out,c)
char out[],*c;
{
	extern int oi;
	int i;

	i=0;
	while( c[i]!='\0' ) out[oi++]=c[i++];  
	out[oi]='\0';
}
	

special(p)
char p[];
{
	int eq();

	if( eq(p,"mk") ) {
		closefont();
		stick(out," mk");
		return(YES);
	} else if( eq(p,"rt") ) {
		closefont();
		stick(out," rt");
		return(YES);
	} else if( eq(p,"sp") ) {
		closefont();
		stick(out," su");
		return(YES);
	} else if( eq(p,"ep") ) {
		closefont();
		stick(out," eu");
		return(YES);
	} else if( eq(p,"sb") ) {
		closefont();
		stick(out," sd");
		return(YES);
	} else if( eq(p,"eb") ) {
		closefont();
		stick(out," ed");
		return(YES);
	} else if( eq(p,"hb") ) {
		closefont();
		stick(out,HB);
		return(YES);
	} else if( eq(p,"lb") ) {
		closefont();
		stick(out,LB);
		return(YES);
	} else if( eq(p,"li") ) {
		closefont();
		stick(out,LI);
		return(YES);
	} else 
		return(NO);
}

addchar(font,c)
int font;
char c;
{
	extern char *out;
	char s[10];
	int i;

	chgfont(font);

	if (c=='\\') 
		stick(out,"\\\\");
	else if (c=='\"')
		stick(out,"\"");
	else if (c=='(')
		stick(out,"\\(");
	else if (c==')')
		stick(out,"\\)");
	else if (isascii(c) && isprint(c)) {
		outchar(c);
	} else {
		otos(s,c);
		stick(out,s);
	}
}

closefont()
{
	chgfont(NOFONT);
}

chgfont(font)
int font;
{
	extern int currentfont;
	extern char *out,Name[];

	if(currentfont==font) {
		/* do nothing early */
	} else if (currentfont!= NOFONT) {
		stick(out,")");
		switch (currentfont) {
		  case ROMAN : 	stick(out,RF);
				break;
		  case SYMBOL :	stick(out,SF);
				break;
		  case PLOT :	stick(out,PF);
				break;
		  default :	fprintf(stderr,"%s: Unexpected font\n",Name);
				exit(-1);
		}
	}


	if(font != NOFONT && font != currentfont ) {
		stick(out," (");
	}
	currentfont=font;
}

getpair(p,in)
char p[],*in;
{
	p[0]=in[0];
	p[1]=in[1];
	p[2]='\0';
}

otos(s,x)
char *s;
int x;
/* writes in s the octal representation of x */
/* some strange machine dependence here */
{
	if ( x < 0 )  x += 256 ;   /* oops */
	sprintf(s,"\\%03o",x);
}
