;; xyplot.el
;; emacs lisp code for viewing xyplot files
(defvar xyplot-view-script "graf" "Script for viewing xyplot files")

(defvar xyplot-mode-map nil "Keymap for xyplot mode")
(setq xyplot-mode-map (make-sparse-keymap))
(define-key xyplot-mode-map [f3] 'view-xyplot-buffer)

(defun xyplot-mode ()
  "Major mode for xyplot files"
  (interactive)
  (kill-all-local-variables)
  (use-local-map xyplot-mode-map)
  (setq local-abbrev-table text-mode-abbrev-table)
  (make-local-variable 'xyplot-command)
  (setq mode-name "xyplot")
  (setq major-mode 'xyplot-mode)
  (setq xyplot-command "xyplot")
  )

(defun view-xyplot-buffer ()
  "run xyplot on the current buffer, 
   then display the plot on the screen using
   the script xyplot-view-script"
  (interactive)
  (view-xyplot-region (point-min) (point-max)))

(defun view-xyplot-region (beg end)
  "run xyplot on the current region"
  (interactive "r")
  (call-process-region beg end xyplot-view-script nil 0 nil)
  (message "called xyplot"))
