#!/bin/sh


#/*P:cxite*
#
#________________________________________________________________
#
#		cxite
#________________________________________________________________
#
#Name:		cxite - Compile and link XITE-dependent source code
#
#Syntax:	cxite [<option>...] [<cc-option>...] <sourcefile>
#
#Description:	This program is used to compile and link sourcefiles which use
#               functions and definitions from XITE (X-based Image Processing
#               Tools and Environment).
#
#               You don''t need to specify where the XITE header files and
#		library are.
#
#Options:	&-c
#               Compile only
#		&-cx
#	        Compile only. The program uses X11 functions.
#		&-g
#	        Prepare for debugging, turn off optimization.
#		&-gnu
#	        Use GNU gcc instead of cc.
#		&-gw
#	        If using gcc, then add lots of gcc warning options.
#		&-h(elp)
#		Write a usage message and explain the purpose of this program.
#		&-I<dir>
#		Add '<dir>' to the list of directories in which to search for
#		#include files.
#		&-L<dir>
#		Add '<dir>' to the list of directories to be searched for
#		object libraries specified by '-l<lib>'.
#		&-l<lib>
#		Search a standard list of directories for the object
#		library given by '<lib>', and link with this library.
#		&-o <file>
#		The name of the file where the compiled and linked result is
#		placed.
#		&-q
#	        Be quiet, don''t echo the command used.
#		&-x
#	        Compile and link with various X11 libraries in addition
#		to the XITE library.
#		-&and '<cc-option>' is
#		&-cc <string>
#		where '<string>' is passed unchanged as option(s) to the
#		compiler/linker.
#
#Author:	Svein Be, Ifi, UiO (svein@ifi.uio.no)
#Id: 		$Id: cxite.sh,v 1.19 1997/09/02 15:29:45 svein Exp $
#________________________________________________________________
#
#*/

if test -f /usr/5bin/echo; then
   echo=/usr/5bin/echo
elif test -f /usr/bin/echo; then
   echo=/usr/bin/echo
else
   echo=echo
fi

progName=`basename $0`

usage="Usage: $progName [<option>...] [<cc-option>...] <sourcefile> \n\
where <option> is one of \n\
	-c        : Compile only. \n\
	-cx       : Compile only. The program uses X11 functions. \n\
	-g        : Prepare for debugging, turn off optimization. \n\
	-gnu      : Use GNU gcc instead of cc. \n\
	-gw       : If using gcc, then add lots of gcc warning options. \n\
	-I<dir>   : Add <dir> to the list of directories in which to search \n\
	            for #include files. \n\
	-L<dir>   : Add <dir> to the list of directories to be searched for \n\
	            object libraries specified by -l<lib>. \n\
	-l<lib>   : Search a standard list of directories for the object \n\
	            library given by <lib>, and link with this library. \n\
	-o <file> : The name of the file where the compiled and linked \n\
	            result is placed. \n\
	-q        : Be quiet, don't echo the command used. \n\
	-x        : Compile and link with various X11 libraries in addition \n\
	            to the XITE library. \n\
and <cc-option> is \n\
	-cc <string> \n\
where <string> is passed unchanged as option(s) to the compiler/linker."

eval `xiteStdOpt 1 -1 $progName $@ "$usage"`

# This is where the install script automatically inserts the XITE home
# directory path.
if [ -z "$XITE_HOME" ]; then
  XITE_HOME=
fi

if [ -z "$XITE_HOME" ]
then

cat <<EOF 1>&2
$progName error: The XITE home directory is not known. Set the environment
variable XITE_HOME to the XITE home directory or ask your local XITE
administrator to edit this script.  The	environment variable is set to
dir in csh or tcsh by the command 'setenv XITE_HOME dir' or in sh by the
command	'XITE_HOME=dir;export XITE_HOME'.
EOF

  exit 1
fi

# Default values
getPlatform=$XITE_HOME/etc/.install/getPlatform
xite_hosttype_def=`$getPlatform "" $XITE_HOME/etc/.install stderr 1`
xite_inc_dest_def=$XITE_HOME/include
xite_lib_dest_def=$XITE_HOME/lib/$xite_hosttype_def
x_inc_dir_def=/usr/include
x_lib_dir_def=/usr/lib

# This is where the install script or the local XITE administrator may
# hardcode the platform type, especially if the platform type is different
# from the standard ones recognized by the script
# $XITE_HOME/etc/.install/getPlatform.
if [ -z "$XITE_HOSTTYPE" ]; then
  XITE_HOSTTYPE=
fi

if [ -z "$XITE_HOSTTYPE" ]; then
  # Assume default platform type, if not hardcoded above or in the environment.
  XITE_HOSTTYPE="$xite_hosttype_def"
fi

if [ -z "$XITE_HOSTTYPE" ]; then
  # Still don't know the platform type, which is needed for a compile option.

cat <<EOF 1>&2
$progName error: The computer platform type could not be determined.
Ask your XITE administrator to edit this script or the scripts it depends on.
EOF

  exit 1
fi

# Update default value depending on XITE_HOSTTYPE.
xite_lib_dest_def=$XITE_HOME/lib/$XITE_HOSTTYPE

# This is where the install script automatically inserts the XITE include
# directory path.
if test -z "$XITE_INC_DEST"
then
  XITE_INC_DEST=
fi

if test -z "$XITE_INC_DEST"
then
  # Assume default XITE include directory path, if not hardcoded above
  # or in the environment.
  XITE_INC_DEST="$xite_inc_dest_def"
fi

# This is where the install script automatically inserts the XITE library
# directory path.
if test -z "$XITE_LIB_DEST"
then
  XITE_LIB_DEST=
fi

if test -z "$XITE_LIB_DEST"
then
  # Assume default XITE library directory path, if not hardcoded above
  # or in the environment.
  XITE_LIB_DEST="$xite_lib_dest_def"
fi

# This is where the install script automatically inserts the X include
# directory path.
if test -z "$X_INC_DIR"
then
  X_INC_DIR=
fi

if test -z "$X_INC_DIR"
then
  # Assume default X include directory path, if not hardcoded above
  # or in the environment.
  X_INC_DIR="$x_inc_dir_def"
fi

# This is where the install script automatically inserts the X library
# directory path.
if test -z "$X_LIB_DIR"
then
  X_LIB_DIR=
fi

if test -z "$X_LIB_DIR"
then
  # Assume default X library directory path, if not hardcoded above
  # or in the environment.
  X_LIB_DIR="$x_lib_dir_def"
fi

c=""; ccOpt=""; sourceFile=""; comp="cc"; outFile=""; x=0; xInc="";
xL=""; xl=""; q=0; g=""; w=0; warn=""; usage=0; help=0; libs=""; libDirs=""
incDirs=""; optim=""; xiteX="";

while [ $# -gt 0 ]; do
  case $1 in
    -c) c=$1; shift;;
    -cx) c="-c"; x=1; shift;;
    -g) g=$1; shift;;
    -gnu) comp="gcc"; shift;;
    -gw) w=1; shift;;
    -cc)
	if [ $# -eq 1 ]; then
	  $echo "$progName error: Missing argument for option $1." 1>&2
	  usage=1;
	fi
	shift;
	if [ -z "$ccOpt" ]; then
	  ccOpt="$1"
	else
	  ccOpt="$ccOpt $1"
	fi
	shift;;
    -I*)
	if [ -z "$incDirs" ]; then
	  incDirs="$1"
	else
	  incDirs="$incDirs $1"
	fi
	shift;;
    -L*)
	if [ -z "$libDirs" ]; then
	  libDirs="$1"
	else
	  libDirs="$libDirs $1"
	fi
	shift;;
    -l*) 
	if [ -z "$libs" ]; then
	  libs="$1"
	else
	  libs="$libs $1"
	fi
	shift;;
    -o) 
	if [ $# -eq 1 ]; then
	  $echo "$progName error: Missing argument for option $1." 1>&2
	  usage=1;
	fi
	shift;
	if [ -n "$outFile" ]; then
	  $echo "$progName error: Option -o should only be used once." 1>&2
	  usage=1;
	fi
	outFile=$1
	shift;;
    -q) q=1; shift;;
    -x) x=1; shift;;
    -*) $echo "$progName error: Unknown option $1." 1>&2
	shift; usage=1;;
    *)  if [ -z "$sourceFile" ]; then
	  sourceFile=$1
	else
	  sourceFile="$sourceFile $1"
	fi
	shift;;
  esac
done

if [ -z "$g" ]; then
  optim="-O"
fi

if [ -n "$outFile" ]; then
  outFile="-o $outFile"
fi

if [ "$x" -eq 1 ]; then
  # Software needs X Window System
  xInc="-I$X_INC_DIR"
  if  [ -z "$c" ]; then
    xL="-L$X_LIB_DIR"
    xl="-lfwf -lxpm -lXaw -lXmu -lXt -lXext -lX11"
    xiteX="-lxiteX"
  fi
fi

if [ "$comp" = "gcc" -a "$w" -eq 1 ]; then
  warn="-Wall -Wmissing-prototypes -Wstrict-prototypes -Wtraditional"
  warn="$warn -Wconversion -Wnested-externs -Wpointer-arith"
elif [ "$comp" != "gcc" -a "$w" -eq 1 ]; then
  $echo "$progName warning: gcc warnings not used (option '-gw') because gcc is not used." \
    1>&2
fi

if [ "$c" = "-c" ]; then
  command="$comp $c $g $optim -D$XITE_HOSTTYPE $ccOpt $warn"
  command="$command -I$XITE_INC_DEST $xInc $incDirs $outFile $sourceFile"
else
  command="$comp $g $optim -DMAIN -D$XITE_HOSTTYPE $ccOpt $warn"
  command="$command -I$XITE_INC_DEST $xInc $incDirs -L$XITE_LIB_DEST $xL"
  command="$command $libDirs $outFile $sourceFile $libs $xiteX -lxite $xl -lm"
fi

if [ "$q" -eq 0 ]; then
  $echo "$command"
fi

eval "$command"

