/*
 * hipstosun.c - convert a single hips image to Sun format
 *
 * usage:	hipstosun < in > out
 *
 * hipstosun converts a hips image to Sun format.  Only a single frame
 * sequence is permitted, either in byte format or in single-bit-per-pixel
 * bit-packed format.
 *
 * to compile:	cc -o hipstosun hipstosun.c -lhips -lpixrect
 *
 * Mike Landy - 6/12/87
 *
 * input image width (cols) must be divisable by 8. Added check
 *   and error message if this is not the case.  -Brian Tierney,  LBL  10/90
 */

#include <stdio.h>
#include <hipl_format.h>
#include <pixrect/pixrect_hs.h>
char     *Progname;

main(argc, argv)
    int       argc;
    char    **argv;

{
    register int i, r;
    register char *p;
    char     *base;
    struct pixrect *image;
    colormap_t colormap;
    int       nrows, ncols, bpacked, icb, ocb, cmapl;
    unsigned char *red, *green, *blue;
    struct header hd;

    Progname = strsave(*argv);
    read_header(&hd);
    nrows = hd.rows;
    ncols = hd.cols;
    if (hd.pixel_format != PFBYTE)
	perr("pixel format must be bytes");
    if (hd.num_frame != 1)
	perr("number of frames must be 1");

    if (ncols % 8 != 0) {
	fprintf(stderr, "Error: image width must be divisable by 8 \n");
	exit(-1);
    }

    bpacked = 0;
#ifdef MSBFVERSION
    if (hd.bit_packing == LSBFIRST)
	perr("bit packing must be MSBFIRST");
    else if (hd.bit_packing == MSBFIRST)
	bpacked++;
#else
    if (hd.bit_packing == MSBFIRST)
	perr("bit packing must be LSBFIRST");
    else if (hd.bit_packing == LSBFIRST)
	bpacked++;
#endif	/* MSBFVERSION */
    if ((image = mem_create(ncols, nrows, bpacked ? 1 : 8)) == NULL)
	perr("can't create pixrect");
    icb = bpacked ? ((ncols + 7) / 8) : ncols;
    ocb = (icb + 1) & ~1;
    base = (char *) mpr_d(image)->md_image;
    if (icb == ocb) {
	if (pread(0, base, nrows * icb * sizeof(char)) !=
	    nrows * icb * sizeof(char))
	    perr("error during read");
    } else {
	p = base;
	for (r = 0; r < nrows; r++) {
	    if (pread(0, p, icb * sizeof(char)) != icb * sizeof(char))
		perr("error during read");
	    p += ocb;
	}
    }
    colormap.type = RMT_EQUAL_RGB;
    cmapl = bpacked ? 2 : 256;
    colormap.length = cmapl;
    red = colormap.map[0] =
	(unsigned char *) calloc(cmapl, sizeof(unsigned char));
    green = colormap.map[1] =
	(unsigned char *) calloc(cmapl, sizeof(unsigned char));
    blue = colormap.map[2] =
	(unsigned char *) calloc(cmapl, sizeof(unsigned char));
    if (red == 0 || green == 0 || blue == 0)
	perr("can't allocate colormap");
    if (bpacked) {
	*red++ = *green++ = *blue++ = 0;
	*red++ = *green++ = *blue++ = 255;
    } else {
	for (i = 0; i < 256; i++)
	    *red++ = *green++ = *blue++ = i;
    }

    if (pr_dump(image, stdout, &colormap, RT_STANDARD, 0) == PIX_ERR) {
	fprintf(stderr, "hipstosun: ");
	perror("pr_dump");
	exit(1);
    }
    exit(0);
}
