#include "extern.h"

getbdry()
/* get the mouse-drawn boundary.
The region is determined by a finite number of mouse-drawn closed loops */
{
	int			mousex, mousey, oldx, oldy, button1down;
	int			firstx, firsty, mymask;
	Region			myregionhole;
	XPoint			mypoint[500], *pointptr;
	int			numpoints, numregions;
	XEvent			myevent;

	XSetLineAttributes(dpy, gc, 1, LineSolid, CapNotLast, JoinMiter);
	printf ("Draw the boundary of the region.\n");
	printf ("Mouse Button1 DRAWS.\n");
	printf ("Mouse Button2 ERASES.\n");
	printf("Mouse Button3 PROCEEDS.\n");
	XDefineCursor(dpy, domainwin, XCreateFontCursor(dpy,XC_pencil));

	/* Loop to get the region as drawn by the mouse */
	StartDrawingLoop:;
	mymask = (ButtonPressMask | ButtonReleaseMask | ButtonMotionMask);
	normRgn = 0;

	/* Initialize the bounding rectangle of the border */
	xmin = ymin = 9999;
	xmax = ymax = 0;

	oldx = -9999;
	button1down = FALSE;
	pointptr = mypoint;	numpoints = 0; numregions = 0;
    	XSelectInput(dpy, domainwin, mymask);
    	while(1)	{
		XNextEvent(dpy, &myevent);
		/* allow motion draws after button1 is down */
		if ((myevent.type == ButtonPress) && (myevent.xbutton.button == 1))	{
			XSelectInput(dpy, domainwin, (mymask | PointerMotionMask));
			button1down = TRUE;
		}
		else
		if (button1down && (myevent.type == MotionNotify )) {
		/* User is drawing with button 1 down */

			/* Get the mouse coordinates */
			mousex = myevent.xmotion.x;
			mousey = myevent.xmotion.y;

			/* Store mouse points in myRgnPoint */
			myRgnPoint[normRgn].x = mousex;
			myRgnPoint[normRgn].y = mousey;
			++normRgn;
			pointptr->x = mousex;
			pointptr->y = mousey;
			pointptr++;	numpoints++;

			/* Check memory */
			if (numpoints > 499)	{
				fprintf (stderr, "The memory allocation for the array mypoint[] has been exceeded.\n");
				exit(1);
			}
			if(oldx<0) {
			/* Starting a new loop */
				firstx = mousex;
				firsty = mousey;
	    			XDrawLine(dpy, domainwin, gc, mousex, mousey,	 mousex	, mousey);
				oldx = mousex;
				oldy = mousey;
			}
			else	{
			/* continuing drawing */
	    			XDrawLine(dpy, domainwin, gc, oldx, oldy,  mousex, mousey);
				oldx = mousex;
				oldy = mousey;
			}
			/* Update bounding rectangle */
			if (xmin > mousex)	xmin = mousex;
			if (ymin > mousey)	ymin = mousey;
			if (xmax < mousex)	xmax = mousex;
			if (ymax < mousey)	ymax = mousey;
		}
		else
		/* complete curve when button1 released */
		if ((myevent.type == ButtonRelease) && (myevent.xbutton.button == 1)) {
    			XSelectInput(dpy, domainwin, mymask);

			/* Close loop */
			myRgnPoint[normRgn].x = firstx;
			myRgnPoint[normRgn].y = firsty;
			++normRgn;

			/* Negative entries in myRgnPoint flag the end of one loop and the beginning of the next loop */
			myRgnPoint[normRgn].x = -1;
			myRgnPoint[normRgn].y = -1;
			++normRgn;
			pointptr->x = firstx;
			pointptr->y = firsty;
			pointptr++;	numpoints++;
			button1down = FALSE;

			/* Draw the closing line segment */
	    		XDrawLine(dpy, domainwin, gc, mousex, mousey, firstx, firsty);
			oldx = -9999;
			if (numregions == 0)	{	/* first region */
				/* initialize region determined by the mouse-drawn curves */
				myRegion = XPolygonRegion(mypoint, numpoints, EvenOddRule);
				pointptr = mypoint;
				numpoints = 0;
				numregions++;
			}	
			else {	/* it's a hole */
				/* Subtract hole region from first region */
				myregionhole = XPolygonRegion(mypoint, numpoints, EvenOddRule);
				XSubtractRegion(myRegion, myregionhole, myRegion);
				pointptr = mypoint;
				numpoints = 0;
				numregions++;
			}
		}
		else
		/* Erase on button2 press */
		if ((myevent.type == ButtonPress) && (myevent.xbutton.button == 2)) 	{
			XClearWindow(dpy, domainwin);
			goto StartDrawingLoop;
		}
		else
		/* Exit drawing on button3 press*/
		if ((myevent.type == ButtonPress) && (myevent.xbutton.button == 3)) 	
			break;
 	}
	XSetLineAttributes(dpy, gc, 2, LineSolid, CapNotLast, JoinMiter);
	XDefineCursor(dpy, domainwin, XCreateFontCursor(dpy, XC_draft_small));
} /*getbdry*/


Bool	goodbdry()
/* Return TRUE if the mesh of the circle domain is fine enough */
{
	int		mynbrs[6], mypos[6][2], i, j, n, mystate, statecount;
	Bool		answer;
	
	answer = TRUE;
	for (i=1; i<height-1; ++i) {
		for (j=1;j<width-1; ++j) {
			mystate = DCirc[j+i*width].state;
			if (mystate >= OUTERBDRY)	{
			/* Check certain technical requirements on the boundary circle cycles */
				getccindices(i, j, mypos);
				for (n=0; n<NUMNBRS; ++n)	
					mynbrs[n] = DCirc[mypos[n][1]+mypos[n][0]*width].state;
				statecount = 0;
				for (n=0; n<NUMNBRS; ++n)	{
					if  ((mynbrs[n] == OUTSIDE) 
					|| (mynbrs[n] == INTERIOR)
					|| (mynbrs[n] == mystate))	{
						 if (mynbrs[n] == mystate)	++statecount;
					}
					else	{
					/* Cannot have inner boundary cycles touching outer boundary cycles */
						answer = FALSE;
						goto	badbdry;
					}
				} 
				if (statecount >= 3)	{
				/* Cannot have a boundary circle with more than two boundary neighbors */
					answer = FALSE;
					goto	badbdry;
				} 
			} 
		} 
	} 
	badbdry:	
		return (answer);
} /*goodbdry*/


docycle(a, b, bdrystate)
/* Given a cycle of circles starting at the (a,b) entry of DCirc and having the same state oldstate, this function
changes the state of all circles in this cycle to bdrystate */
int	a, b, bdrystate;
{
	int	i, j, count, state[6], pos[6][2], cyclelength, oldstate;
	Bool	cycling, searching;
	
	oldstate = DCirc[b+a*width].state;	/* present state of all circles in the cycle */
	DCirc[b+a*width].state = bdrystate;
	i = a;
	j = b;
	cyclelength = 1;
	cycling = TRUE;
	do {
		getccindices(i, j, pos);
		for (count=0; count<NUMNBRS; ++count)	
			state[count] = DCirc[pos[count][1]+pos[count][0]*width].state;
		count = 0;
		searching = TRUE;
		do {
			if (count == NUMNBRS)	{	/* cycle has been completely traversed */
				cycling = FALSE;
				break;
			}
			else	{		/* Check for a neighbor whose state needs to be changed */
				if (state[count] == oldstate)	{
					searching = FALSE;
					i = pos[count][0];
					j = pos[count][1];
					DCirc[j+i*width].state = bdrystate;
					++cyclelength;
				}
			}
		++count;
		}	while (searching);
		if (bdrystate >= INNERBDRY)	/* Store length of this inner boundary cycle */
			DHole [bdrystate-INNERBDRY].state = cyclelength;
	}	while (cycling);
} /*docycle*/

