#include "extern.h"

/* The following functions compute circle centers */

findcenters ()
/* given the radii in RCirc, find the centers of the circles */
{
	Bool		notcycled, notplotted, moretoplot;
	double  	u1, v1, u2, v2, phi0, phi1, phi2, r0, r1, r2;
	int 		a, b, h, i, j, k, c, m, n, s[6],  t[6], pos1[6][2], pos2[6][2];
	int		alpha, indx, stupidcount;
	
	double		capa, capb, capc, capu, capv, capw, phi01, phi02, phi12;
	double		r0r0, r1r1, r2r2, r0r1, r0r2, r1r2, t01, t02, t12, targ;
	int		cnum0, cnum1, cnum2;
	

	/* copy domain info to range info */
	for (i=0; i<hw; ++i) 
		RCirc[i] = DCirc[i];

	/* plot the two lower right circles */
	indx = fixradj+fixradi*width;
	RCirc[indx].x = RCirc[indx].y = 0.0;
	RCirc[indx].state = RCirc[indx-1].state = PLOTTED;
	RCirc[indx-1].y = 0.0;
	
	if (packingmode == TANGENTMODE)	{
		RCirc[indx-1].x = -RCirc[indx].r - RCirc[indx-1].r;
	}
	else	{
	/* Circles might intersect */
		r0 = RCirc[indx-1].r;
		r1 = RCirc[indx].r;
		cnum0 = DCirc[indx-1].cnum;
		cnum1 = DCirc[indx].cnum;
		phi01 = getxangle(cnum0, cnum1);
		r0r0 = r0*r0;
		r1r1 = r1*r1;
		r0r1 = r0*r1;
		t01 = cos(phi01);
		RCirc[indx-1].x = -sqrt(r0r0 + r1r1 + 2.0*r0r1*t01);
	}


	moretoplot = TRUE;
	while (moretoplot)	{
	/* loop through and plot neighbors of circles already plotted */
		for (i=height-1; i>=0; --i) {
			for (j=width-1; j>=0; --j) {
				indx = j+i*width;
				if (RCirc[indx].state == PLOTTED) {
				/* Check neighboring circles both clockwise and counterclockwise */
					for (h=0; h<2; ++h) {
						if (h%2 == 0)	 getccindices (i, j, pos1);
						else	 getcindices (i, j, pos1);

						/* Store neighboring radii */
						for (n=0; n<6; ++n)	
							s[n] = RCirc [ pos1[n][1]+pos1[n][0]*width ].state;
						notcycled = notplotted = TRUE;
						k = 0;

						/* check whether neighbors need plotting */
						while (notplotted) {
							if ((s[k] == PLOTTED) 
							&& (s[(k+1)%6] > PLOTTED)) {
							/* Yes, can plot here */
								notplotted = FALSE;
								for (c=0; c<6; ++c) {
									t[c] = s[(k+c)%6];
									pos2[c][0] = pos1[(k+c)%6][0];
									pos2[c][1] = pos1[(k+c)%6][1];
								} 
								break;
							} 
							else {
								if (k<6)	++k;
								else 	notplotted = notcycled = FALSE;
							}
						} 
		
						if (notcycled) {
						/* yes, plot neighbors */
							r0 = RCirc[indx].r;
							cnum0 = DCirc[indx].cnum;
							phi2 = 0;
			 				k = 1;
							notplotted = TRUE;
							while (notplotted) {
							/* Find number of neighbors that need to be plotted */
								if (t[k] > PLOTTED) 	++k;
								else {
									m = k;
									notplotted = FALSE;
									break;
								} 
							}
							u1 = RCirc[indx].x;
							v1 = RCirc[indx].y;
							u2 = RCirc[pos2[0][1]+pos2[0][0]*width].x;
							v2 = RCirc[pos2[0][1]+pos2[0][0]*width].y;
							/* Base angle for plotting */
							phi1 = atan2(v2-v1, u2-u1);
							
							for (k=1; k<m; ++k) {
								a = pos2[k-1][1]+pos2[k-1][0]*width;
								b = pos2[k][1]+pos2[k][0]*width;
								r1 = RCirc[a].r;
								r2 = RCirc[b].r;

								if ((packingmode == SECTMODE)	
								&& (DCirc[indx].state > DEEPINSIDE))	{
									/* Compute triangle of centers for circles 
									intersecting at prescribed angles */
									cnum1 = DCirc[a].cnum;
									cnum2 = DCirc[b].cnum;
									phi01 = getxangle(cnum0, cnum1);
									phi02 = getxangle(cnum0, cnum2);
									phi12 = getxangle(cnum1, cnum2);
									r0r0 = r0*r0;
									r1r1 = r1*r1;
									r2r2 = r2*r2;
									r0r1 = r0*r1;
									r0r2 = r0*r2;
									r1r2 = r1*r2;
									t01 = cos(phi01);
									t02 = cos(phi02);
									t12 = cos(phi12);
									capw = r0r0 + r0r1*t01 + r0r2*t02 - r1r2*t12;
									capu = r0r0 + r1r1 + 2.0*r0r1*t01;
									capv = r0r0 + r2r2 + 2.0*r0r2*t02;
									capb = sqrt(capv);
									targ = capw/sqrt(capu*capv);
									phi2 = acos(targ);
								}
								else	{
								/* circles are tangent */
  									phi2 = acos (1.0-2.0*r1*r2/((r0+r1)*(r0+r2)));
									capb = r0+r2;
								}
								if (h%2 == 0)	phi1 += phi2;
								else	phi1 -= phi2;
								/* Assign plotted coordinates */
								RCirc[b].x = u1+capb*cos(phi1) ;
								RCirc[b].y = v1+capb*sin(phi1);
								RCirc[b].state = PLOTTED;
							} 
						} 
					} 
				} 
			} /*for j*/ 
		} /*for i*/

		/* check whether any circles were missed */
		moretoplot = FALSE;
		for (i=hw; i>=0; --i) {
			if (RCirc[i].state > PLOTTED) 
			/* Found more unplotted circles */
				moretoplot = TRUE;
		}
	} /*while*/
} /* findcenters */ 


scalecircs (mycirc, factor)	/* Scale circles of mycirc by factor. */
circleinfo	*mycirc;
double		factor;
{
	int 		i;
	
	for (i=0; i<numcircles; ++i) 	{
		RCirc[circindex[i]].x *= factor;
		RCirc[circindex[i]].y *= factor;
		RCirc[circindex[i]].r *= factor;
	}
} /*scalecircs*/


translate (mycirc, a, b)
/* Translate coordinates of mycirc by (a, b).	*/
circleinfo		*mycirc;
double			a, b;
{
	int 		i;	
	
	for (i=0; i<numcircles; ++i) {
		mycirc[circindex[i]].x += a;
		mycirc[circindex[i]].y += b;
	}
} /*translate*/


twist (a, b)		
/* Rotate the range packing so the point (a, b) 
lies on the positive real axis. */
double		a, b;	
{
	double 			u, v, norm, theta, temp;
	int 			i;
	
	if ((a!=0) || (b!=0))	{
		theta = atan2(b, a);	/* Rotation angle */
		for (i=0; i<numcircles; ++i) {
			u = RCirc[circindex[i]].x;
			v = RCirc[circindex[i]].y;
			if ((u!=0) || (v!=0))	{
				norm = sqrt(u*u+v*v);
				temp =  atan2(v, u)-theta;
				RCirc[circindex[i]].x = norm*cos(temp);
				RCirc[circindex[i]].y = norm*sin(temp);
			}
		}
	}
} /*twist*/

