#include "extern.h"
	
/* These functions do stupid bookkeeping tasks */

doindexing()	 {
/* Index the cnum circle flags */
	int	i, vcount, bcount;

	/* Index the circles in the packing */
	bcount = N = 0;
	for (i=0; i<hw; ++i)	{
		if ((DCirc[i].state == INTERIOR)
		|| (DCirc[i].state == DEEPINSIDE))	{
		/* This circle has positive cnum and variable radius */
			DCirc[i].cnum = N+1;
			++N;
		}
		else	if (DCirc[i].state == OUTERBDRY)	{
		/* This circle has negative cnum and fixed radius */
			DCirc[i].cnum = -(bcount+1);
			++bcount;
		}
		else	DCirc[i].cnum = 0;
	}
	innerindex = (int*) XtCalloc(N, sizeof(int));
	vcount = 0;
	/* Store the DCirc indices of the circles of variable radii */
	for (i=0; i<hw; ++i)
		if ((DCirc[i].state == INTERIOR)
		|| (DCirc[i].state == DEEPINSIDE))	{
			innerindex[vcount] = i;
			++vcount;
	}
} /* doindexing */
				
getccindices(i, j, mypos)
/* Return in mypos the DCirc coordinates of the six neighbors 
of the (i,j) entry, ordered counterclockwise */
int	i, j, mypos[6][2];
{
	if (i%2 == 0)	{
		mypos[0][0] = i+1;
		mypos[0][1] = j-1;
		mypos[1][0] = i+1;
		mypos[1][1] = j;
		mypos[2][0] = i;
		mypos[2][1] = j+1;
		mypos[3][0] = i-1;
		mypos[3][1] = j;
		mypos[4][0] = i-1;
		mypos[4][1] = j-1;
		mypos[5][0] = i;
		mypos[5][1] = j-1;
	}
	else	{
		mypos[0][0] = i+1;
		mypos[0][1] = j;
		mypos[1][0] = i+1;
		mypos[1][1] = j+1;
		mypos[2][0] = i;
		mypos[2][1] = j+1;
		mypos[3][0] = i-1;
		mypos[3][1] = j+1;
		mypos[4][0] = i-1;
		mypos[4][1] = j;
		mypos[5][0] = i;
		mypos[5][1] = j-1;
	}
} /*getccindices*/

getcindices(i, j, mypos)
/* Return in mypos the DCirc coordinates of the 
six neighbors of the (i,j) entry, ordered clockwise */
int	i, j, mypos[6][2];
{
	if (i%2 == 0)	{
		mypos[5][0] = i+1;
		mypos[5][1] = j-1;
		mypos[4][0] = i+1;
		mypos[4][1] = j;
		mypos[3][0] = i;
		mypos[3][1] = j+1;
		mypos[2][0] = i-1;
		mypos[2][1] = j;
		mypos[1][0] = i-1;
		mypos[1][1] = j-1;
		mypos[0][0] = i;
		mypos[0][1] = j-1;
	}
	else	{
		mypos[5][0] = i+1;
		mypos[5][1] = j;
		mypos[4][0] = i+1;
		mypos[4][1] = j+1;
		mypos[3][0] = i;
		mypos[3][1] = j+1;
		mypos[2][0] = i-1;
		mypos[2][1] = j+1;
		mypos[1][0] = i-1;
		mypos[1][1] = j;
		mypos[0][0] = i;
		mypos[0][1] = j-1;
	}
} /*getcindices*/


getrangerect()
/* Store in umin, vmin, umax, vmax the bounding rectangle of the range */
{
	int 		i, j;
	double		xhigh, yhigh, xlow, ylow;
	double		min1, min2, max1, max2;

	i = nullj+nulli*width;	
	/* Initialize extreme coordinates */
	min1 = max1 = RCirc[i].x;
	min2 = max2 = RCirc[i].y;

	for (i=0; i<numcircles; ++i) {
	/* Get extreme points on circle */
		xhigh = RCirc[circindex[i]].x+RCirc[circindex[i]].r;
		yhigh = RCirc[circindex[i]].y+RCirc[circindex[i]].r;
		xlow = RCirc[circindex[i]].x-RCirc[circindex[i]].r;
		ylow = RCirc[circindex[i]].y-RCirc[circindex[i]].r;
		/* If these points lie outside the current bounding rectangle, update the bounding rectangle */
		if (min1>xlow)	min1 = xlow;
		if (min2>ylow)	min2 = ylow;
		if (max1<xhigh)	max1 = xhigh;
		if (max2<yhigh)	max2 = yhigh;
	}
	umin = min1;
	vmin = min2;
	umax = max1;
	vmax = max2;
} /* getrangerect */


