/* Routine takes a list of projective points and spits out a list */
/* of poincare model points */

#include <stdio.h>
#include <math.h>
#define EPSILON 0.000001

main(argc,argv)

int argc; char *argv[];
{
  FILE *in,*out;
  double x,y,z,pnt[3],rslt[3];
  int total;

  if(argc < 3) { Usage(); exit(0);}

  if(strcmp(argv[1],"-") == 0)  in = stdin;
  else in = fopen(argv[1],"r");
  if(in == NULL) {
    fprintf(stderr,"Cannot open input file %s\n",argv[1]);
    exit(0);
   }

  if(strcmp(argv[2],"-") == 0)  out = stdout;
  else  out = fopen(argv[2],"w");
  if(out == NULL) {
    fprintf(stderr,"Cannot open output file %s\n",argv[2]);
    exit(0);
   }

  total = 0;
  while(1) {
     if(fscanf(in,"%lf %lf %lf",&x,&y,&z) != 3) {
        break;
       }
     total++; fprintf(stderr,".");
     pnt[0] = x; pnt[1] = y; pnt[2] = z;
     if(poinc2proj(pnt,rslt) >= 0)
        fprintf(out,"%lf  %lf  %lf\n",rslt[0],rslt[1],rslt[2]);
    }

  fprintf(stderr,"total of %d points transformed.\n",total);
}


poinc2proj(in,out)

double out[3],in[3];

{
  double factor,r_squared;

  r_squared = in[0]*in[0] + in[1]*in[1] + in[2]*in[2];
  factor = 2.0/(1.0 + r_squared);

  out[0] = in[0]*factor;
  out[1] = in[1]*factor;
  out[2] = in[2]*factor;

  return(1);
}


Usage()

{
  fprintf(stderr,"Usage: poinc2proj infile outfile.\n");
  fprintf(stderr,"  where infile is a list of 3d points.\n");
  fprintf(stderr,"  if infile = '-' then stdin is used.\n");
  fprintf(stderr,"  if outfile = '-' then stdout is used.\n");
}
