#ifndef HPLANE3DEF
#define HPLANE3DEF

typedef float HPl3Coord;
typedef struct { HPl3Coord a, b, c, d; } HPlane3;

extern HPlane3 *HPl3Create();
extern void HPl3Delete(/* HPlane3 *pl */);

extern void HPl3Print(/* HPlane3 *pl */);
extern void HPl3Copy(/* HPlane3 *pl1, *pl2 */);
extern void HPl3From(/* HPlane3 *pl, HPl3Coord a, b, c, d */);
extern int HPl3From3HPt3s(/* HPlane3 *pl, HPoint3 *pt1, *pt1, *pt1 */);
extern int HPl3From2HLn3s(/* HPlane3 *pl, HLine3 *ln1, *ln2 */);

extern int HPl3IntersectHPl3(/* HPlane3 *pl1, *pl2, HLine3 *ln */);
extern void HPl3Pencil(
    /* HPl3Coord t1, HPlane3 pl1, HPl3Coord t2, HPlane3 *pl2, *pl*/);

extern float HPl3DotHPt3(/* HPlane3 *pl, HPoint3 *pt */);

extern HPl3Normalize(/* HPlane2 *pl1, *pl2 */);

extern int HPl3Undefined(/* HPlane3 *pl */);
extern int HPl3Infinity(/* HPlane3 *pl */);
extern int HPl3Compare(/* HPlane3 *pl1, *pl2 */);

extern int HPl3CoincidentHPt3(/* HPlane3 *pl, HPoint3 *pt */);
extern int HPl3CoincidentHLn3(/* HPlane3 *pl, HLine3 *ln */);
extern int HPl3CoincidentHPl3(/* HPlane3 *pl1, *pl2 */);

extern void HPl3Transform(/* Transform3 T, HPlane3 *pl1, *pl2*/);
extern void HPl3TransformN(/* Transform3 T, HPlane3 *pl1, *pl2, int n*/);

extern void HPl3Dual(/* HPlane3 *pl, *HPoint3 *pt */);

/* Identify ideal plane */
extern HPlane3 HPl3Ideal;
extern void HPl3Perp(/* HPlane3 *pl, *HPoint3 *pt */);
extern HPl3Coord HPl3Angle(/* HPlane3 *pl1, *pl2 */);

#endif
