static char RCSid[]="$Header:$" ;
/*
 *  Extract info from dump TS_TAPE   (c) Copyright  Viktor Dukhovni 25/Jan/1989
 *  records.                         This program may be freely redistributed
 *				     in source or binary form, so long as this
 *				     copyright notice remains intact in the 
 *			             source file,  or is acknowledged in 
 *				     documentation supplied with the binary.
 * $Log:$
 */

#include <sys/param.h>
#include <sys/types.h>
#include <errno.h>
extern errno ;
#include <sys/vfs.h>
#include <sys/time.h>
static struct tm *date ;
#include <sys/vnode.h>
#include <ufs/inode.h>
#include <protocols/dumprestore.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
static struct mtop mtop = { MTREW, 1 } ;
#include <sys/stat.h>
static struct stat statbuf ;
#include <fcntl.h>
#include <stdio.h> 

extern char *getenv() ;
extern char *malloc() ;
/*  Do 63k reads or less */
#define BLK 0xfc00
static char buf[BLK] ;

main(argc,argv)
  char **argv ;
{
  char *TAPE ;
  int fd, *check, sum = 0, n ;
  char *end ;
  int lflag = 0 ;
  char *progname=argv[0] ;

  while( --argc && **++argv == '-' ) 
    switch( *++*argv ) {
    case 'l' : 
      lflag++ ;
      break ;
    default: 
      fprintf(stderr,"Unknown option %c\n",**argv) ;
      fprintf(stderr,"Usage: %s [-l]\n",progname) ;
      exit(1) ;
    }

  TAPE=getenv("TAPE") ;
  if ( TAPE == NULL )
    TAPE="/dev/nrxb0" ;

  if( (fd=open(TAPE,O_RDONLY)) == -1 ) {
    perror("Cannot open tape") ;
    exit(1) ;
  }

  n=read(fd,buf,BLK)  ;
  /* Rewind the tape */
  if ( fstat(fd,&statbuf) == 0 && (statbuf.st_mode & S_IFMT) == IFCHR )
    if( ioctl(fd,MTIOCTOP,&mtop)== -1 ) {
      perror(TAPE);
      exit(1) ;
    }
  if( n == -1 )  {
    fprintf(stderr,"Error reading header record!\n") ;
    exit(1) ;
  }
  spcl = *(struct s_spcl *)buf ;
  check = (int *) &spcl ;
  end = (char *) &spcl +sizeof(spcl) ;
  for ( ; (char *)check < end ; )
    sum += *check++ ;
  if ( spcl.c_type  == TS_TAPE     &&
      (spcl.c_magic == OFS_MAGIC||
       spcl.c_magic == NFS_MAGIC ) &&
      sum		== CHECKSUM ) {
      date = localtime(&(spcl.c_date)) ;
      if ( lflag ) {
	printf("Volume %d of dump on %s",
	       spcl.c_volume,
	       ctime(&(spcl.c_date))) ;
	printf("Dumped from: %s",ctime(&(spcl.c_volume))) ;
      } else {
	printf("%02d.%02d.%02d",date->tm_year,++(date->tm_mon),date->tm_mday) ;
      }
    }
  else {
    fprintf(stderr,"Not a dump tape\n") ;
    exit(1) ;
  }
  exit(0) ;
}
