/* ================================================================== 
    Debug.c   This file is used whenever the debug flag is set.
    It contains the functions to print out the entire contents of
    each data structure.  It prints into standard error.  
   ==================================================================*/
#include "macros.h"
#include "structs.h"

/*-------------------------------------------------------------------*/
print_out( v )
struct tvertex *v;
{
	fprintf( stderr, "\nAdding vertex %6x :\n", v );
	print_verts();
	print_edges();
	print_fs();
}

/*------------------------------------------------------------------
       Print_verts prints out the contents of each tvertex structure
   that is in the list.  The address of the vertex is printed,
   then the x, y, and z coordinates is printed. Either a 0 or a 1 is
   printed for the active flag and the value of the pointer in
   hexidecimal is printed for the duplicate pointer. 
  -----------------------------------------------------------------*/
print_verts()
{
	struct tvertex *temp;

	temp = vertices;
	fprintf (stderr, "Vertex List\n");
	if (vertices) do {
            fprintf(stderr,"  addr %6x\t", vertices );
            fprintf(stderr,"(%g,%g,%g)",vertices->v[X],
                    vertices->v[Y], vertices->v[Z] );
            fprintf(stderr,"   active:%3d", vertices->active );
            fprintf(stderr,"   duplicate:%5x", vertices->duplicate );
            fprintf(stderr,"   mark:%2d\n", vertices->mark );
            vertices = vertices->next;
            } while ( vertices != temp );

}

/*-----------------------------------------------------------------------
      Print_edges prints out the information of each tedge structure that
  is in the circular list.  For the pointers adjface and endpts, the
  value of the pointer in hexidecimal is printed ( 0 if it is NULL ).
  The flag deleted is either 0 or 1. The address of the edge is also
  printed.
  ------------------------------------------------------------------------*/
print_edges()
{
	register struct tedge *temp;
	register int i;
	
	temp = edges;
	fprintf (stderr, "Edge List\n");
	if (edges) do {
            fprintf( stderr, "  addr: %6x\t", edges );
            fprintf( stderr, "adj: ");
            for (i=0; i<3; ++i) 
                 fprintf( stderr, "%6x", edges->adjface[i] );
            fprintf( stderr, "  endpts:");
            for (i=0; i<2; ++i) 
                 fprintf( stderr, "%8x", edges->endpts[i]);
            fprintf( stderr, "  del:%3d\n", edges->deleted );
            edges = edges->next; 
            } while (edges != temp );

}

/*----------------------------------------------------------------------
       Print_fs prints out the information of each tface structure
   that is in the circular list.  For the pointers edg and vert the 
   value of the pointer in hexidecimal is printed.  For the flag
   visible either a 0 or a 1 is printed. The address of the face is 
   also printed.
  ---------------------------------------------------------------------*/
print_fs()
{
	register int i;
	register struct tface *temp;

	temp = faces;
	fprintf (stderr, "Face List\n");
	if (faces) do {
            fprintf(stderr, "  addr: %6x\t", faces );
            fprintf(stderr, "  edges:");
            for( i=0; i<3; ++i )
                 fprintf(stderr, "%6x", faces->edg[i] );
            fprintf(stderr, "  vert:");
            for ( i=0; i<3; ++i)
                  fprintf(stderr, "%6x", faces->vert[i] );
            fprintf(stderr, "  vis: %d\n", faces->visible );
            faces= faces->next;
            } while ( faces != temp );

}
