/* automata.d/src file wd.c */
#include <stdio.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "lg.h"
#include "kb.h"

extern FILE * wfile;
lg *WD = 0 ;
int num_wdiffs = 1;
/* the identity is always a word difference */
extern boolean print_kb_rules;
extern boolean print_wdiffs;

static void WDIFFstruct_kill PARMS ((vindex));
static WDIFFstruct * WDIFFstruct_create PARMS ((VOID));
static void WDIFFstruct_print PARMS ((FILE*,vindex));

static int ggv_triple_sgn_dp PARMS ((dp,dp));
static void ggv_triple_cpy_dp PARMS ((dp in, dp out));
static ggv_triple *ggv_triple_create PARMS (());
static void ggv_triple_print_dp PARMS ((FILE*,dp));
static vindex wdiff_insert PARMS ((vindex, gen, gen));

elt_fntab
GGV_TRIPLE_fntab = {
	ggv_triple_sgn_dp,
	ggv_triple_cpy_dp,
	(V2DP)ggv_triple_create,
	Free_dp,
	ggv_triple_print_dp,
	0, /*last two spaces for heap indexes*/
	0
};

mp_fntab
WDIFF_fntab =
{
	0,
	(V2DP)WDIFFstruct_create,
	WDIFFstruct_kill,
	WDIFFstruct_print,
	0,
	0
};


static void
WDIFFstruct_kill(v)
	vindex v;
{
	WDIFFstruct *Wds = (WDIFFstruct *)(v->mp);
	assert(v->mp);
	assert(v->fntab ==WDIFF);
	if (Wds->arrows) {
		list_clear(Wds->arrows);
		Free_dp((dp)(Wds->arrows));
		Wds->arrows = 0;
	}
	Free_dp(v->mp);
	v->mp=0;
}

static WDIFFstruct *
WDIFFstruct_create()
{
	WDIFFstruct * Wds = vzalloc1(WDIFFstruct);
	return Wds; /*if the |arrow| field needs to be defined, we
		will do so explicitly*/
}

static void
WDIFFstruct_print(wfile,v)
	FILE * wfile;
	vindex v;
{
	WDIFFstruct * Wds = (WDIFFstruct *)(v->mp);
	assert(v->fntab ==WDIFF);
	assert(Wds);
	fprintf(wfile,"WDIFF ");
	if (Wds->arrows) {
		fprintf(wfile,"arrows ");
		list_print(wfile,Wds->arrows);
	}
	else
		fprintf(wfile,"No arrows ");
}

/* Find the word differences from two words, and install all new resulting
word differences in the tree of word differences |*WD|.
The number of new word differences is returned.
We assume that the first word is no shorter than the second, and we
only consider word differences going from the first word to the
second. This means that the $i$-th prefix of |*w1p| followed by the
$i$-th word difference is equal in the group to the $i$-th prefix of |*w2p|.
*/

int
wdiffs_from_wpair(w1p,w2p)
	word *w1p, *w2p;
{
	gen g1, g2;
	word wdiff;
	int l;
	int n;
	int recall = 0;
	vindex curr1 = basept(WD);
	word w1, w2;
	recall = num_wdiffs;
	word_init(&wdiff);
	word_init(&w1);
	word_init(&w2);
	word_cpy(w1p,&w1);
	word_cpy(w2p,&w2);
	(void)common_prefix_erased(&w1,&w2);
	l = word_length(&w1) - word_length(&w2);
	n = word_length(&w1);
	assert(l >= 0);
	if (l <= 2) {/*We only want to take into account reduced words
			which end at distance at most one from each other. The
			case when the length differs by two corresponds to the
		situation where, the very last edge of the left hand side
			``turns round''*/
		while (n!=0) {
			(void)word_delget_first(&w1,&g1);
			n--;
			if (!word_delget_first(&w2,&g2))
				g2 = 0;
			curr1 = wdiff_insert(curr1,g1,g2);
			/*reduction gets carried
						out in |wdiff_insert|*/
			assert( curr1 != UNDEFINED);
		}
	}
	word_clear(&wdiff);
	word_clear(&w1);
	word_clear(&w2);
	if ((num_wdiffs - recall)!=0
			&& (print_wdiffs) && print_kb_rules==FALSE){
		fprintf(wfile,"\t\t# from the rule ");
		word_print(wfile,w1p);
		fprintf(wfile,"->");
		word_print(wfile,w2p);
		fprintf(wfile,"\n");
	}
	return num_wdiffs - recall;
}	


/*
Let $w$ be the word corresponding to $v$.
Let $a$ be the address of the vertex corresponding to $g^{-1}wh$
when reduced. Return $a$ and insert the |ggv_triple| $(g,h,a)$ into
the list of triples held at $v$.
*/
static vindex
wdiff_insert(v,g,h)
	vindex v;
	gen g,h;
{
	list *lp;
	ggv_triple ghv;
	word w;
	vindex curr;
	assert(v->fntab ==WDIFF);
	if((lp = get_arrows(v))==0)
		lp = mk_arrows(v);
	word_init(&w);
	vindex2word(v,&w);
	if (g != 0)
		word_put_first(&w,inv(g));
	if (h != 0)
		word_put_last(&w,h);
	(void)reduction(&w,&w);
	curr  = wtree_word_insert(WD,&w);
	mk_ggv_triple(g,h,curr,&ghv);
	(void)list_insert(lp,&ghv);
	if (get_arrows(curr)==0) {/*this is how we tell if the word
					difference is new or old*/
		if (print_wdiffs){
			fprintf(wfile,"\t# new word diff: ");
			word_print(wfile,&w);
			fprintf(wfile,"\n");
		}
		(void)mk_arrows(curr); /*next time we will know this is a
					word difference*/
		num_wdiffs++;/*global variable keeping count of the number*/
	}
	word_clear(&w);
	return curr;
}



static void
ggv_triple_cpy_dp(old_dp,new_dp)
	dp old_dp,new_dp; /*these are really pointers to |ggv_triple|'s*/
{
	ggv_triple *old_triplep= (ggv_triple*)old_dp;
	ggv_triple *new_triplep= (ggv_triple*)new_dp;
	new_triplep->g1 = old_triplep->g1;
	new_triplep->g2 = old_triplep->g2;
	new_triplep->v = old_triplep->v;
}

static ggv_triple*
ggv_triple_create()
{
	return vzalloc1(ggv_triple);
}

static void
ggv_triple_print_dp(wfile,dpp)
	FILE * wfile;
	dp dpp; /*really a |ggv_triple*|*/
{
	word w;
	ggv_triple *gp = (ggv_triple*)dpp;
	fprintf(wfile,"(%d,%d,0x%x)",gp->g1,gp->g2,gp->v);
	word_init(&w);
	vindex2word(gp->v,&w);
	word_print(wfile,&w);
	word_clear(&w);
}

static int
ggv_triple_sgn_dp(dp1,dp2)
	dp dp1, dp2;
{
	ggv_triple *gp1 = (ggv_triple*)dp1;
	ggv_triple *gp2 = (ggv_triple*)dp2;
	int ans = 0;
	if (gp1->g1 < gp2->g1)
		ans = 1;
	else if (gp1->g1 > gp2->g1)
		ans = -1;
	else if (gp1->g2 < gp2->g2)
		ans = 1;
	else if (gp1->g2 > gp2->g2)
		ans = -1;
	return ans;
}

list *
mk_arrows(v)
	vindex v;
{
	WDIFFstruct *Wds = (WDIFFstruct *)(v->mp);
	assert(v->fntab ==WDIFF);
	assert(Wds->arrows == 0);
	Wds->arrows = vzalloc1(list);
	list_init(Wds->arrows,GGV_TRIPLE,ORDERED);
	return Wds->arrows;
}


/* Fill in the given triple at the space pointed to by ghvp.
*/
void
mk_ggv_triple(g,h,v,ghvp)
	gen g,h;
	vindex v;
	ggv_triple *ghvp;
{
	ghvp->g1 = g;
	ghvp->g2 = h;
	ghvp->v = v;
}


/* A special function for creating |WD|. The main reason for this is to
keep |main()| clean.
*/
void
WD_create()
{
	WD = vzalloc1(lg);
	lg_init(WD,WDIFF,BASIC_WTREE,num_gens);
	{ /*single generators are always word differences, due to relators
	of the form $xX$*/
		gen g;
		for (g = 1; g <= num_gens; g++) {
			word w;
			word empty;
			word_init(&w);
			word_init(&empty);
			word_put_first(&w,g);
			word_put_first(&w,inv(g));
			(void)wdiffs_from_wpair(&w,&empty);
			word_clear(&w);
			word_clear(&empty);
		}
	}
}

void
kill_arrows(v)
	vindex v;
{
	WDIFFstruct *Wds = (WDIFFstruct *)(v->mp);
	assert(v->fntab ==WDIFF);
	assert(Wds);
	if (Wds->arrows) {
		list_clear(Wds->arrows);
		Free_dp((dp)(Wds->arrows));
		Wds->arrows = 0;
	}
}
	
