/* automata.d/src file diff2.c */
#include <stdio.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "reduce.h"
#include "input.h"
#include "afsa.h"
#include "reduce.h"
#include "lg.h"

# define DIFF1OP ".diff1"
# define DIFF2OP ".diff2"
FILE * rfile=stdin;
FILE * wfile=stdout;
twoafsa * DIFF=0;
extern word * user_gen_name;
extern gen * inv_of;
extern int gen_array_size;
extern int num_gens;

main(argc,argv)
	int argc;
	char * argv[];
{
	int i;
	int num_wdiffs;
	lg tree;
	word w;
	word wdiff;
	vindex v;
	bfs_traverser ttree;
	bfs_traverser DIFFt;
	lg diff2;
	vindex * vertices;
	char * label;
	char gpname[100];
	char filename[100];

	if (argc>2){
		fprintf(stderr,"Usage: diff2 [gpname]\n");
		exit(2);
	}
	else if (argc==2){
/* the input and output files are being specified as gpname.diff1 and 
gpname.diff2 respectively */
		strcpy(gpname,argv[1]);
		strcpy(filename,gpname);
		strcat(filename,DIFF1OP);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		strcpy(filename,gpname);
		strcat(filename,DIFF2OP);
		wfile=fopen(filename,"w");
	}

	setbuf(stdout, (char*)0);
	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);
	word_init(&w);
	word_init(&wdiff);

	label=vzalloc2(char,9);
	while (read_next_string(label,8,rfile)){
		if (strcmp(label,"Format  ")==0)
			format_echocheck("2.2",rfile,wfile);
		else if (strcmp(label,"fsa     ")==0){
			DIFF=twoafsa_read(&user_gen_name,rfile);
			num_gens = DIFF->base_symbols -1;
		}
		else if (strcmp(label,"inverses")==0)
			read_inverse_array(rfile);
		else if (strcmp(label,"words   ")==0){
			if (inv_of==0)
				default_inverse_array();
			lg_init(&tree,GENERIC,BASIC_WTREE,num_gens);
			while (getc(rfile)!='\{')
				;
			i=1;
			while (read_next_word(&w,rfile)){
				word2prog_word(&w,&wdiff);
				v=wtree_word_trace(&tree,&wdiff);
				if (get_index(v)==0)
					set_index(v,i++);
				else
					fprintf(wfile,"\t#seen this one before\n");
				word_reset(&w);
				word_reset(&wdiff);
			}
			while (getc(rfile)!='\}')
				;
			num_wdiffs=i-1;
		}
	}


	vertices=vzalloc2(vindex,num_wdiffs+1);
	lg_init(&diff2,GENERIC,BASIC_FSA,(num_gens+1)*(num_gens+1));
	vertices[1]=basept(&diff2);
	set_category(vertices[1],2);
/* the basepoint is always a word difference */
	for (i=2;i<=num_wdiffs;i++)
		vertices[i]=lg_vertex_create(&diff2);

	bfs_init(&ttree,&tree);
	while (bfs_next(&ttree,&v)){
		if ((i=get_index(v))!=0){ /* we're at a word difference */
			gen g,h,k;
			vindex2word(v,&wdiff);
			if (word_length(&wdiff)==1){
				word_get_last(&wdiff,&g);
				set_category(vertices[i],2+g);
			}
			else if (i>1) /* exclude the basepoint */
				set_category(vertices[i],NONACCEPTSTATE);	
			for (h=1;h<=num_gens+1;h++){
				for (k=1;k<=num_gens+1;k++){
					vindex x;
					int j;
					word_cpy(&wdiff,&w);
					if (h!=num_gens+1)
						word_put_first(&w,inv(h));
					if (k!=num_gens+1)
						word_put_last(&w,k);
					diff_reduction(DIFF,&w);
					x=lg_word_find(&tree,&w);
				if (x!=UNDEFINED&&((j=get_index(x))!=0)){ 
						/* temp is a word difference */ 
						int z;
						z=(num_gens+1)*(h-1)+k;
					set(vertices[i],z,vertices[j]);
					word_reset(&w);
					}
				}
			}
			word_reset(&wdiff);
		}
	}
	bfs_clear(&ttree);

	word_clear(&wdiff);
	word_clear(&w);
	Free_dp((dp)vertices); vertices=0;
	lg_clear(&tree);
	lg_print(wfile,&diff2);
	lg_clear(&diff2);
	twoafsa_clear(DIFF);
	Free_dp((dp)DIFF); DIFF=0;

	Free_dp((dp)inv_of); inv_of=0;
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name); user_gen_name=0;
	Free_dp((dp)label); label=0;
	assert(store_ptrs==0);
	exit(0);
}

