/* automata.d/src file diff1.c */
#include <stdio.h>
#include <ctype.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "input.h"
#include "lg.h"
#include "kb.h"
#include "afsa.h"
#define DEFAULT 1400

# define PROCRELSOP ".procrels"
# define DIFF1OP ".diff1"
FILE * rfile=stdin;
FILE * wfile=stdout;
FILE * keyboard=0;
list rels;
extern lg * WD;
list * to_be_considered = 0; /*A list of Knuth-Bendix rules which still need
to be compared with all other Knuth-Bendix rules when searching for a
confluent set of rules.*/
list tree_list;
int max_archive_size;
extern int num_gens;
boolean print_kb_rules=FALSE;
boolean print_wdiffs=FALSE;
boolean interactive=FALSE;
extern word * user_gen_name;
extern gen * inv_of;
extern int gen_array_size;	
extern int num_rules;
extern int max_num_rules;
lg *to_add = 0;
lg *being_refined = 0;
lg *archive=0;
list word_diffs;
static void WD_update PARMS((VOID));
static twoafsa * word_difference_machine PARMS((VOID));

main(argc,argv)
	int argc;
	char * argv[];
{
	int i;
	word rel;
	word new_rel;
	twoafsa * DIFF=0;
	char * label;
	char gpname[100];
	char filename[100];
	boolean commandline_parameters=FALSE;

	max_archive_size=DEFAULT;
	assert(INVALID_GEN==0); 
/* initially we need the entries of |user_gen_name| and |inv_of| to be equal 
to |INVALID_GEN|, so it's important that that is equal to zero */

	i=1;
    while (i<argc && argv[i][0]=='-'){
		if (strcmp(argv[i],"-w")==0)
			print_wdiffs=TRUE;
		else if (strcmp(argv[i],"-r")==0)
			print_kb_rules=TRUE;
		else if (strcmp(argv[i],"-i")==0){
			interactive=TRUE;
		}
		else if (argv[i][1]=='k' ||argv[i][1]=='K'){
			int j=0;
			commandline_parameters=TRUE;
			max_archive_size=0;
			i++;
			if (i==argc){
				fprintf(stderr,
					"Usage: diff1 [-w] [-r] [-i] [-k posint] [gpname]\n");
				exit(2);
			}
			while (argv[i][j]!='\0') {
				if (!isdigit(argv[i][j])){
					fprintf(stderr,
						"Usage: diff1 [-w] [-r] [-i] [-k posint] [gpname]\n");
					exit(2);
				}
				max_archive_size = 10*max_archive_size + argv[i][j]-'0';
				j++;
			}
		}
		else {
			fprintf(stderr,"Usage: diff1 [-w] [-r] [-i] [-k posint] [gpname]\n");
			exit(2);
		}
		i++;
	}
	if (i<argc-1){
		fprintf(stderr,"Usage: diff1 [-w] [-r] [-i] [-k posint] [gpname]\n");
		exit(2);
	}
	else if (i==argc-1){
/* the input and output files are being specified as gpname.procrels and 
gpname.diff1 respectively */
		strcpy(gpname,argv[argc -1]);
		strcpy(filename,gpname);
		strcat(filename,PROCRELSOP);
		if ((rfile=fopen(filename,"r"))==0)
  			{ fprintf(stderr,"Cannot open %s.\n",filename); exit(2);}
		strcpy(filename,gpname);
		strcat(filename,DIFF1OP);
		wfile=fopen(filename,"w");
	}

	setbuf(stdout,(char*)0);
	setbuf(stderr,(char*)0);
	setbuf(wfile,(char*)0);

	list_init(&rels,WORD,ORDERED);
	list_init(&word_diffs,WORD,ORDERED);
	label=vzalloc2(char,9);

	while (read_next_string(label,8,rfile)){
		if (strcmp(label,"Format  ")==0)
			format_echocheck("2.2",rfile,wfile);
		else if (strcmp(label,"gens    ")==0 || strcmp(label,"words   ")==0)
			/* The order of the generators is being specified */
			read_gen_name_array(rfile);
		else if (strcmp(label,"inverses")==0)
			read_inverse_array(rfile);
		else if (strcmp(label,"rels    ")==0){
			if (inv_of==0)
				default_inverse_array();
			while (getc(rfile)!='{')
				;
			word_init(&rel);
			word_init(&new_rel);
			while (read_next_word(&rel,rfile)){
				word2prog_word(&rel,&new_rel);
				list_insert(&rels,(dp)&new_rel);
				word_reset(&rel);
				word_reset(&new_rel);
			}
			word_clear(&rel);
			word_clear(&new_rel);
			while (getc(rfile)!='}')
				;
		}
		else if (interactive==FALSE && commandline_parameters==FALSE
		&& strcmp(label,"paramete")==0){
			while (getc(rfile)!='{')
				;
			while (read_next_string(label,8,rfile)){
				if (strcmp(label,"KBtreesi")||strcmp(label,"kbtreesi")){
					read_next_int(&max_archive_size,rfile); 
					break; /* no point in reading any more parameters */
				}
			}
			while (getc(rfile)!= '}')
				;
		}
	}
	
	list_init(&tree_list,LGP,ORDERED); 
	archive = vzalloc1(lg);
	lg_init(archive,KMP,CON_WTREE,num_gens+1);
	to_add_create();
	WD_create();
	to_be_considered=vzalloc1(list);
	list_init(to_be_considered,VINDEX,PQUEUE);
	rels2KB();

	if (interactive) {
		keyboard = fopen("/dev/tty","w");
		fprintf(keyboard,"In interactive mode.\n");
		fprintf(keyboard,"Programme expects parameters input,\n");
		fprintf(keyboard,
	"that is, the keyword KBtreesize followed by a positive integer.\n");
		fprintf(keyboard,"\t Terminate parameter set with a closing \}.\n");
		fprintf(keyboard,"parameters {\n");
		rfile=fopen("/dev/tty","r");
		(void)read_next_string(label,8,rfile);
		if (strcmp(label,"KBtreesi")||strcmp(label,"kbtreesi"))
			read_next_int(&max_archive_size,rfile);	
		else 
			bad_data();
	}
	
	do {
		deal_with(LHS);
		WD_update();
		
fprintf(wfile,"\t# The maximum number of rules at any time was %d\n",max_num_rules);
		fprintf(wfile,"\t# There are currently %d rules\n",num_rules);
		fprintf(wfile,"\t# %d word differences\n",num_wdiffs);
	fprintf(wfile,"\t# Since they were reduced before all rules were found,");
		fprintf(wfile," they are not\n");
		fprintf(wfile,"\t# necessarily distinct in the group\n");
		DIFF=word_difference_machine();
		fprintf(wfile,"\n\t# First word difference machine.\n");
		twoafsa_print(wfile,DIFF);
		twoafsa_clear(DIFF);
		Free_dp((dp)DIFF);
		DIFF=0;

		fprintf(wfile,"inverses \{\n");
		for (i=1;i<=num_gens;i++){
			fprintf(wfile,"inv(");
			gen_print(wfile,i);
			fprintf(wfile,")=");
			gen_print(wfile,inv(i));
			fprintf(wfile," ");
		}
		fprintf(wfile,"\}\n");
	fprintf(wfile,"\t# Set of word differences, together with inverses.\n");
		fprintf(wfile,"words \{\n");
		list_print(wfile,&word_diffs);
		fprintf(wfile,"\}\n");
		if (interactive==FALSE||list_empty(to_be_considered)==TRUE)
			break;
		else 
			list_reset(&word_diffs);
	} while ((read_next_string(label,8,rfile)) &&
			(strcmp(label,"KBtreesi")||strcmp(label,"kbtreesi"))
			&&(read_next_int(&max_archive_size,rfile)));	
		
	if (interactive)
		while (getc(rfile)!='}')
			;
	list_clear(&word_diffs);
	list_clear(to_be_considered);
	Free_dp((dp)to_be_considered); to_be_considered=0;
	lg_clear(archive);
	Free_dp((dp)archive);
	archive=0;
	lg_clear(to_add);
	Free_dp((dp)to_add);
	to_add=0;
	lg_clear(WD);
	Free_dp((dp)WD);
	WD = 0;
	{
		lg * lgp;
		while (list_delget_first(&tree_list,(dp)&lgp)) {
			assert(get_type(lgp) == KMP_WTREE);
			lg_clear(lgp);
			Free_dp((dp)lgp);
			lgp=0;
		}
	}
	list_clear(&tree_list);
	for (i=0;i<gen_array_size;++i)
		word_clear(user_gen_name+i);
	Free_dp((dp)user_gen_name);
	user_gen_name=0;
	Free_dp((dp)inv_of);
	inv_of=0;
	Free_dp((dp)label); label=0;
	list_clear(&rels);
	assert(being_refined == 0);
	assert(to_add == 0);
	assert(store_ptrs==0);
	exit(0);
}


static void
WD_update()
{
	list recompute;
	bfs_traverser tWD;
	vindex t;
	vindex orig = UNDEFINED;
	list_init(&recompute,VINDEX,FIFO);
	bfs_init(&tWD,WD);
	while (bfs_next(&tWD,&t)) {
		if (get_arrows(t))
			(void)list_insert(&recompute,&t);
	}
	bfs_clear(&tWD);
	while(list_delget_first(&recompute,&orig)) {
		vindex red = UNDEFINED;
		list *lp_orig = get_arrows(orig);
		list *lp_red = 0;
		word ws;
		ggv_triple ghv;
		list temp;
		assert(lp_orig);
		list_init(&temp,GGV_TRIPLE,ORDERED);
		while(list_delget_first(lp_orig,&ghv)){
			vindex v1 = ghv.v;
/*we are assuming this has been sensibly set*/
			word wt;
			assert(v1->fntab == WDIFF);
			word_init(&wt);
			vindex2word(v1,&wt);
			if (reduction(&wt,&wt))
				ghv.v = wtree_word_insert(WD,&wt);
			(void)list_insert(&temp,&ghv);
			word_clear(&wt);
		}
	/*Above we are removing items from a list. Below we add items to a list.
		We take care to separate the two processes from each other,
		because the two lists may be equal and we could get into an
		infinite loop if we did both at the same time.*/
		word_init(&ws);
		vindex2word(orig,&ws);
		if(reduction(&ws,&ws)) {
			red = wtree_word_insert(WD,&ws);
			if ((lp_red = get_arrows(red)) == 0)
				lp_red = mk_arrows(red);
			while (list_delget_first(&temp,&ghv))
				(void)list_insert(lp_red,&ghv);
			assert(list_empty(lp_orig));
			assert(lp_red != lp_orig);
			assert(red != orig); 
			kill_arrows(orig);
		}
		else {
			while (list_delget_first(&temp,&ghv))
				(void)list_insert(lp_orig,&ghv);
		}
		word_clear(&ws);
		list_clear(&temp);
	}
	list_clear(&recompute);
}
	
static twoafsa *
word_difference_machine()
{
	twoafsa * DIFF;
	int *** array;
	vindex * wdiffs;
	bfs_traverser bfst;
	int i=1;
	int x,y;
	int N;
	vindex v;
	word w;
	DIFF = vzalloc1(twoafsa);
	twoafsa_init(DIFF);
	
	wdiffs=vzalloc2(vindex,num_wdiffs+1);
	bfs_init(&bfst,WD);
	word_init(&w);
	list_insert(&word_diffs,(dp)&w); 
	/* we want to make sure that the identity is in the list of word 
	differences. With particularly extreme input this isn't otherwise 
	guaranteed */
	while (bfs_next(&bfst,&v))
		if (get_arrows(v)){ /* v is a word difference */
			set_index(v,i);
/* ONLY actual word differences in WD are indexed */
			wdiffs[i++]=v;	
			vindex2word(v,&w);
			list_insert(&word_diffs,(dp)&w);
			word_inv(&w,&w);
			(void)reduction(&w,&w);
			list_insert(&word_diffs,(dp)&w);
		}
	word_clear(&w);
	bfs_clear(&bfst);
	N=i-1; /* num_wdiffs may not be accurate */
	array = vzalloc2(int**,num_gens+2);
	for (x=0;x<=(num_gens+1);x++){
		array[x]=vzalloc2(int*,num_gens + 2);
		for (y=0;y<=num_gens+1;y++)
			array[x][y]=vzalloc2(int,N+1);
	}
	for (i=1;i<=N;i++){	
		list * arr;
		list_traverser t_arr;
		ggv_triple ghv;
		arr=get_arrows(wdiffs[i]);
		list_traverser_init(&t_arr,arr);
		while(list_next(&t_arr,&ghv)){
			if (ghv.g1!=0)
				x=ghv.g1;
			else
				x=num_gens+1;
			if (ghv.g2!=0)
				y=ghv.g2;
			else
				y=num_gens+1;
			array[x][y][i]=get_index(ghv.v);
		}
		list_traverser_clear(&t_arr);
	}
	Free_dp((dp)wdiffs); wdiffs=0;
	DIFF->states=N;
	DIFF->base_symbols=num_gens+1;
	DIFF->symbols=(num_gens+1)*(num_gens+1);
	DIFF->eos=TRUE;
	DIFF->array=array;
	return DIFF;
}
				
