/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

/* Generated by Interface Builder */

#import <appkit/View.h>

@interface FormatView:View
{
  id distributor;
  id imageList;       /* List of images to go on page */
  id labelList;       /* List of labels for images (in same order) */
  id empty;           /* Holds an empty spot in the list */
  int rows, columns;  /* # links comprising the respective dimension */
  float boxWidth, boxHeight, squareLength, xoffset, yoffset;
  id bgimage;         /* Holds image of format view */
  id clearimage;      /* Big white rectangle */

  int selectedBox;
}

- (BOOL) acceptsFirstResponder;
- initFrame:(const NXRect *)frameRect;
- computeBoxes;
- drawSelf: (NXRect *)dRects:(int)dCount;
- getDims:(int *) r :(int *) c;
- updateDims :(int) newrows :(int) newcolumns :(id *) spill :(id *) spillab;
- place:newlist :lablist;
- insertInLists:image :(LabelField *) label;
- (int) findBoxNum:(NXPoint *) pnt;
- mouseDown:(NXEvent *) event;
- (int) findBoxNum:(NXPoint *) pnt;
- getRect:(NXRect *) rect fromNum:(int) num;
- getPoint:(NXPoint *) pnt fromNum:(int) num;
- drawBoxAtPnt:(NXPoint *) pnt :(float) gray;
- resizeLinks;
- unselectBox;
- cut:sender;
- copy:sender;
- paste:sender;
- deleteSelected;
- (int) get_squareLength;

/* File */
- write:(NXTypedStream *) tstream;
- read:(NXTypedStream *) tstream;

@end
